/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdio.h>
#include "aum.h"
#include "aum/tstream.h"
#include "aum/fstream.h"
#include "aum/string.h"
#include "builtin/extern.h"
#include "utils/cconv.h"

void FileStreamObject::TextMode(Boolean t)
{
    is_native = t;
}
Boolean FileStreamObject::TextMode()
{
    return is_native;
}

FileStreamObject* new_FileStreamObject(const char* fname,const char* mode,FILE* fp)
    // {}
    // ե̾⡼ɤȤˣӣãɣ
    // {}
{
    int alloc = roundup(strlen(fname),sizeof(Word))+sizeof(FileStreamObject);
    FileStreamObject* fobj = (FileStreamObject*)SHARED_ALLOC(alloc);
    fobj->Initialize(fname,mode,fp);
    return fobj;
}

Word CreateFileStream(const char* fname,const char* mode)
{
    if (strlen(fname) == 0){
	error(form("file stream allocation %s %s",fname,mode),
	      " filename is null string");
	return INT0;
    }
    if (strlen(mode) == 0){
	error(form("file stream allocation %s %s",fname,mode),
	      " mode is null string");
	return INT0;
    }
    Boolean is_native = FALSE;
    char* work = (char*)mode;
    int cc = 0;
    while (*work) {
	if (*work == 'n') {
	    is_native = TRUE;
	    *work = ' ';
	    break;
	}
	if (cc >= 3) break;
	work++;
	cc++;
    }
    FILE* fp;
    if ((fp = fopen(fname,mode)) == (FILE*)NULL){
	error(form(" file open %s %s",fname,mode),
	      " Can't open %s for %s",fname,mode);
	return INT0;
    }
    FileStreamObject* fobj = new_FileStreamObject (fname, mode, fp);
    fobj->TextMode(is_native);
    return ObjectWord(fobj);
}

long FileStreamObject::Fseek(int size, int pos)
{
    return fseek(fp,(long)size,pos);
}

void FileStreamObject::Free()
{
    if (fp)
	fclose (fp);
    SHARED_FREE ((void*) name, strlen(name)+1);
    SHARED_FREE (this, sizeof( FileStreamObject));
}

Name FileStreamObject::Print()
{
    char buff[BUFSIZ];
    tstream tout = tstream(BUFSIZ,buff);
    if (ShowRC) {
	u_short rc = LRC ();
	tout.form("%d", rc);
    }
    tout.form("$file{\"%s\",\"%s\"}", name, mode);
    return tout.Result();
}

Word FileStreamObject::Iseof()
{
    return (0 != feof(fp)) ? BOOLTRUE:BOOLFALSE;
}

void FileStreamObject::Ungetc(const u_short x)
{
    long back = 1;
    if (!is_native){
	if (IsEUC(x)){
	    back++;
	}
    }
    long locate = ftell(fp)-back;
    if (locate !=(long)0)
	fseek(fp,locate,0);
}

Word FileStreamObject::Gets()
{
    unsigned char buff[BUFSIZ];
    unsigned char *buffeuc;
    if ((char*)NULL == fgets((char*)buff,BUFSIZ,fp))
	return INT0;
	buffeuc = jis_to_euc(buff);
    if (is_native) {
	return CreateASCIIString((char*)buffeuc);
    } else {
	if (strlen((char*)buffeuc)!=jstrlen(buffeuc)){
	    return CreateEUCString(buffeuc);
	}else{
	    return CreateASCIIString((char*)buffeuc);
	}
    }
}

char* FileStreamObject::GetCstring()
{
    unsigned char buff[BUFSIZ];
    if (fgets((char*)buff,BUFSIZ,fp) == (char*)NULL)
	return (char*)NULL;
    return (char*)jis_to_euc((unsigned char*)buff);
}

void FileStreamObject::Tab(const int x)
{
    for (int i = 0; i<=x;i++)
	fputc(' ',fp);
}

void FileStreamObject::Putc(Word& x)
{
    unsigned int p = (unsigned int)Fix2Int(x);
    if (0 != (p & 0xff00))
	putc((p>>8) & 0xff, fp);
    putc(p & 0xff, fp);
}

void FileStreamObject::Puts(const char* x)
{
    fputs(x,fp);
}

void FileStreamObject::Initialize(const char* fn,const char* mo,FILE* f)
{
    Header::Initialize(FILE_STREAM,1);
    nchars = strlen(fn);
    nbytes = roundup(nchars,sizeof(Word))+sizeof(FileStreamObject);
    fp = f;
    name = fn;
    strcpy(mode,mo);
}

void FileStreamObject::Flush()
{
    fflush(fp);
}

Word FileStreamObject::Get()
{
    char c1;
    c1 = fgetc(fp);
    return Int2Fix(c1);
}

Word FileStreamObject::Getc()
{
    int c1;
    c1 = fgetc(fp);
    if (!is_native) {
	int w = c1;
	if (w > DEL) {
	    if (w < SJC){
		/*shift jis*/
		int c2 = fgetc(fp) ;
		if (c2 > SJS) {
		    int s = (w <= 0x9f) ? 0x00e1 : 0x0161;
		    w *= 2;
		    w -= s;
		    int sec = c2;
		    if (sec >= 0x9f){
			sec = sec - 0x7e;
			w++;
		    }else{
			int sp = (sec > DEL) ? 32 : 31;
			sec = sec - sp;
		    }
		    int ret = (((w & 0x7f) | 0x080)<<8) + ((sec & 0x7f) | 0x080);
		    return Int2Fix(ret);
		}
	    }else if (w < EJC) {
		int c2 = fgetc(fp) ;
		/*euc*/
		return Int2Fix((((w & 0x7f) | 0x080)<<8) + ((c2 & 0x7f) | 0x080));
	    }
	}
    }
    return Int2Fix(c1);
}

void FileStreamObject::Put(Word & x)
{
    fputs(print(x),fp);
}

void FileStreamObject::Fclose()
{
    /* empty */
}

int FileStreamObject::no_of_bytes()
{
    return nbytes;
}

int FileStreamObject::no_of_chars()
{
    return nchars;
}

int FileStreamObject::Copyfrom(FileStreamObject* from)
{
    memcpy(this,from,from->no_of_bytes());
    return nbytes/sizeof(Word);
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/

