/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "config.h"

#include <stddef.h>
#include <sys/types.h>
#ifndef NO_SYS_FCNTL_H
#include <unistd.h>
#endif
#include "aum/stdlib.h"
#include "aum/fetch.h"
#include "aum/merger.h"
#include "aum/fstream.h"
#include "aum/protocolid.h"
#include "builtin/extern.h"

void fseek(Word x, Word y, Word z)
{
    FileStreamObject* fst = (FileStreamObject*)Pointer(x);
    if (((long)-1) == fst->Fseek(Fix2Int(y),Fix2Int(z))){
	error(form("fseek %s %s %s",print(x),print(y),print(z)),
	      "Can't file seek ");
    }
}

void doFseek_with_fixnum(Word x, Word y, Word z)
{
    if (IsFixnum(z)){
	lseek(x,y,z);
	return;
    }
    error(form("lseek %s %s %s",print(x),print(y),print(z)),
	  form("Can't coerce %s to INTEGER ",print(z)));
}

void doFseek_with_filestream(Word x, Word y, Word z)
{
    if (IsFixnum(y)){
	doFseek_with_fixnum(x,y,z);
	return ;
    }
    error(form("lseek %s %s %s",print(x),print(y),print(z)),
	  form("Can't coerce %s to INTEGER ",print(y)));
}
void doFseek(Word x, Word y, Word z)
    // {} @ METHOD BEGIN
    // {} @ CLASS file
    // {} @ NOTATION X:fseek(Y,Z)
    // {} @ EXPLANATION
    // Y  ZʤXΥեݥ󥿤ꤷ֤˰ư롥
    // եݥ󥿤ΰ֤ȤϡϤ뤤Ͻϱ黻ΰ֤ɽ
    // Yμͤϳϰ Z ΥХȿǤ롥ϰ֤Z
    // ͤˤʲͤƤ롥
    // @table @samp
    // @item 0
    // եƬΥХȿ
    // @item 1
    // եθ֤߰ΥХȿ
    // @item 2
    // եκǸ夫ΥХȿ
    // @end table
    // YZ ̤³Υ祤Ȥξ硤³ޤԤġ
    // {} @ METHOD END
{
    x = Dereference (x);
    if (IsUndefined  (x)){
	SendBuiltinMessage3(x,PID_FSEEK,y,z);
	return ;
    }
    if (IsFStream(x)){
	doFseek_with_filestream(x,y,z);
	return;
    }
    error(form("lseek %s",print(x),print(y),print(z)),
	  form("Can't coerce %s to FILE STREAM ",print(x)));
}

METHOD(fseek, R3_OP)
    // {}
    // fseek Rstream, Rbytes, Rpos
    // {}
    // [	   address ]
    // [  Rs|		  0]
    // {}
    // Rstream Υե֤ Rpos ˽ä Rbytes ư롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    Word y = Reg[ip->b1];
    Word z = Reg[ip->b2];
    doFseek (x, y, z);
    doClose (x);
    doClose (y);
    doClose (z);
    JumpNextInstruction();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
