/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdio.h>
#include <math.h>
#include "aum.h"
#include "aum/fstream.h"
#include "aum/bool.h"
#include "aum/tstream.h"
#include "aum/protocolid.h"
#include "aum/string.h"
#include "aum/vector.h"
#include "builtin/extern.h"
#include "mathematics/ext-conv.h"

#define IsOverFlowInteger(x) ((x) != Fix2Int(Int2Fix(x)))
#define IsOverFlowFloat(x) ((x) != Single2float(float2Single(x)))

#define SCANMAX	     256
#define ATOM_QUATE   '|'
#define STRING_QUATE '\"'
Word	objbuff[SCANMAX];

Word  scan_float(int fl,int ud,FileStreamObject* fp)
{
    double ret	 = 0;
    double sign	 = 1;
    double esign = 1;
    double base	 = 0;

    unsigned int letter;
    int under = ud;
    int top = fl-ud;
    int exp = 0;
    if (fp->Iseof() == BOOLTRUE) return INT0;
    letter = (unsigned int)Fix2Int(fp->Getc());
 loop:
    if (fp->Iseof() == BOOLTRUE)
	return INT0;
    if ((letter == ' ')||(letter == '\t')||(letter == SPACE)){
	letter = Fix2Int(fp->Getc());
	goto loop;
    }
    if ((letter == '+')||(letter == PLUS)){
	goto loop2;
    }
    if ((letter == '-')||(letter == MINUS)){
	sign = -1;
	goto loop2;
    }
    if ((letter >= '1')&&(letter <= '9')){
	ret = ret*10+letter-'0';
	letter = Fix2Int(fp->Getc());
	goto loop2;
    }
    return INT0;
 loop2:
    if (top == 0){
	fp->Ungetc(letter);
	return CreateDFloat(ret*sign);
    }
    top--;
    if (fp->Iseof() == BOOLTRUE)
	return CreateDFloat(ret*sign);
    if ((letter >= ZERO)&&(letter <= NINE)){
	ret = ret*10+letter-ZERO;
	letter = Fix2Int(fp->Getc());
	goto loop2;
    }
    if ((letter >= '0')&&(letter <= '9')){
	ret = ret*10+letter-'0';
	letter = Fix2Int(fp->Getc());
	goto loop2;
    }
    if ((letter == 'f')||(letter == 'F')){
	float f = ret*sign;
	if (f != Single2float(float2Single(f))){
	    error(form("fscanf(float)"),
		  "Over flow Convert to single float %f",f);
	    return INT0;
	}
	return float2Single(f);
    }
    if ((letter == FSMALL)||(letter == FLARGE)){
	float f = ret*sign;
	if (f != Single2float(float2Single(f))){
	    error(form("fscanf(float)"),
		  "Over flow Convert to single float %f",f);
	    return INT0;
	}
	return float2Single(f);
    }
    if ((letter == '.')||(letter == POINT)){
	base = 0.1;
	goto loop3;
    }
    fp->Ungetc(letter);
    return CreateDFloat(ret*sign);
 loop3:
    if (under == 0){
	fp->Ungetc(letter);
	return CreateDFloat(ret*sign);
    }
    under--;
    if (fp->Iseof() == BOOLTRUE)
	return CreateDFloat(ret*sign);
    letter = Fix2Int(fp->Getc());
    if ((letter >= ZERO)&&(letter <= NINE)){
	ret = ret+(letter-ZERO)*base;
	base /= 10;
	letter = Fix2Int(fp->Getc());
	if ((letter == 'e')||(letter == 'E')){
	    goto loop4;
	}
	if ((letter == ESMALL)||(letter == ELARGE)){
	    goto loop4;
	}
	goto loop3;
    }
    if ((letter >= '0')&&(letter <= '9')){
	ret = ret+(letter-'0')*base;
	base /= 10;
	letter = Fix2Int(fp->Getc());
	if ((letter == 'e')||(letter == 'E')){
	    goto loop4;
	}
	if ((letter == ESMALL)||(letter == ELARGE)){
	    goto loop4;
	}
	goto loop3;
    }
    if ((letter == 'f')||(letter == 'F')){
	float f = ret*sign;
	if (f != Single2float(float2Single(f))){
	    error(form("fscanf(float)"),
		  "Over flow Convert to single float %f",f);
	    return INT0;
	}
	return float2Single(f);
    }
    if ((letter == FSMALL)||(letter == FLARGE)){
	float f = ret*sign;
	if (f != Single2float(float2Single(f))){
	    error(form("fscanf(float)"),
		  "Over flow Convert to single float %f",f);
	    return INT0;
	}
	return float2Single(f);
    }
    fp->Ungetc(letter);
    return CreateDFloat(ret*sign);
 loop4:
    if (fp->Iseof() == BOOLTRUE)
	return CreateDFloat(ret*sign);
    letter = Fix2Int(fp->Getc());
    if ((letter == '+')||(letter == PLUS)){
	goto loop5;
    }
    if ((letter == '-')||(letter == MINUS)){
	esign = -1;
	goto loop5;
    }
    fp->Ungetc(letter);
    return CreateDFloat(ret*sign);
 loop5:
    if (fp->Iseof() == BOOLTRUE)
	return CreateDFloat(ret*sign*pow(10,(double)(esign*exp)));
    letter = Fix2Int(fp->Getc());
    if ((letter >= ZERO)&&(letter <= NINE)){
	exp  = exp*10+letter - ZERO;
	goto loop5;
    }
    if ((letter >= '0')&&(letter <= '9')){
	exp  = exp*10+letter - '0';
	goto loop5;
    }
    fp->Ungetc(letter);
    return CreateDFloat(ret*sign*pow(10,(double)(esign*exp)));
}

Word scan_hex(int length,FileStreamObject* fp)
{
    int ret = 0;
    int len;
    if (length > 7){
	len = 7;
    }else{
	len = length;
    }
    unsigned int letter;
    if (fp->Iseof() == BOOLTRUE) return INT0;
    letter = (unsigned int)Fix2Int(fp->Getc());
 loop:
    if (fp->Iseof() == BOOLTRUE) return INT0;
    if ((letter == ' ')||(letter == '\t')||(letter == SPACE)){
	letter = Fix2Int(fp->Getc());
	goto loop;
    }
    if ((letter == ZERO)||(letter == '0')){
	if (len>0)len++;
    }
 loop2:
    if (fp->Iseof() == BOOLTRUE) return Int2Fix(ret);
    if (len == 0){
	fp->Ungetc(letter);
	return Int2Fix(ret);
    }
    if ((letter >= ZERO)&&(letter <= NINE)){
	int before = ret;
	ret = ret*0x10+letter-ZERO;
	if (IsOverFlowInteger(ret))
	    return Int2Fix(before);
	letter = Fix2Int(fp->Getc());
	len--;
	goto loop2;
    }
    if ((letter >= ASMALL)&&(letter <= FSMALL)){
	int before = ret;
	ret = ret*0x10+letter-ASMALL+ 0xa;
	if (IsOverFlowInteger(ret))
	    return Int2Fix(before);
	letter = Fix2Int(fp->Getc());
	len--;
	goto loop2;
    }
    if ((letter >= ALARGE)&&(letter <= FLARGE)){
	int before = ret;
	ret = ret*0x10+letter-ALARGE+ 0xa;
	if (IsOverFlowInteger(ret))
	    return Int2Fix(before);
	letter = Fix2Int(fp->Getc());
	len--;
	goto loop2;
    }
    if ((letter >= '0')&&(letter <= '9')){
	int before = ret;
	ret = ret*0x10+letter-'0';
	if (IsOverFlowInteger(ret))
	    return Int2Fix(before);
	letter = Fix2Int(fp->Getc());
	len--;
	goto loop2;
    }
    if ((letter >= 'a')&&(letter <= 'f')){
	int before = ret;
	ret = ret*0x10+letter-'a'+ 0xa;
	if (IsOverFlowInteger(ret))
	    return Int2Fix(before);
	letter = Fix2Int(fp->Getc());
	len--;
	goto loop2;
    }
    if ((letter >= 'A')&&(letter <= 'F')){
	int before = ret;
	ret = ret*0x10+letter-'a'+ 0xa;
	if (IsOverFlowInteger(ret))
	    return Int2Fix(before);
	letter = Fix2Int(fp->Getc());
	len--;
	goto loop2;
    }
    if ((letter == 'X')||(letter == 'x')){
	letter = Fix2Int(fp->Getc());
	goto loop2;
    }
    if ((letter == XLARGE)||(letter == XSMALL)){
	letter = Fix2Int(fp->Getc());
	goto loop2;
    }
    fp->Ungetc(letter);
    return  Int2Fix(ret);
}

Word scan_oct(int length,FileStreamObject* fp)
{
    int ret = 0;
    int len = -1;
    if ((length > 10)||(length < 0)){
	len = 10;
    }else{
	len = length;
    }
    unsigned int letter;
    if (fp->Iseof() == BOOLTRUE) return INT0;
    letter = (unsigned int)Fix2Int(fp->Getc());
 loop:
    if (fp->Iseof() == BOOLTRUE) return INT0;
    if ((letter == ' ')||(letter == '\t')||(letter == '\n')||
	(letter == SPACE)){
	letter = Fix2Int(fp->Getc());
	goto loop;
    }
    if ((letter >= ZERO)&&(letter <= ZERO+7)){
	goto loop2;
    }
    if ((letter >= '0')&&(letter <= '7')){
	goto loop2;
    }
    return INT0;
 loop2:
    if (fp->Iseof() == BOOLTRUE) return	 Fix2Int(ret);
    if (len == 0){
	return	Fix2Int(ret);
	fp->Ungetc(letter);
    }
    if ((letter >= ZERO)&&(letter <= ZERO+7)){
	int before = ret;
	ret = ret*8+letter-ZERO;
	if (IsOverFlowInteger(ret))
	    return Int2Fix(before);
	letter = Fix2Int(fp->Getc());
	len--;
	goto loop2;
    }
    if ((letter >= '0')&&(letter <= '7')){
	int before = ret;
	ret = ret*8+letter-'0';
	if (IsOverFlowInteger(ret)){
	    return Int2Fix(before);
	}
	letter = Fix2Int(fp->Getc());
	len--;
	goto loop2;
    }
    fp->Ungetc(letter);
    return  Int2Fix(ret);
}

Word scan_dec(int len,FileStreamObject* fp)
{
    int ret = 0;
    int sign = 1;
    int length;
    if (len < 0){
	length = 8;
    }else{
	length = len;
    }
    unsigned int letter;
    if (fp->Iseof() == BOOLTRUE) return INT0;
    letter = (unsigned int)Fix2Int(fp->Getc());
 loop:
    if (fp->Iseof() == BOOLTRUE) return INT0;
    if ((letter == '-')||(letter == MINUS)){
	sign = -1;
	len--;
	letter = Fix2Int(fp->Getc());
	goto loop2;
    }
    if ((letter == '+')||(letter == PLUS)){
	sign = -1;
	len--;
	letter = Fix2Int(fp->Getc());
	goto loop2;
    }
    if ((letter == ' ')||(letter == '\t')||(letter == '\n')||
	(letter == SPACE)){
	letter = Fix2Int(fp->Getc());
	goto loop;
    }
    if ((letter == ZERO)||(letter == '0')){
	return Int2Fix(0);
    }
 loop2:
    if (fp->Iseof() == BOOLTRUE) return Int2Fix(sign*ret);
    if (len == 0){
	fp->Ungetc((u_short)letter);
	return Int2Fix(sign*ret);
    }
    if ((letter >= ZERO)&&(letter <= NINE)){
	int before = ret;
	ret = ret*10+letter-ZERO;
	if (IsOverFlowInteger(ret)){
	    error(form("fscanf(dec)"),
		  "Too large Integer String scanning %d",before);
	    return Int2Fix(before);
	}
	letter = Fix2Int(fp->Getc());
	len--;
	goto loop2;
    }
    if((letter >= '0')&&(letter <= '9')){
	int before = ret;
	ret = ret*10+letter-'0';
	if (IsOverFlowInteger(ret)){
	    error(form("fscanf(dec)"),
		  "Too large Integer String scanning %d",before);
	    return Int2Fix(before);
	}
	letter = Fix2Int(fp->Getc());
	len--;
	goto loop2;
    }
    fp->Ungetc((u_short)letter);
    return Int2Fix(sign*ret);
}

void skip_string(FileStreamObject* fp)
{
    unsigned int letter;
 loop:
    if (fp->Iseof() == BOOLTRUE) return;
    letter = (unsigned int)Fix2Int(fp->Getc());
    switch(letter){
    case ' ':
    case '\t':
    case '\n':
    case SPACE:
	goto loop;
	break;
    default:
	break;
    }
 loop2:
    if (fp->Iseof() == BOOLTRUE) return;
    letter = (unsigned int)Fix2Int(fp->Getc());
    switch(letter){
    case ' ':
    case '\t':
    case SPACE:
	break;
    default:
	goto loop2;
	break;
    }
    fp->Ungetc(letter);
}

Word scan_string(int full,FileStreamObject* fp)
{
    Word ret;
    tstream tout = tstream();
    unsigned int letter;
    Boolean iseuc = FALSE;
    int leng = -1;
    if (full != -1) leng = full;
 loop:
    if (fp->Iseof() == BOOLTRUE) return INT0;
    letter = (unsigned int)Fix2Int(fp->Getc());
    switch(letter){
    case ' ':
    case '\t':
    case '\n':
    case SPACE:
	goto loop;
	break;
    default:
	break;
    }
    if (IsEUC(letter)){
	tout.put((char)((letter>>8)&0xff));
	tout.put((char)(letter&0xff));
	iseuc = TRUE;
    }else{
	tout.put((char)(letter&0xff));
    }
    leng--;
 loop2:
    if (fp->Iseof() == BOOLTRUE){
	tout.Initialize();
	return INT0;
    }
    letter = (unsigned int)Fix2Int(fp->Getc());
    if (leng == 0){
	fp->Ungetc(letter);
	if (iseuc)
	    ret = CreateEUCString((unsigned char*)tout.Result());
	else
	    ret =  CreateASCIIString(tout.Result());
	tout.Initialize();
	return ret;
    }
    switch(letter){
    case ' ':
    case '\t':
    case '\n':
    case SPACE:
	break;
    default:
	if (IsEUC(letter)){
	    tout.put((char)((letter>>8)&0xff));
	    tout.put((char)(letter&0xff));
	    iseuc = TRUE;
	}else{
	    tout.put((char)(letter&0xff));
	}
	leng--;
	goto loop2;
	break;
    }
    fp->Ungetc(letter);
    if (iseuc)
	ret = CreateEUCString((unsigned char*)tout.Result());
    else
	ret =  CreateASCIIString(tout.Result());
    tout.Initialize();
    return ret;
}

Boolean MemberOfLetterSet(char* sbuf,int slen,char c)
{
    if ((*sbuf>c)||(*(sbuf+slen-1)<c)) return FALSE;
    int left = slen;
    int right = 0;
 loop:
    if (left == right) return FALSE;
    if (*(sbuf+(left+right)/2) < c){
	right = (left+right)/2;
	goto loop;
    }
    if (*(sbuf+(left+right)/2) > c){
	left = (left+right)/2;
	goto loop;
    }
    return TRUE;
}

Boolean MemberOfLetterSet(u_short* sbuf,int slen,u_short c)
{
    if ((*sbuf>c)||(*(sbuf+slen-1)<c)) return FALSE;
    int left = slen;
    int right = 0;
 loop:
    if (left == right) return FALSE;
    if (*(sbuf+(left+right)/2) < c){
	right = (left+right)/2;
	goto loop;
    }
    if (*(sbuf+(left+right)/2) > c){
	left = (left+right)/2;
	goto loop;
    }
    return TRUE;
}

Word member_scan_string(char* sbuf,int slen,FileStreamObject* fp)
{
    Word ret;
    tstream tout = tstream();
    unsigned int letter;
 loop:
    if (fp->Iseof() == BOOLTRUE) return INT0;
    letter = (unsigned int)Fix2Int(fp->Getc());
    switch(letter){
    case ' ':
    case '\t':
    case '\n':
    case SPACE:
	goto loop;
	break;
    default:
	break;
    }
 loop2:
    if (IsEUC(letter)){
	fp->Ungetc(letter);
	ret =  CreateASCIIString(tout.Result());
	tout.Initialize();
	return ret;
    }
    if (MemberOfLetterSet(sbuf,slen,(char)letter)){
	tout.put((char)letter);
	if (fp->Iseof() == BOOLTRUE) {
	    ret = CreateASCIIString(tout.Result());
	    tout.Initialize();
	    return ret;
	}
	letter = (unsigned int)Fix2Int(fp->Getc());
	goto loop2;
    }
    fp->Ungetc(letter);
    ret =  CreateASCIIString(tout.Result());
    tout.Result();
    return ret;
}

Word not_member_scan_string(char* sbuf,int slen,FileStreamObject* fp)
{
    Word ret;
    tstream tout = tstream();
    unsigned int letter;
 loop:
    if (fp->Iseof() == BOOLTRUE) return INT0;
    letter = (unsigned int)Fix2Int(fp->Getc());
    switch(letter){
    case ' ':
    case '\t':
    case '\n':
    case SPACE:
	goto loop;
	break;
    default:
	break;
    }
 loop2:
    if (IsEUC(letter)){
	fp->Ungetc(letter);
	ret =  CreateASCIIString(tout.Result());
	tout.Initialize();
	return ret;
    }
    if (!MemberOfLetterSet(sbuf,slen,(char)letter)){
	tout.put((char)letter);
	if (fp->Iseof() == BOOLTRUE)
	    return CreateASCIIString(tout.Result());
	letter = (unsigned int)Fix2Int(fp->Getc());
	goto loop2;
    }
    fp->Ungetc(letter);
    ret = CreateASCIIString(tout.Result());
    tout.Result();
    return ret;
}

Word member_scan_string(u_short* sbuf,int slen,FileStreamObject* fp)
{
    Word ret;
    unsigned int letter;
    tstream tout = tstream();
    Boolean eucflag = FALSE;
 loop:
    if (fp->Iseof() == BOOLTRUE) return INT0;
    letter = (unsigned int)Fix2Int(fp->Getc());
    switch(letter){
    case ' ':
    case '\t':
    case '\n':
    case SPACE:
	goto loop;
	break;
    default:
	break;
    }
 loop2:
    if (MemberOfLetterSet(sbuf,slen,(u_short)letter)){
	if (IsEUC((u_short)letter)){
	    eucflag = TRUE;
	    tout.put((char)((letter>>8)&0xff));
	}
	tout.put((char)(letter&0xff));
	if (fp->Iseof() == BOOLTRUE){
	    if (eucflag)
		ret =  CreateEUCString((unsigned char*)tout.Result());
	    else
		ret =  CreateASCIIString(tout.Result());
	    tout.Result();
	    return ret;
	}
	letter = (unsigned int)Fix2Int(fp->Getc());
	goto loop2;
    }
    fp->Ungetc(letter);
    if (eucflag)
	ret = CreateEUCString((unsigned char*)tout.Result());
    else
	ret = CreateASCIIString(tout.Result());
    tout.Initialize();
    return ret;
}

Word not_member_scan_string(u_short* sbuf,int slen,FileStreamObject* fp)
{
    Word ret;
    tstream tout = tstream();
    unsigned int letter;
    Boolean eucflag = FALSE;
 loop:
    if (fp->Iseof() == BOOLTRUE) return INT0;
    letter = (unsigned int)Fix2Int(fp->Getc());
    switch(letter){
    case ' ':
    case '\t':
    case '\n':
    case SPACE:
	goto loop;
	break;
    default:
	break;
    }
 loop2:
    if (!MemberOfLetterSet(sbuf,slen,(u_short)letter)){
	if (IsEUC((u_short)letter)){
	    eucflag = TRUE;
	    tout.put((char)((letter>>8)&0xff));
	}
	tout.put((char)(letter&0xff));
	if (fp->Iseof() == BOOLTRUE){
	    if (eucflag)
		return CreateEUCString((unsigned char*)tout.Result());
	    else
		return CreateASCIIString(tout.Result());
	}
	letter = (unsigned int)Fix2Int(fp->Getc());
	goto loop2;
    }
    fp->Ungetc(letter);
    if (eucflag)
	ret = CreateEUCString((unsigned char*)tout.Result());
    else
	ret = CreateASCIIString(tout.Result());
    tout.Initialize();
    return ret;
}

Word scan_atom(int full,FileStreamObject* fp)
{
    Word ret;
    Boolean quated = FALSE;
    tstream tout = tstream();
    int leng = (full > -1) ? full : -1;
    unsigned int letter;
    // ǽζɤФ
 loop:
    if (fp->Iseof() == BOOLTRUE) return INT0;
    letter = (unsigned int)Fix2Int(fp->Getc());
    switch(letter){
    case ' ':
    case '\t':
    case '\n':
    case SPACE:
	goto loop;
	break;
    case ATOM_QUATE:
	quated = TRUE;
	letter = (unsigned int)Fix2Int(fp->Getc());
	break;
    default:
	break;
    }
 loop2:
    if (leng == 0){
	fp->Ungetc(letter);
	ret = InternAtom(tout.Result());
	tout.Initialize();
	return ret;
    }
    leng--;
    if (quated){
	if (letter != ATOM_QUATE){
	    if (IsEUC(letter)){
		tout.put((letter>>8)&0xff);
	    }
	    tout.put(letter&0xff);
	    if (fp->Iseof() == BOOLTRUE) return InternAtom(tout.Result());
	    letter = (unsigned int)Fix2Int(fp->Getc());
	    goto loop2;
	}else{
	    ret = InternAtom(tout.Result());
	    tout.Initialize();
	    return ret;
	}
    }else{
	switch(letter){
	case ' ':
	case '\t':
	case '\n':
	case SPACE:
	    break;
	default:
	    if (IsEUC(letter)){
		tout.put((letter>>8)&0xff);
	    }
	    tout.put(letter&0xff);
	    if (fp->Iseof() == BOOLTRUE) return InternAtom(tout.Result());
	    letter = (unsigned int)Fix2Int(fp->Getc());
	    goto loop2;
	    break;
	}
    }
    fp->Ungetc(letter);
    ret = InternAtom(tout.Result());
    tout.Initialize();
    return ret;
}

Word scan_bool(FileStreamObject* fp)
{
    unsigned int letter;
    // ǽζɤФ
 loop:
    if (fp->Iseof() == BOOLTRUE) return INT0;
    letter = (unsigned int)Fix2Int(fp->Getc());
    switch(letter){
    case ' ':
    case '\t':
    case '\n':
    case SPACE:
	goto loop;
	break;
    default:
	break;
    }
    if (letter ==  '`'){
	if (fp->Iseof() == BOOLTRUE) return INT0;
	letter = (unsigned int)Fix2Int(fp->Getc());
	if (letter == 't'){
	    if (fp->Iseof() == BOOLTRUE) return INT0;
	    letter = (unsigned int)Fix2Int(fp->Getc());
	    if (letter == 'r'){
		if (fp->Iseof() == BOOLTRUE) return INT0;
		letter = (unsigned int)Fix2Int(fp->Getc());
		if (letter == 'u'){
		    if (fp->Iseof() == BOOLTRUE) return INT0;
		    letter = (unsigned int)Fix2Int(fp->Getc());
		    if (letter == 'e'){
			return BOOLTRUE;
		    }
		}
	    }
	    return INT0;
	}else if (letter == 'f'){
	    if (fp->Iseof() == BOOLTRUE) return INT0;
	    letter = (unsigned int)Fix2Int(fp->Getc());
	    if (letter == 'a'){
		if (fp->Iseof() == BOOLTRUE) return INT0;
		letter = (unsigned int)Fix2Int(fp->Getc());
		if (letter == 'l'){
		    if (fp->Iseof() == BOOLTRUE) return INT0;
		    letter = (unsigned int)Fix2Int(fp->Getc());
		    if (letter == 's'){
			if (fp->Iseof() == BOOLTRUE) return INT0;
			letter = (unsigned int)Fix2Int(fp->Getc());
			if (letter == 'e'){
			    return BOOLTRUE;
			}
		    }
		}
	    }
	    return INT0;
	}
    }else if (letter == 't'){
	return BOOLTRUE;
    }else if (letter == 'f'){
	return BOOLFALSE;
    }
    return INT0;
}

Word scan_char(FileStreamObject* fp)
{
    if (fp->Iseof() == BOOLTRUE) return INT0;
    return fp->Getc();
}

int insert(char* sbuf,int leng,char c)
{
    if (leng == 0){
	*sbuf = c;
	return 1;
    }
    int count;
    for (count = 0;(c < *sbuf)&&(count < leng);count++,sbuf++);
    if (count == leng-1){
	if (c < *sbuf){
	    *(sbuf+1) = *sbuf;
	    *sbuf = c;
	   return ++leng;
	}else{
	    *(++sbuf) = c;
	    return ++leng;
	}
    }
    char work = *sbuf;
    char work2;
    *sbuf = c;
    sbuf++;
    for (;count < leng;count++,sbuf++){
	work2 = *sbuf;
	*sbuf = work;
	work = work2;
    }
    *(++sbuf) = work;
    return ++leng;
}

int insert(u_short* sbuf,int leng,u_short c)
{
    if (leng == 0){
	*sbuf = c;
	return 1;
    }
    int count;
    for (count = 0;(c < *sbuf)&&(count < leng);count++,sbuf++);
    if (count == leng-1){
	if (c < *sbuf){
	    *(sbuf+1) = *sbuf;
	    *sbuf = c;
	   return ++leng;
	}else{
	    *(++sbuf) = c;
	    return ++leng;
	}
    }
    u_short work = *sbuf;
    u_short work2;
    *sbuf = c;
    sbuf++;
    for (;count < leng;count++,sbuf++){
	work2 = *sbuf;
	*sbuf = work;
	work = work2;
    }
    *(++sbuf) = work;
    return ++leng;
}

Word doFscanf_with_ascii(Word x,Word y)
{
    char sbuff[BUFSIZ];
    int no_of_sbuf;
    int no_of_obj = 0;
    FileStreamObject* fp = FileStreamObject_ptr(x);
    char ebuf[BUFSIZ];
    char* format = ebuf;
    char* fstr = format;
    ASCII_StrObject* asc  = ASCII_StrObject_ptr(y);
    Uint leng = asc->no_of_chars();
    ebuf[leng] = '\0';
    for (int count = leng-1;count > -1; count--)
	ebuf[count] = (char)Fix2Int(asc->Element((Uint)count));
    int full = -1;
    int under = -1;
    while(*format != '\0'){
	no_of_sbuf = 0;
	switch(*format){
	case ' ':
	    format++;
	    break;
	case '*':
	    skip_string(fp);
	    format++;
	    break;
	case '%':
	    format++;
	loop:
	    switch(*format){
	    case 'd':
	    case 'i':
		objbuff[no_of_obj++] = scan_dec(full,fp);
		full = -1;
		under = -1;
		break;
	    case 'X':
	    case 'x':
		objbuff[no_of_obj++] = scan_hex(full,fp);
		full = -1;
		under = -1;
		break;
	    case 'O':
	    case 'o':
		objbuff[no_of_obj++] = scan_oct(full,fp);
		full = -1;
		under = -1;
		break;
	    case 'g':
	    case 'G':
	    case 'f':
	    case 'F':
		objbuff[no_of_obj++] = scan_float(full,under,fp);
		full = -1;
		under = -1;
		break;
	    case 's':
	    case 'S':
		objbuff[no_of_obj++] = scan_string(full,fp);
		full = -1;
		under = -1;
		break;
	    case 'a':
	    case 'A':
		objbuff[no_of_obj++] = scan_atom(full,fp);
		format++;
		full = -1;
		under = -1;
		break;
	    case 'b':
	    case 'B':
		objbuff[no_of_obj++] = scan_bool(fp);
		format++;
		full = -1;
		under = -1;
		break;
	    case 'c':
	    case 'C':
		objbuff[no_of_obj++] = scan_char(fp);
		full = -1;
		under = -1;
		break;
	    case '[':
		   format++;
		   // ][ emacs  indentation Τɻߤ
		   int not = 0;
		   if (*format == '^'){
		       not++;
		       format++;
		   }
		   while((*format) != ']'){
		       no_of_sbuf = insert(sbuff,no_of_sbuf,*format++);
		       if (*format == '\\'){
			   format++;
			   no_of_sbuf = insert(sbuff,no_of_sbuf,*format++);
		       }
		       if (*format == '-'){
			   format++;
			   for(char c = sbuff[no_of_sbuf-1];c <= *format;c++)
			       no_of_sbuf = insert(sbuff,no_of_sbuf,c);
			   format++;
		       }
		   }
		if (not)
		    objbuff[no_of_obj++] =
			not_member_scan_string(sbuff,no_of_sbuf,fp);
		else
		    objbuff[no_of_obj++] =
			member_scan_string(sbuff,no_of_sbuf,fp);
		break;
	    default:
		if ((*format>='0')&&(*format<='9')){
		    full = 0;
		    while((*format>='0')&&(*format<='9')){
			full = full*10+(*format-'0');
			format++;
		    }
		    if (*format == '.'){
			format++;
			under = 0;
			while((*format>='0')&&(*format<='9')){
			    under = under*10+(*format-'0');
			    format++;
			}
		    }
		}
		goto loop;
		break;
	    }
	    format++;
	    break;
	default:
	    format++;
	    break;
	}
    }
    if (no_of_obj == 0){
	error(form("fscanf %s %s ",print(x),fstr),
	      "Illegal format %s ",fstr);
	return INT0;
    }
    Word ret = CreateVector(no_of_obj,objbuff);
    return ret;
}

Word doFscanf_with_euc(Word x, Word y)
{
    char sbuff[BUFSIZ];
    int no_of_sbuf = 0;
    int no_of_obj = 0;
    FileStreamObject* fp = (FileStreamObject*)Pointer(x);
    u_short ebuf[BUFSIZ];
    u_short* format = ebuf;
    u_short* fstr = format;
    EUC_StrObject* euc	= (EUC_StrObject*)Pointer(y);
    Uint leng = euc->no_of_chars();
    ebuf[leng] = '\0';
    for (int count = leng;count > -1; count--)
	ebuf[count] = (u_short)Fix2Int(euc->Element((Uint)count));
    int full = -1;
    int under = -1;
    while(*format != '\0'){
	switch(*format){
	case ' ':
	case SPACE:
	    format++;
	    break;
	case '*':
	    skip_string(fp);
	    format++;
	    break;
	case '%':
	    format++;
	    switch(*format){
	    case 'd':
	    case 'i':
	    case DSMALL:
	    case ISMALL:
		objbuff[no_of_obj++] = scan_dec(full,fp);
		full = -1;
		under = -1;
		break;
	    case XLARGE:
	    case XSMALL:
	    case 'X':
	    case 'x':
		objbuff[no_of_obj++] = scan_hex(full,fp);
		full = -1;
		under = -1;
		break;
	    case OLARGE:
	    case OSMALL:
	    case 'O':
	    case 'o':
		objbuff[no_of_obj++] = scan_oct(full,fp);
		full = -1;
		under = -1;
		break;
	    case FLARGE:
	    case FSMALL:
	    case GLARGE:
	    case GSMALL:
	    case 'g':
	    case 'G':
	    case 'f':
	    case 'F':
		objbuff[no_of_obj++] = scan_float(full,under,fp);
		full = -1;
		under = -1;
		break;
	    case SLARGE:
	    case SSMALL:
	    case 's':
	    case 'S':
		objbuff[no_of_obj++] = scan_string(full,fp);
		full = -1;
		under = -1;
		break;
	    case ALARGE:
	    case ASMALL:
	    case 'a':
	    case 'A':
		objbuff[no_of_obj++] = scan_atom(full,fp);
		full = -1;
		under = -1;
		format++;
		break;
	    case BLARGE:
	    case BSMALL:
	    case 'b':
	    case 'B':
		objbuff[no_of_obj++] = scan_bool(fp);
		format++;
		full = -1;
		under = -1;
		break;
	    case CLARGE:
	    case CSMALL:
	    case 'c':
	    case 'C':
		objbuff[no_of_obj++] = scan_char(fp);
		full = -1;
		under = -1;
		break;
	    case '[':
		   format++;
		   // ][ emacs  indentation Τɻߤ
		   int not = 0;
		   if (*format == '^'){
		       not++;
		       format++;
		   }
		   while((*format) != ']'){
		       no_of_sbuf = insert(sbuff,no_of_sbuf,*format++);
		       if (*format == '\\'){
			   format++;
			   no_of_sbuf = insert(sbuff,no_of_sbuf,*format++);
		       }
		       if (*format == '-'){
			   format++;
			   for(u_short c =sbuff[no_of_sbuf-1];c<=(*format);c++)
			       no_of_sbuf = insert(sbuff,no_of_sbuf,c);
			   format++;
		       }
		   }
		if (not){
		    objbuff[no_of_obj++] =
			not_member_scan_string(sbuff,no_of_sbuf,fp);
		    no_of_sbuf = 0;
		}else{
		    objbuff[no_of_obj++] =
			member_scan_string(sbuff,no_of_sbuf,fp);
		    no_of_sbuf = 0;
		}
		break;
	    default:
		break;
	    }
	    format++;
	    break;
	default:
	    if ((*format>='0')&&(*format<='9')){
		full = 0;
		while((*format>='0')&&(*format<='9')){
		    full = full*10+(*format-'0');
		    format++;
		}
		if (*format == '.'){
		    format++;
		    under = 0;
		    while((*format>='0')&&(*format<='9')){
			under = under*10+(*format-'0');
			format++;
		    }
		}
		break;
	    }
	    format++;
	    break;
	}
    }
    if (no_of_obj == 0){
	error(form("fscanf %s %s ",print(x),fstr),
	      "Illegal format %s ",fstr);
	return INT0;
    }
    Word ret = CreateVector(no_of_obj,objbuff);
    return ret;
}

Word doFscanf_with_fstream(Word x, Word y)
{
    y = Dereference (y);
    if (IsUndefined  (y)){
	error(form("fscanf %s %s ",print(x),print(y)),
	      "Format is Inlet ",print(y));
	return INT0;
    }
    if (IsEUC_StrObject(y)){
	Word ans = doFscanf_with_euc(x,y);
	doClose(y);
	return ans;
    }
    if (IsASCII_StrObject(y)){
	Word ans = doFscanf_with_ascii(x,y);
	doClose(y);
	return ans;
    }
    error(form("fscanf %s %s ",print(x),print(y)),
	  "Can't coerence %s to STRING ",print(y));
    return INT0;
}

Word doFscanf(Word x, Word y)
    // {} @ METHOD BEGIN
    // {} @ CLASS file
    // {} @ NOTATION X:fscanf(Y,^Z)
    // {} @ EXPLANATION
    // YʸʤСեޥåY˽ϤԤʤɤ߹
    // ֥ȤǤȤüȥ꡼Z³
    // 롥ʲ˥եޥåȤεǽ򼨤
    // @table @samp
    // @item %o
    // ֥Ȥ8
    // @item %d
    // ֥Ȥ10
    // @item %x
    // ֥Ȥ16
    // @item %g
    // ֥ͥȤξˡˤ
    // @item %f
    // Ʊ
    // @item %e
    // ֥ͥȤλؿɽˤ(e)
    // @item %E
    // ֥ͥȤλؿɽˤ(E)
    // @item %s
    // ʸ󥪥֥Ȥ
    // @item %c
    // ͤǼʸɤʸ
    // @item %bs
    // ͤû(@code{`true}t, @code{`false}f)
    // @item %bl
    // ͤĹ(@code{`true}`true, @code{`false}`false)
    // @item %%
    // ʸ%
    // @end table
    // Y ̤³Υ祤Ȥξ硤Y ³ޤԤġ
    // {} @ METHOD END
{
    x = Dereference (x);
    if (IsUndefined  (x))
	return SendBuiltinMessage2(x,PID_FSCANF,y);
    if (IsFStream(x))
	return doFscanf_with_fstream(x,y);
    error(form("fscanf %s %s ",print(x),print(y)),
	  "Can't coerence %s to FSTREAM ",print(x));
    return INT0;
}

METHOD(fscanf, R3_OP)
    // {}
    // fscanf Rstream, Rformat, Rresult
    // {}
    // [	   address ]
    // [  Rs|  Rf|  Rr|	 00]
    // {}
    // Rstream եޥå Rformat ˽ϤԤʤ̤
    // ˤ Rressult Ȥ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doFscanf(x,Reg[ip->b1]);
    doClose(x);
    JumpNextInstruction();
}

Word doRevFscanf(Word x, Word y)
{
    y = Dereference (y);
    if (IsEUC_StrObject(y))
	return doFscanf_with_euc(x,y);
    if (IsASCII_StrObject(y))
	return doFscanf_with_ascii(x,y);
    error(form("fprintf(rev) %s %s ",print(x),print(y)),INVALID_DATA_TYPE,print(y));
    return INT0;
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
