/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <ctype.h>
#include "aum.h"
#include "aum/string.h"
#include "aum/vector.h"
#include "aum/tstream.h"
#include "aum/fstream.h"
#include "aum/protocolid.h"
#include "builtin/extern.h"

#define CURRENT		  (vec->GetElement(index))
#define MODE		 (vec->GetMode(index))
#define NEXT_STEP      (index++)

extern char* Word2String_vector(Word x);

class opstate {
private:
    FileStreamObject* filep;
    Boolean right_pos_flag;
    Boolean display_plus_flag;
    Boolean convert_mode;
    Boolean zero_tab;
    int top_number;
    int under_number;
public:
    void top(int t);
    int top();
    void under(int t);
    int under();
    FileStreamObject* fp();
    opstate(FileStreamObject* f);
    ~opstate();
    void flag_init();
    void right();
    void plus();
    void zero();
    void convert();

    Boolean is_right();
    Boolean is_plus();
    Boolean is_zero();
    Boolean is_convert();
};
int opstate::top(){
    return top_number;
}
void opstate::top(int t){
    top_number = t;
}
int opstate::under(){
    return under_number;
}
void opstate::under(int u){
    under_number = u;
}
FileStreamObject* opstate::fp(){
    return filep;
}

void opstate::right(){
    right_pos_flag = TRUE;
}
void opstate::plus(){
    display_plus_flag = TRUE;
}
void opstate::convert(){
    convert_mode = TRUE;
}

void opstate::zero(){
    zero_tab = TRUE;
}

Boolean opstate::is_right(){
    return right_pos_flag;
}
Boolean opstate::is_plus(){
    return display_plus_flag;
}
Boolean opstate::is_convert(){
    return convert_mode;
}

Boolean opstate::is_zero(){
    return zero_tab;
}

opstate::opstate(FileStreamObject* f){
    filep = f;
    flag_init();
}

opstate::~opstate(){
}

void opstate::flag_init(){
    right_pos_flag    = FALSE;
    display_plus_flag = FALSE;
    convert_mode      = FALSE;
    zero_tab	      = FALSE;
    top_number	 = -1;
    under_number = -1;
}


void display_octal(opstate* stat,Word x)
{
    FileStreamObject*fp = stat->fp();
    x = Dereference(x);
    if (IsFixnum(x)){
	char form_str[BUFSIZ];
	char write_str[BUFSIZ];
	char* work = form_str;
	*work++ = '%';
	if (stat->is_right())
	    *work++ = '-';
	if (stat->is_plus())
	    *work++ = '+';
	if (stat->is_convert())
	    *work++ = '#';
	if (stat->is_zero())
	    *work++ = '0';
	if (stat->top() > 1){
	    sprintf(work,"%d",stat->top());
	    for (;*work != '\0';work++);
	}
	if (stat->under() > -1){
	    *work++ = '.';
	    sprintf(work,"%d",stat->under());
	    for (;*work != '\0';work++);
	}
	*work++ = 'o';
	*work = '\0';
	sprintf(write_str,form_str,Fix2Int(x));
	fp->Puts(write_str);
	return;
    }
    Boolean save = ShowRC;
    ShowRC = FALSE;
    fp->Puts(print(x));
    ShowRC = save;
}

void display_hex(u_short o,opstate* stat,Word x)
{
    FileStreamObject*fp = stat->fp();
    x = Dereference(x);
    if (IsFixnum(x)){
	char form_str[BUFSIZ];
	char write_str[BUFSIZ];
	char* work = form_str;
	*work++ = '%';
	if (stat->is_right())
	    *work++ = '-';
	if (stat->is_plus())
	    *work++ = '+';
	if (stat->is_convert())
	    *work++ = '#';
	if (stat->is_zero())
	    *work++ = '0';
	if (stat->top() > 1){
	    sprintf(work,"%d",stat->top());
	    for (;*work != '\0';work++);
	}
	if (stat->under() > -1){
	    *work++ = '.';
	    sprintf(work,"%d",stat->under());
	    for (;*work != '\0';work++);
	}
	*work++ = (char)o;
	*work = '\0';
	sprintf(write_str,form_str,Fix2Int(x));
	fp->Puts(write_str);
	return;
    }
    Boolean save = ShowRC;
    ShowRC = FALSE;
    fp->Puts(print(x));
    ShowRC = save;
}
void display_dec(opstate* stat,Word x)
{
    FileStreamObject*fp = stat->fp();
    x = Dereference(x);
    if (IsFixnum(x)||IsSFloat(x)||IsDFloat(x)){
	char form_str[BUFSIZ];
	char write_str[BUFSIZ];
	char* work = form_str;
	*work++ = '%';
	if (stat->is_right())
	    *work++ = '-';
	if (stat->is_plus())
	    *work++ = '+';
	if (stat->is_convert())
	    *work++ = '#';
	if (stat->is_zero())
	    *work++ = '0';
	if (stat->top() > -1){
	    sprintf(work,"%d",stat->top());
	    for (;*work != '\0';work++);
	}
	if (stat->under() > -1){
	    *work = '.';
	    work++;
	    sprintf(work,"%d",stat->under());
	    for (;*work != '\0';work++);
	}
	*work++ = 'd';
	*work = '\0';
	if (IsFixnum(x)){
	    sprintf(write_str,form_str,Fix2Int(x));
	    fp->Puts(write_str);
	    return;
	}
	if (IsSFloat(x)){
	    sprintf(write_str,form_str,(int)Single2float(x));
	    fp->Puts(write_str);
	    return;
	}
	if (IsDFloat(x)){
	    sprintf(write_str,form_str,(int)Double2double(x));
	    fp->Puts(write_str);
	    return;
	}
    }
    Boolean save = ShowRC;
    ShowRC = FALSE;
    fp->Puts(print(x));
    ShowRC = save;
}
void display_float(u_short o,opstate* stat,Word x)
{
    FileStreamObject*fp = stat->fp();
    x = Dereference(x);
    if (IsFixnum(x)||IsSFloat(x)||IsDFloat(x)){
	char form_str[BUFSIZ];
	char write_str[BUFSIZ];
	char* work = form_str;
	*work++ = '%';
	if (stat->is_right())
	    *work++ = '-';
	if (stat->is_plus())
	    *work++ = '+';
	if (stat->is_convert())
	    *work++ = '#';
	if (stat->is_zero())
	    *work++ = '0';
	if (stat->top() > -1){
	    sprintf(work,"%d",stat->top());
	    for (;*work != '\0';work++);
	}
	if (stat->under() > -1){
	    *work++ = '.';
	    sprintf(work,"%d",stat->under());
	    for (;*work != '\0';work++);
	}
	*work++ = (char)o;
	*work = '\0';
	if (IsFixnum(x)){
	    int leng = (int)sprintf(write_str,form_str,(int)Fix2Int(x));
	    if (leng > 0){
		fp->Puts(write_str);
	    }
	    return ;
	}
	if (IsSFloat(x)){
	    int	 leng = (int)sprintf(write_str,form_str,Single2float(x));
	    if (leng > 0){
		fp->Puts(write_str);
	    }
	    return ;
	}
	if (IsDFloat(x)){
	    int	 leng = (int)sprintf(write_str,form_str,Double2double(x));
	    if (leng > 0){
		fp->Puts(write_str);
	    }
	    return ;
	}
    }
    Boolean save = ShowRC;
    ShowRC = FALSE;
    fp->Puts(print(x));
    ShowRC = save;
}

void display_string(u_short o,opstate* stat,Word x)
{
    FileStreamObject*fp = stat->fp();
    x = Dereference(x);
    if (IsASCII_StrObject(x)){
	char form_str[BUFSIZ];
	char write_str[BUFSIZ];
	char* work = form_str;
	*work++ = '%';
	if (stat->is_right())
	    *work++ = '-';
	if (stat->is_plus())
	    *work++ = '+';
	if (stat->is_convert())
	    *work++ = '#';
	if (stat->is_zero())
	    *work++ = '0';
	if (stat->top() > 1){
	    sprintf(work,"%d",stat->top());
	    for (;*work != '\0';work++);
	}
	if (stat->under() > -1){
	    *work++ = '.';
	    sprintf(work,"%d",stat->under());
	    for (;*work != '\0';work++);
	}
	*work++ = 's';
	*work = '\0';
	if (o == 'S')
	    sprintf(write_str,form_str,ASCII_StrObject_ptr(x)->Print(FALSE));
	else
	    sprintf(write_str,form_str,ASCII_StrObject_ptr(x)->Print(FALSE));
	fp->Puts(write_str);
	return;
    } else if (IsEUC_StrObject(x)){
	EUC_StrObject* euc = EUC_StrObject_ptr(x);
	int tabadd;
	if (stat->top() <0){
	    if (o == 'S'){
		fp->Putc(Int2Fix('\"'));
		fp->Puts(euc->Print(FALSE));
		fp->Putc(Int2Fix('\"'));
	    }else
		fp->Puts(euc->Print(FALSE));
	    tabadd = 0;
	}else
	    tabadd = stat->top();
	int strleng = euc->no_of_chars();
	int tab = (strleng < tabadd ) ? tabadd - strleng : 0;
	if (o == 'S')
	    tab -= 2;
	int max = (stat->under()<0) ? strleng : stat->under();
	Boolean right = stat->is_right();
	Boolean zero = stat->is_zero();
	if ((!right)&&(tab > 0)){
	    for(int count = tab;count > 0;count--){
		if (zero)
		    fp->Putc(Int2Fix('0'));
		else
		    fp->Putc(Int2Fix(' '));
	    }
	}else if (tab < 0) {
	    strleng -= tab;
	}
	if (o == 'S')
	    fp->Putc(Int2Fix('\"'));
	for (int count = 0;count < strleng;count++){
	    if (count >= max)
		break;
	    fp->Putc(euc->Element(count));
	}
	if (o == 'S')
	    fp->Putc(Int2Fix('\"'));
	if ((right)&&(tab > 0)){
	    for(int count = tab;count>0;count--){
		if (zero)
		    fp->Putc(Int2Fix('0'));
		else
		    fp->Putc(Int2Fix(' '));
	    }
	}
	return;
    } else {
	char form_str[BUFSIZ];
	char write_str[BUFSIZ];
	char* work = form_str;
	*work++ = '%';
	if (stat->is_right())
	    *work++ = '-';
	if (stat->is_plus())
	    *work++ = '+';
	if (stat->is_convert())
	    *work++ = '#';
	if (stat->is_zero())
	    *work++ = '0';
	if (stat->top() > 0){
	    sprintf(work,"%d",stat->top());
	    for (;*work != '\0';work++);
	}
	if (stat->under() > -1){
	    *work++ = '.';
	    sprintf(work,"%d",stat->under());
	    for (;*work != '\0';work++);
	}
	*work++ = 's';
	*work = '\0';
	Boolean save = String_quote_p;
	Boolean src = ShowRC;
	ShowRC = FALSE;
	String_quote_p = (o == 'S') ? TRUE:FALSE;
	sprintf(write_str,form_str,print(x));
	ShowRC = src;
	fp->Puts(write_str);
	String_quote_p = save;
    }
}

void display_atom(u_short o,opstate* stat,Word x)
{
    FileStreamObject*fp = stat->fp();
    x = Dereference(x);
    if (IsAtom(x)){
	char write_str[BUFSIZ];
	char* atomstr;
	int leng = strlen(atomstr = (char*)AtomPrintname(x));
	strcpy(write_str,atomstr);
	write_str[leng] = '\0';
	int max = stat->under();
	Boolean right = stat->is_right();
	Boolean zero = stat->is_zero();
	int tab = stat->top()-jstrlen((unsigned char*)write_str);
	if (o == 'A'){
	    tab -= 2;
	}
	char* work = write_str;
	int count;
	if ((!right)&&(tab >0)){
	    for (count = tab;count > 0;count--){
		if (zero){
		    fp->Putc(Int2Fix('0'));
		}else{
		    fp->Putc(Int2Fix(' '));
		}
	    }
	}
	if (o == 'A'){
	    fp->Putc(Int2Fix('|'));
	}
	for (count = 0;*work!='\0';count++){
	    if ((max > 0)&&(max<=count)){
		break;
	    }
	    if (IsEUC(*work)){
		u_short letter = (*work)<<8+*(work+1);
		fp->Putc(Int2Fix(letter));
		work+=2;
	    }else{
		fp->Putc(Int2Fix(*work));
		work++;
	    }
	}
	if (o == 'A'){
	    fp->Putc(Int2Fix('|'));
	}
	if ((right)&&(tab >0)){
	    for (count = tab;count > 0;count--){
		fp->Putc(Int2Fix(' '));
	    }
	}
	return;
    }
    Boolean save = ShowRC;
    ShowRC = FALSE;
    fp->Puts(print(x));
    ShowRC = save;
}

void display_boolean(u_short o,opstate* stat,Word x)
{
    char write_str[BUFSIZ];
    FileStreamObject*fp = stat->fp();
    x = Dereference(x);
    if (IsBool(x)){
	if (o == 's'){
	    if (IsTrue(x)){
		write_str[0] = '`';
		write_str[1] = 't';
		write_str[2] = '\0';
	    }else{
		write_str[0] = '`';
		write_str[1] = 'f';
		write_str[2] = '\0';
	    }
	}else{
	    if (IsTrue(x)){
		strcpy(write_str,"`true");
	    }else{
		strcpy(write_str,"`false");
	    }
	}
	int len = strlen(write_str);
	if (stat->top() <= len){
	    fp->Puts(write_str);
	    return;
	}
	int tab = stat->top()-len;
	if (stat->is_right()){
	    fp->Puts(write_str);
	    fp->Tab(tab);
	    return;
	}
	fp->Tab(tab);
	fp->Puts(write_str);
	return;
    }
    Boolean save = ShowRC;
    ShowRC = FALSE;
    fp->Puts(print(x));
    ShowRC = save;
}

void dispObjectVector(Word& x, Word& y,Word& z)
{
    FileStreamObject* fp = (FileStreamObject*)Pointer(x);
    StringObject* str = (StringObject*)Pointer(y);
    VectorObject* vec = (VectorObject*)Pointer(z);
    int form_strlen = str->no_of_chars();
    u_short letters[form_strlen+1];
    u_short* work = letters;
    int i;
    opstate* stat = &opstate(fp);
    int index = 0;
    letters[form_strlen] = '\0';
    if (IsASCII_StrObject(y)){
	ASCII_StrObject* ascii = (ASCII_StrObject*)str;
	for(i = 0;i < form_strlen;i++)
	    letters[i] = Fix2Int(ascii->Element(i));
    }else{
	EUC_StrObject* euc = (EUC_StrObject*)str;
	for(i = 0;i < form_strlen;i++)
	    letters[i] = Fix2Int(euc->Element(i));
    }
    while(*work != '\0'){
	if (*work == (u_short)'%'){
	    work++;
	loop:
	    if (*work ==(u_short)'\0'){
		return;
	    }else if ((*work ==(u_short)'O')||(*work ==(u_short)'o')){
		doSplit(CURRENT);
		display_octal(stat,CURRENT);
		NEXT_STEP;
		work++;
	    }else if (*work ==(u_short)'d'){
		doSplit(CURRENT);
		display_dec(stat,CURRENT);
		NEXT_STEP;
		work++;
	    }else if (*work ==(u_short)'c'){
		doSplit(CURRENT);
		if (IsFixnum(CURRENT)){
		    fp->Putc(CURRENT);
		}
		NEXT_STEP;
		work++;
	    }else if ((*work ==(u_short)'X')||(*work ==(u_short)'x')){
		doSplit(CURRENT);
		display_hex(*work,stat,CURRENT);
		NEXT_STEP;
		work++;
	    }else if (((*work >=(u_short)'e')&&(*work <=(u_short)'g'))||
		      ((*work >=(u_short)'E')&&(*work <=(u_short)'G'))){
		doSplit(CURRENT);
		display_float(*work,stat,CURRENT);
		NEXT_STEP;
		work++;
	    }else if ((*work ==(u_short)'s')||(*work ==(u_short)'S')){
		doSplit(CURRENT);
		display_string(*work,stat,CURRENT);
		NEXT_STEP;
		work++;
	    }else  if ((*work ==(u_short)'a')||(*work ==(u_short)'A')){
		display_atom(*work,stat,CURRENT);
		NEXT_STEP;
		work++;
	    }else if ((*work ==(u_short)'b')||(*work ==(u_short)'B')){
		work++;
		if (*work ==(u_short)'\0'){
		    doSplit(CURRENT);
		    display_boolean('l',stat,CURRENT);
		    NEXT_STEP;
		} else if ((*work ==(u_short)'s')||(*work ==(u_short)'S')||
		    (*work ==(u_short)'l')||(*work ==(u_short)'L')){
		    doSplit(CURRENT);
		    display_boolean(*work,stat,CURRENT);
		    NEXT_STEP;
		    work++;
		}else{
		    doSplit(CURRENT);
		    display_boolean('l',stat,CURRENT);
		    NEXT_STEP;
		}
	    }else if (*work ==(u_short)'%'){
		fp->Putc(Int2Fix('%'));
		work++;
	    }else if (*work ==(u_short)'-'){
		stat->right();
		work++;
		goto loop;
	    }else if (*work ==(u_short)'+'){
		stat->plus();
		work++;
		goto loop;
	    }else if (*work ==(u_short)'*'){
		doSplit(CURRENT);
		if (IsFixnum(CURRENT))
		    stat->top(Fix2Int(CURRENT));
		NEXT_STEP;
		work++;
		goto loop;
	    }else if (*work ==(u_short)'#'){
		stat->convert();
		work++;
		goto loop;
	    }else if (*work ==(u_short)'.'){
		work++;
		if (*work ==(u_short)'\0'){
		    return;
		}else if (*work ==(u_short)'*'){
		    doSplit(CURRENT);
		    if (IsFixnum(CURRENT))
			stat->under(Fix2Int(CURRENT));
		    NEXT_STEP;
		    work++;
		}else if ((*work <='9')&&(*work>='0')){
		    int under = 0;
		    while((*work >='0')&&(*work<='9')){
			under = under*10+(*work-'0');
			work++;
		    }
		    stat->under(under);
		    goto loop;
		}else{
		    work++;
		    goto loop;
		}
	    }else if ((*work <='9')&&(*work >= '0')){
		if (*work =='0')
		    stat->zero();
		int top = 0;
		while((*work >='0')&&(*work <= '9')){
		    top = top*10 + (*work - '0');
		    work++;
		}
		stat->top(top);
		goto loop;
	    }else{
		fp->Putc(Int2Fix(*work));
		work++;
	    }
	}else if (*work =='&'){
	    work++;
	    if (*work =='n'){
		fp->Putc(Int2Fix('\n'));
		work++;
	    }else if (*work =='t'){
		fp->Putc(Int2Fix('\t'));
		work++;
	    }else if (*work =='b'){
		fp->Putc(Int2Fix('\b'));
		work++;
	    }else if (*work == '0'){
		work++;
		int ctcode = 0;
		if ((*work =='x')||(*work =='X')){
		    work++;
		    for(;;work++){
			if ((*work>='0')&&(*work <= '9')){
			    ctcode = ctcode*0x10+(*work-'0');
			    continue;
			}else if ((*work >= 'A')&&(*work <= 'F')){
			    ctcode = ctcode*0x10+(*work-'A')+0xa;
			    continue;
			}else if ((*work >= 'a')&&(*work <= 'f')){
			    ctcode = ctcode*0x10+(*work-'a')+0xa;
			    continue;
			}else{
			    fp->Putc(Int2Fix(ctcode));
			    break;
			}
		    }
		}else if ((*work>='0')&&(*work <= '7')){
		    ctcode = ctcode*0x8+(*work-'0');
		    while((*work>='0')&&(*work<='7')){
			ctcode = ctcode*0x8+(*work-'0');
			work++;
		    }
		    fp->Putc(Int2Fix(ctcode));
		}
	    }else{
		work++;
	    }
	}else{
	    fp->Putc(Int2Fix(*work));
	    work++;
	}
	stat->flag_init();
    }
    return;
}

void doFprintf_with_vector(Word x, Word y, Word z)
{
    z = Dereference (z);
    if (IsVector (z)) {
	dispObjectVector (x,y,z);
	//doClose (y);
	//doClose (z);
	return;
    }
    if (IsUndefined (z)) {
	doSplit (x);
	Sendm_2args (z, PID_REV_FPRINTF_ARG2, x, y);
	//doClose (z);
	return;
    }
    error (form ("%s :fprintf(%s,%s)", print(x), print(y), print(z)),
	   "Can't coerce %s to VECTOR ",print(z));
}

void doFprintf_with_string (Word x, Word y, Word z)
{
    y = Dereference (y);
    if (IsString (y)) {
	doFprintf_with_vector(x,y,z);
	return;
    }
    if (IsUndefined (y)) {
	doSplit (x);
	Sendm_2args (y, PID_REV_FPRINTF_ARG1, x, z);
	//doClose (y);
	return;
    }
    error(form("%s :fprintf(%s,%s)",print(x),print(y),print(z)),
	  "Can't coerce %s to STRING ",print(y));
}

void doFprintf(Word x, Word y, Word z)
    // {} @ METHOD BEGIN
    // {} @ CLASS file
    // {} @ NOTATION X:fprintf(Y,Z)
    // {} @ EXPLANATION
    // Yʸ󤽤ZʤСZ˳ǼƤ
    // 륪֥ȤեޥåY˽äʸ󲽤եX˽
    // Ϥ롥
    // ʲ˥եޥåȤεǽ򼨤
    // @table @samp
    // @item %o
    // ֥Ȥ8ɽ
    // @item %d
    // ֥Ȥ10ɽ
    // @item %x
    // ֥Ȥ16ɽ
    // @item %g
    // ֥ͥȤμ¿ɽ
    // @item %f
    // ֥ͥȤμ¿ɽ
    // @item %e
    // ֥ͥȤλؿɽˤɽ(e)
    // @item %E
    // ֥ͥȤλؿɽˤɽ(E)
    // @item %s
    // ʸ󥪥֥Ȥɽ
    // @item %a
    // ܥ륪֥Ȥɽ
    // @item %c
    // ͤǼʸɤʸɽ
    // @item %%
    // ʸ%ɽ
    // @item %bs
    // ͤûɽ(@code{`true}t, @code{`false}f)
    // @item %bl
    // ͤĹɽ(@code{`true}`true, @code{`false}`false)
    // @end table
    // Y  Z ̤³Υ祤Ȥξ硤³ޤԤġ
    // {} @ METHOD END
{
    x = Dereference (x);
    if (IsFStream(x)){
	doFprintf_with_string (x, y, z);
	return;
    }
    if (IsUndefined (x)) {
	Sendm_2args (x, PID_FPRINTF, y, z);
	return;
    }
    error(form("%s :fprintf(%s,%s)",print(x),print(y),print(z)),
	  "Can't coerce %s to FILE_STREAM ",print(x));
}

METHOD(fprintf, R3_OP)
    // {}
    // fprintf Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    //  Rk ˳ǼƤ륪֥Ȥեޥå Rj ˽ä
    // ե Ri ˽Ϥ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    Word y = Reg[ip->b1];
    Word z = Reg[ip->b2];
    doFprintf (x, y, z);
    doClose (x);
    JumpNextInstruction();
}

void doRevFprintf_arg1 (Word y, Word x, Word z)
{
    if (IsString (y)) {
	doSplit (y);
	doFprintf_with_vector (x, y, z);
	doClose (x);
	return;
    }
    error (form ("%s :fprintf(%s,%s)", print(x), print(y), print(z)),
	   INVALID_DATA_TYPE, print(y));
}

void doRevFprintf_arg2 (Word z, Word x, Word y)
{
    if (IsVector (z)) {
	dispObjectVector (x, y, z);
	doClose (x);
	doClose (y);
	return;
    }
    error (form ("%s :fprintf(%s,%s)", print(x), print(y), print(z)), INVALID_DATA_TYPE, print(z));
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
