/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/fstream.h"
#include "builtin/extern.h"

void doFflush(Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS file
    // {} @ NOTATION X:fflush
    // {} @ EXPLANATION
    // XΥХåեίäƤǡǤФ
    // {} @ METHOD END
{
    x = Dereference (x);
    if(IsUndefined (x)){
	SendBuiltinMessage1 (x, PID_FFLUSH);
	return;
    }
    if (IsFStream(x)){
	FileStreamObject* ft = (FileStreamObject*)Pointer(x);
	ft->Flush();
	return;
    }
    error(form("%s :fflush",print(x)),
	  CAN_NOT_FIND_METHOD,"flush");
    return;
}

METHOD(fflush, R1_OP)
    // {}
    // fflush Rstream
    // {}
    // [	   address ]
    // [  Rs|	   0x000000]
    // {}
    // ե Rstream Ƥեå夹롥
    // {}
{
    Fetch4();
    doFflush(Reg[ip->b0]);
    JumpNextInstruction();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
