/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/stdlib.h"
#include "aum/fetch.h"
#include "aum/merger.h"
#include "aum/fstream.h"
#include "aum/protocolid.h"
#include "builtin/extern.h"

#ifdef nodef

void doFclose(Word x)
    // {*} @ METHOD BEGIN
    // {*} @ CLASS file
    // {*} @ NOTATION X:fclose
    // {*} @ EXPLANATION
    // Xե륪֥ȤʤXĺ롥եλ
    // Ȳ 0 Ȥʤʤ¤եºݤˤĺʤޤե
    // λȲȤʤäǥեϼưŪĺ롥
    // {*} @ METHOD END
{
    x = Dereference (x);
    if (IsFStream (x)) {
	FileStreamObject_ptr (x)->Fclose ();
	return;
    }
    if (IsUndefined (x)) {
	Sendm_noarg (x, PID_FCLOSE);
    }
    error(form("%s :fclose", print(x), print(y)),
	  CAN_NOT_FIND_METHOD,"fclose");
}

//METHOD(fclose, R1_OP)
    // {}
    //	 fclose	 Rstream
    // {}
    // [	   address ]
    // [  Rs|		  0]
    // {}
    //	 Rx Υե륹ȥ꡼򥯥롣
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    doFclose (x);
    doClose (x);
    JumpNextInstruction();
}
#endif /* nodef */

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
