/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "config.h"

#include <stream.h>
#include "aum/global.h"
#include "aum/time.h"
#include "aum/parallel.h"
#include "aum/debugger.h"

extern const char Version[];
extern const char CompileDate[];

extern void	Toplevel(int n_pes);
extern void	PrintWord(Word);
extern void	Initialize_shared(int s_atom, int s_protocol);
extern void	parse_options (const int argc, const char *argv[]);
extern void	loader (const int argc, const char* argv[]);
extern void	Listener();
extern void	End_shared();

extern debugger_symbol command_parser(char* command);
extern char* next_p;
extern void com_ref_help_method();
extern void com_ref_help_slot();
extern void com_ref_help_class();
extern void com_ref_help_object();
extern void com_ref_help_ubp();
extern void com_ref_help_dbp();
extern void com_ref_help_dtr();
extern void com_ref_help_utr();
extern void com_ref_help_gen();

extern "C" {
    int		m_set_procs();
    void	m_fork();
    void	m_kill_procs();
    void	moncontrol();
};

int  NofPes;

void execute_pas()
{
    moncontrol(0);
    //long cstart = mcputime();
    //long rstart = mctime();
    NofPes = PAS_npe;
    if (PAS_npe == 1)
	Toplevel(PAS_npe);
    else
	Toplevel(PAS_npe+1);
    //long cend = mcputime();
    //long rend = mctime();
    //cout.form("PAS-DB done. Time is %d msecs, CPU is %d msecs.\n",
    //rend-rstart, cend-cstart);
    if (Statistics_flag) {
	PAS_report_monitoring ();
#ifdef SNDRCV_STATS
	SndRcvStats.Report (statistics_flag);
#endif
#ifdef ALLOC_STATS
	AllocStats.Report (statistics_flag);
#endif
    }
}
/*static void
collect_shared_argments()
{
    //SHARED_FREE(pas_argv,pas_arg_bytes);
    //SHARED_FREE(Argv,Arg_bytes);
}*/

int main(int argc, char* argv[])
{
    moncontrol(0);
    cout.form("***** PAS-DB  %s (%s) *****\n", Version, CompileDate);
    cout.flush();
    Program_filename = argv[0];
    parse_options(argc, argv);
    Initialize_shared(Tatom,Tprotocol);
    loader (PasArgc, PasArgv);
    extern void shared_monitoring();
    //shared_monitoring();
    execute_pas();
    //End_shared();
    /*
     *collect_shared_argments();
     *shared_monitoring();
     */
    return 0;
}

void display_filenames()
{
    cout << " running ";
    for (register int n = 0; n < PasArgc; n++) {
	const char* filename = PasArgv[n];
	cout << " "<<filename;
	cout.flush();
    }
    cout << '\n';
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
