/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdio.h>
#include <stream.h>
#include "aum/word.h"
#include "aum/string.h"
#include "aum/error.h"
#include "aum/debugger.h"
#include "aum/global.h"
#include "aum/parallel.h"
#include "command.h"
#include "debugger/src/debugpe.h"
#include "debugger/src/online.h"

#define TEXTLINE 23

extern "C" {
  void Resouce_Monitoring();
#ifdef config_symmetry_h
  int shared_resource();
#endif
};

#define FOREVER for(;;)
extern Boolean	Initialize_private(int s_export, int s_import);
extern PAS_initialize_private_for_debuger (int id);
extern int jstrlen(const unsigned char* str);
extern int Texport;
extern int Timport;
extern unsigned char* jis_to_euc(const unsigned char* from);
extern char* next_p;
extern void display_filenames();

unsigned int line = 0;
static int last;
Boolean *wait_pe;
Boolean *used_pe;
Boolean *trace_enable;
int *enter_break;
Boolean waited_one_sec;
int* rc_table;
GlobalMessage* Current_Message;

inline void Inc_Message_queue()
  // {}
  // FUNCTION
  // inline void Inc_Message_queue()
  // {}
  // å塼Υݥ󥿤Ŀʤ롥
  // {}
{
  MessageLink* next;
  next = Current_Message->nextMessage(),Current_Message->nextMessage(NULL);
  Current_Message->Free();
  Current_Message = (GlobalMessage*)next;
}
void display_error_code(int w,ReceiveErrorCode ec);

void message_to_PE(unsigned int p,debugger_symbol com,Boolean t = TRUE);

void print_text_message(GlobalMessage* gms)
  // {}
  // FUNCTION
  // void print_text_message(GlobalMessage* gms)
  // {}
  // PASץƤƥȥåɸϤɽ롥
  // {}
{
  if (!gms) return;
  char teb[BUFSIZ];
  char* work = teb;
  int I_come_from = (int)gms->Argv(1);
  rc_table[I_come_from]--;
  if (trace_enable[I_come_from]) {
    for (int ind = 3;ind < 32;ind++) {
      unsigned int let;
      if (0xff00&(let = (int)(gms->Argv(ind)))) {
	*work = (let>>8) & 0xff;
	work++;
      }
      if (let == 0) break;
      *work = let & 0xff;
      work++;
      if (let == '\n')
	line++;
    }
    *work = '\0';
    cout << teb;
    cout.flush();
  }
  message_to_PE(I_come_from,DEFAULT,FALSE);
}

void message_to_PE(unsigned int p,debugger_symbol com,Boolean t = TRUE)
  // {}
  // FUNCTION
  // void message_to_PE(unsigned int p,debugger_symbol com,Boolean t = TRUE)
  // {}
  // p֤PASץФơåcomİʤå
  // 롥⤷tTRUEʤ顤PASץΥԤġ
  // {}
{
  GlobalMessage* gms = new_GlobalMessage(Msg_Debugger,3,(ProtocolID&)0);
  gms->Argv(0,com);
  gms->Argv(1,0);
  PAS_send(p,gms);
  if (t) {
    if (!Current_Message) {
      Current_Message = PAS_receive();
    }else{
      Inc_Message_queue();
    }
  }
}

void message_to_PE(unsigned int p,debugger_symbol com,const char* str)
  // {}
  // FUNCTION
  // void message_to_PE(unsigned int p,debugger_symbol com,const char* str)
  // {}
  // p֤PASץФƥåcomȤʸ
  // ĥå롥
  // {}
{
  const unsigned char* jstr = jis_to_euc((const unsigned char*)str);
  int length = jstrlen(jstr);
  int packets = length/PACKET_SIZE+1;
  int work = 0;
  if (!packets) return;
  for (;work < length;) {
    GlobalMessage* gms	= new_GlobalMessage(Msg_Debugger,32,(ProtocolID&)0);
    gms->Argv(0,com);
    gms->Argv(1,packets);
    int ac;
    for (ac = 3;(ac<32)&&(work<length);ac++,work++) {
      unsigned int lett = *(jstr+work);
      if (IsEUC(lett)) {
	work++;
	lett <<=8;
	lett += *(jstr+work);
      }
      gms->Argv(ac,lett);
    }
    if (ac < 32) {
      gms->Argv(ac,0);
    }
    PAS_send(p,gms);
  loop:
    if (!Current_Message) {
      if (!(Current_Message = PAS_receive_in_nonblocking()))
	Current_Message = PAS_receive();
    }
    int I_come_from = (int)(Current_Message->Argv(0));
    debugger_symbol dbs = (debugger_symbol)(Current_Message->Argv(0));
    if (DEFAULT == dbs) {
      Inc_Message_queue();
      continue;
    }
    if (TRECEIVE == dbs) {
      unsigned save_line = line;
      print_text_message(Current_Message);
      line = save_line;
      Inc_Message_queue();
      goto loop;
    }
    if (WAIT_MESSAGE == dbs) {
	wait_pe[I_come_from] = TRUE;
	used_pe[I_come_from] = TRUE;
	Inc_Message_queue();
	goto loop;
      }
    if (RECD_MESSAGE == dbs) {
      wait_pe[I_come_from] = FALSE;
      used_pe[I_come_from] = TRUE;
      waited_one_sec = FALSE;
      Inc_Message_queue();
      goto loop;
    }
    if (BREAK == dbs) {
      int pen = (int)(Current_Message->Argv(1));
      enter_break[last] = pen;
      last = (last+1) % PAS_npe;
      Inc_Message_queue();
      goto loop;
    }
  }
}

void message_to_PAS(debugger_symbol com,Boolean t = TRUE)
  // {}
  // FUNCTION
  // void message_to_PAS(debugger_symbol com,Boolean t = TRUE)
  // {}
  // schedulerФưʤåcom롣
  // {}
{
  for (int pp = 0;pp < PAS_npe;pp++) {
    GlobalMessage* gms = new_GlobalMessage(Msg_Debugger,3,(ProtocolID&)0);
    gms->Argv(0,com);
    gms->Argv(1,0);
    PAS_send(pp,gms);
    if (t) {
      if (!Current_Message) {
	Current_Message = PAS_receive();
      }else{
	Inc_Message_queue();
      }
    }
  }
}

void print_message_queue(GlobalMessage* gms);

void shutdown_PAS()
  // {}
  // FUNCTION
  // void shutdown_PAS()
  // {}
  // PASץФQUITå롥
  // {}
{
  //pelog(" shutdown\n");
  for (int p = 0;p<PAS_npe;p++) {
    GlobalMessage* gms = new_GlobalMessage(Msg_Debugger,3,(ProtocolID&)0);
    gms->Argv(0,QUIT);
    gms->Argv(1,0);
    PAS_send(p,gms);
  }
}
Boolean first_time;
inline Boolean is_terminated()
  // {}
  // FUNCTION
  // inline Boolean is_terminated()
  // {}
  // PASץνλȽԤؿǽλʤTRUEǤʤʤFALSE
  // 
  // {}
{
  for (int ii = 0;(ii<PAS_npe);ii++) {
    if (!wait_pe[ii]) {
      if (used_pe[ii])
	return FALSE;
    }
  }
  if (!used_pe[0])
    return FALSE;
#ifndef SOCKET_COMM
  if (!shared_resource()){
    return TRUE;
  }
#endif
  return FALSE;
}

void trace_set(Boolean t = TRUE)
  // {}
  // FUNCTION
  // void trace_set(Boolean t = TRUE)
  // {}
  // ȥ졼⡼ɤԤäΥ쥹ݥ󥹽ԤؿǤ롥
  // {}
{
  for (int paspr = 0;paspr < PAS_npe;paspr++) {
    GlobalMessage* mtr;
    mtr = new_GlobalMessage(Msg_Debugger,4,(ProtocolID&)0);
    mtr->Argv(0,NRECEIVE);
    mtr->Argv(1,PAS_self_peno);
    mtr->Argv(2,0);
    PAS_send(paspr,mtr);
    FOREVER {
      if (Current_Message) {
	int pen = (int)Current_Message->Argv(1);
	if (Current_Message->Argv(0) == NRECEIVE) {
	  if ((Current_Message->Argv(2) == TraceOn)&&(t)) {
	    cout <<form("Trace Mode On	PE# %d\n",pen);
	    Inc_Message_queue();
	    break;
	  }
	  if ((Current_Message->Argv(2) == TraceOff)&&(t)) {
	    cout << form("Trace Mode Off  PE# %d\n",pen);
	    Inc_Message_queue();
	    break;
	  }
	}
	Inc_Message_queue();
      }else{
	while (!(Current_Message = PAS_receive_in_nonblocking()));
      }
    }
  }
}
void set_debug_info();
void display_static_info();

Boolean is_null_str(char* p)
{
  for (;*p;p++) {
    if ((*p != ' ')&&(*p != '\t')&&(*p != '\n'))
      return FALSE;
  }
  return TRUE;
}

debugger_symbol break_loop(int break_pe)
  // {}
  // FUNCTION
  // debugger_symbol break_loop(int break_pe)
  // {}
  // PASץ֥졼åƤȤ˸ƤФؿǡ
  // ֥졼ݥȤǤΥޥɤԤ
  // {}
{
  char textbf[BUFSIZ];
  FOREVER {
    sprintf(textbf, "%02d:%s", break_pe, PT_EXECUTE);
    cout << textbf;
    cout.flush();
    textbf[0] = '\0';
    gets(textbf);
    debugger_symbol com = command_parser(textbf);
    if (online(com)){
      continue;
    }
    if ((com == QUIT)||(com == CONTINUE)||(com == STEP)||(com == NEXTSTEP)||(com == STEPINST)) {
      message_to_PE(break_pe, com, FALSE);
      return com;
    }
    switch (com) {
    case DUMP_REG:
      if (is_null_str(next_p)) {
	sprintf(next_p, " 0 %02d ", MAX_REG);
	message_to_PE(break_pe, com, next_p);
      } else {
	message_to_PE(break_pe, com, next_p);
      }
      display_static_info();
      break;
    case PRINT_SLOT: case OBJSTAT: case CLASSINFO: case METHOD_LIST:
    case SLOT_LIST: case DESCRIBE:
      message_to_PE(break_pe, com, next_p);
      display_static_info();
      break;
    case DBPCLASS: case UBPCLASS: case DTRCLASS: case UTRCLASS: case DBPPID:
    case UBPPID: case DTRPID: case UTRPID: case DBPMETHOD: case UBPMETHOD:
    case DTRMETHOD: case UTRMETHOD: case DBPSLOT: case UBPSLOT: case DTRSLOT:
    case UTRSLOT: case DBPOBJECT: case UBPOBJECT: case DTROBJECT:
    case UTROBJECT: case DBPOBJSLOT: case UBPOBJSLOT: case DTROBJSLOT:
    case UTROBJSLOT: case DBPOBJMETHOD: case UBPOBJMETHOD: case DTROBJMETHOD:
    case UTROBJMETHOD:
      message_to_PE(break_pe, com, next_p);
      set_debug_info();
      break;
    case OBJACT: case OBJWAIT: case CLASSES: case DUMP_PID:
    case INFO_CURRENT: // case DUMP_SCHEDULER:
      message_to_PE(break_pe,com,FALSE);
      display_static_info();
      break;
    case TRACE_OFF: case TRACE_ON:
      message_to_PE(break_pe,com);
      trace_set();
      break;
    case OUTPUT:
      int pe = atoi(next_p);
      trace_enable[pe] = !trace_enable[pe];
      if (trace_enable[pe]){
	pelog("enable PE#%02d", pe);
      } else {
	pelog("disenable PE#%02d", pe);
      }
      break;
    case  DEFAULT:
    default:
      pelog(ErrM_UNDEFINED);
      break;
    }
  }
}

void print_message_queue(GlobalMessage* gms)
  // {}
  // FUNCTION
  // void print_message_queue(GlobalMessage* gms)
  // {}
  // ǥХåѴؿǥå塼ƬgmsޤǤƤɽ롥
  //âݥ󥿤ΰưϹԤʤ
  // {}
{
  if (!gms) return;
  MessageLink* next;
  next = gms->nextMessage(),gms->nextMessage(NULL);
  for (;gms;gms = (GlobalMessage*)next) {
    next = gms->nextMessage(),gms->nextMessage(NULL);
    printf (" %s -> ",gms->Print());
  }
  putchar('\n');
}

static int current;
int is_enter_break()
  // {}
  // FUNCTION
  // int is_enter_break()
  // {}
  // ֥졼ݥ󥿤ãåƤPEֹ֤
  // {}
{
  int  ret = enter_break[ current ];
  if (ret == -1) return ret;
  enter_break[ current ] = -1;
  current = (current+1) % PAS_npe;
  return ret;
}

debugger_symbol wait_responce_form_pas()
  // {}
  // FUNCTION
  // debugger_symbol wait_responce_form_pas()
  // {}
  // ¹PASץΥåƻ뤷ơ줾б ư
  // ԤǥǥХåλ桼ꤷȡ桼ץ
  // λȽ꤬Ω硤QUIT֤
  // {}
{
  first_time = TRUE;
  waited_one_sec = FALSE;
  current = 0;
  last = 0;
  FOREVER {
  loop:
    if (is_terminated())
      break;
    if (Current_Message) {
      waited_one_sec = FALSE;
      debugger_symbol com = (debugger_symbol)Current_Message->Argv(0);
      int I_come_from = (int)Current_Message->Argv(1);
      rc_table[I_come_from]++;
      MessageLink* next;
      switch (com) {
      case BREAK:
	if (trace_enable[I_come_from]) {
	  enter_break[last] = I_come_from;
	  last = (last + 1) % PAS_npe;
	  next = Current_Message->nextMessage(),
	  Current_Message->nextMessage(NULL);
	  Current_Message->Free();
	  Current_Message = (GlobalMessage*)next;
	  int enter_pe;
	  while((enter_pe = is_enter_break()) >= 0) {
	    if (Current_Message) {
	      while (Current_Message) {
		if (TRECEIVE == (debugger_symbol)(Current_Message->Argv(0))) {
		  print_text_message(Current_Message);
		}
		if (BREAK == (debugger_symbol)(Current_Message->Argv(0))) {
		  int pen = (int)(Current_Message->Argv(1));
		  enter_break[last] = pen;
		  last = (last + 1) % PAS_npe;
		}
		Inc_Message_queue();
	      }
	    }
	    if (break_loop(enter_pe) == QUIT) {
	      while((enter_pe = is_enter_break()) >= 0) {
		message_to_PE(enter_pe, QUIT, FALSE);
	      }
	      goto resend;
	    }
	  }
	  goto loop;
	} else {
	  message_to_PE((int)(Current_Message->Argv(1)), CONTINUE, FALSE);
	}
	break;
      case ERECEIVE: case NRECEIVE:
	break;
      case TRECEIVE:
	print_text_message(Current_Message);
	break;
      case WAIT_MESSAGE:
	wait_pe[I_come_from] = TRUE;
	break;
      case RECD_MESSAGE:
	//pelog (" received message from %d ",I_come_from);
	wait_pe[I_come_from] = FALSE;
	used_pe[I_come_from] = TRUE;
	waited_one_sec = FALSE;
	break;
      case DEFAULT:
      default:
	break;
      }
      if (Current_Message) {
	Inc_Message_queue();
      }
      if (Current_Message)
	goto loop;
    } else {
      Current_Message = PAS_receive_in_nonblocking();
      if (Current_Message)
	waited_one_sec = FALSE;
    }
  }
 resend:
  GlobalMessage* gms;
  for (int oo = 0; oo < PAS_npe;oo++) {
    FOREVER {
      gms = PAS_receive_in_nonblocking();
      if (!gms)break;
      int I_come_from = (int)gms->Argv(1);
      rc_table[I_come_from]++;
      gms->Free();
    }
  }
  return QUIT;
}

void display_error_code(int w,ReceiveErrorCode ec)
  // {}
  // FUNCITON
  // void display_error_code(int w,ReceiveErrorCode ec)
  // {}
  // ץåw֤PASץΥ顼åɤå
  // ˥ǥɤɸϤɽ롥
  // {}
{
  switch (ec) {
  case UnKnownClass:
    cerr << form(" DB-Error PE#%d : %s\n",w,ErrUnKnownCLASS);
    break;
  case UnKnownPid:
    cerr << form(" DB-Error PE#%d : %s\n",w,ErrUnKnownPID);
    break;
  case UnKnownSlot:
    cerr << form(" DB-Error PE#%d : %s\n",w,ErrUnKnownSLOT);
    break;
  case UnKnownObject:
    cerr << form(" DB-Error PE#%d : %s\n",w,ErrUnKnownOBJECT);
    break;
  case UnKnownMethod:
    cerr << form(" DB-Error PE#%d : %s\n",w,ErrUnKnownMETHOD);
    break;
  case Sorry:
    cerr << form(" DB-Error PE#%d : %s\n",w,ErrM_SORRY);
    break;
  default:
    break;
  }
}

#define TIME 10000
void set_debug_info()
  // {}
  // FUNCTION
  // void set_debug_info()
  // {}
  // PASץФƥǥХåꤷȤΥ쥹ݥ󥹤Ф
  // Ԥ
  // {}
{
  int timeout ;
  for (int paspr = 0;paspr < PAS_npe;) {
    timeout = 0;
    if (!Current_Message) {
      while(timeout < TIME) {
	Current_Message = PAS_receive_in_nonblocking();
	if (Current_Message) break;
	timeout++;
      }
      if (timeout == TIME) return;
    }
    int I_come_from = Current_Message->Argv(1);
    debugger_symbol ret = (debugger_symbol)(Current_Message->Argv(0));
    if (ret == NRECEIVE) {
      paspr++;
    }
    if (ret == ERECEIVE) {
      paspr++;
      ReceiveErrorCode ec = (ReceiveErrorCode)Current_Message->Argv(2);
      display_error_code(I_come_from,ec);
    }
    if (TRECEIVE == ret) {
      print_text_message(Current_Message);
    }
    if (WAIT_MESSAGE == ret) {
      wait_pe[I_come_from] = TRUE;
      used_pe[I_come_from] = TRUE;
    }
    if (RECD_MESSAGE == ret) {
      wait_pe[I_come_from] = FALSE;
      used_pe[I_come_from] = TRUE;
      waited_one_sec = FALSE;
    }
    if (ret == BREAK) {
      int pen = (int)(Current_Message->Argv(1));
      enter_break[last] = pen;
      last = (last+1) % PAS_npe;
    }
    Inc_Message_queue();
  }
}

void display_static_info()
  // {}
  // FUNCTION
  // void display_static_info()
  // {}
  // PASץƼΥƥȾ˸ƤФؿǤ롥
  // ɽɽߤԤȤʤ롥顤桼
  // ץब¹ԤŪʥǥХåɽ뤿˺
  // ᤳΤ褦ʴؿ̾ĤƤ뤬¹Իˤơ쥸ɽ
  // ʤɤνؿȤƤѤƤ롥
  // {}
{
  line = 0;
  FOREVER {
    if (Current_Message) {
      if (line >= TEXTLINE) {
	cout << "--- type <return> key ---";
	cout.flush();
	getchar();
	line = 0;
      }
      debugger_symbol rec = Current_Message->Argv(0);
      int pen = (int)Current_Message->Argv(1);
      rc_table[pen]++;
      if (rec == NRECEIVE) {
	rc_table[pen]++;
	Inc_Message_queue();
	return;
      }
      if (rec == ERECEIVE) {
	// 顼ɤϤåϤ
	ReceiveErrorCode how_about = Current_Message->Argv(2);
	display_error_code(pen,how_about);
	Inc_Message_queue();
	return;
      }
      if (rec == TRECEIVE) {
	print_text_message(Current_Message);
      }
      if (WAIT_MESSAGE == rec) {
	wait_pe[pen] = TRUE;
	used_pe[pen] = TRUE;
      }
      if (RECD_MESSAGE == rec) {
	wait_pe[pen] = FALSE;
	used_pe[pen] = TRUE;
	waited_one_sec = FALSE;
      }
      if (rec == BREAK) {
	enter_break[last] = pen;
	last = (last+1) % PAS_npe;
      }
      Inc_Message_queue();
      continue;
    }else{
      Current_Message = PAS_receive_in_nonblocking();
    }
  }
}

void Listener()
  // {}
  // FUNCTION
  // void Listener()
  // {}
  // ʬĶǼ¹ԤǥХåǺǽ˸ƤФؿǡޥɤϡ
  // PASץؤؿθƤӽФԤ
  // {}
{
  last = 0;
  Boolean psw[PAS_npe];
  Boolean usd[PAS_npe];
  int ebl[PAS_npe];
  int rc[PAS_npe];
  Boolean dis_enable[PAS_npe];
  int ii;
  for (ii = 0;ii< PAS_npe;ii++) {
    usd[ii] = FALSE;
    psw[ii] = FALSE;
    ebl[ii] = -1;
    dis_enable[ii] = TRUE;
    rc[ii] = 0;
  }
  rc_table = rc;
  wait_pe = psw;
  used_pe  = usd;
  enter_break = ebl;
  trace_enable = dis_enable;
  message_to_PE(0,DEFAULT,FALSE);
  message_to_PE(0,DEFAULT,FALSE);
  int i;
  int pe;
  char textbf[BUFSIZ];
  Current_Message = (GlobalMessage*)0;
  FOREVER {
    sprintf(textbf,"%02d:%s",PAS_self_peno,PT_NORMAL);
    cout << textbf;
    cout.flush();
    textbf[0] = '\0';
    if (gets(textbf) == (char*)0)
      break;
    debugger_symbol com = command_parser(textbf);
    if (com == QUIT) {
      message_to_PAS(com,FALSE);
      break;
    }
    if (online(com))continue;
    switch (com) {
    case RUN:
      display_filenames();
      message_to_PAS(com);
      wait_responce_form_pas();
      shutdown_PAS();
      return;
    case DBPCLASS: case UBPCLASS: case DTRCLASS: case UTRCLASS: case DBPPID:
    case UBPPID: case DTRPID: case UTRPID: case DBPMETHOD: case UBPMETHOD:
    case DTRMETHOD: case UTRMETHOD: case DBPSLOT: case UBPSLOT: case DTRSLOT:
    case UTRSLOT:  case ASSEMBLE:
      for ( int i = 0; i < PAS_npe; i++ ) {
	message_to_PE(i,com,next_p);
	set_debug_info();
      }
      break;
    case DBPOBJECT: case UBPOBJECT: case DTROBJECT: case UTROBJECT:
    case DBPOBJMETHOD: case UBPOBJMETHOD: case DTROBJMETHOD: case UTROBJMETHOD:
    case DBPOBJSLOT: case UBPOBJSLOT: case DTROBJSLOT: case UTROBJSLOT:
    case STEP: case CONTINUE: case OBJSTAT: case OBJWAIT: case PRINT_SLOT:
    case OBJACT: case NEXTSTEP: case STEPINST:
    case DUMP_SCHEDULER: case DUMP_REG:
      cerr << form("Only Executing mode command\n");
      break;
    case OUTPUT:
      pe = atoi(next_p);
      trace_enable[pe] = !trace_enable[pe];
      if (trace_enable[pe])
	pelog("enable PE#%02d",pe);
      else
	pelog("disenable PE#%02d",pe);
      break;
    case CLASSINFO: case METHOD_LIST: case SLOT_LIST: case DESCRIBE:
      message_to_PE(0,com,next_p);
      display_static_info();
      break;
    case DUMP_PID: case CLASSES:
      message_to_PE(0,com);
      display_static_info();
      break;
    case TRACE_OFF: case TRACE_ON:
      message_to_PAS(com);
      trace_set();
      break;
    case DEFAULT:
    default:
      cerr << ErrM_UNDEFINED <<"\n";
      break;
    }
    for (i = 0;i < BUFSIZ;i++)
      textbf[i] = '\0';
  }
  shutdown_PAS();
}
