/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stream.h>
#include "config.h"
#include "aum/parallel.h"
#include "aum/debugger.h"

void ref_info()
{
  cout << "register (reg) n m -- ¹Ի̿줬쥸ɽReg[n] - Reg[m]\n";
  cout << "register (reg) m   -- ¹Ի̿줬쥸ɽReg[m]\n";
  cout << "register (reg)     -- ¹Ի̿줬쥸ɽ\n";
  cout << "pid -- PASProtocol_IDΥơ֥Ƥ򤹤٤ɽ롥\n";
  cout << "slots classname -- 饹ΥåȤФŪǥХåΥե饰ξɽ\n";
  cout << "methods classname -- 饹Υ᥽åɤФŪǥХåΥե饰ξɽ\n";
  cout << "class classname -- 饹ФŪǥХåΥե饰ξɽ\n";
  cout << "classes -- 桼饹ΰɽ\n";
  cout << "active -- ¹Υ֥Ȥ̾ɽ롥\n";
  cout << "waiting -- ¹Ԥ֤Υ֥Ȥ̾ɽ롥\n";
  cout << "processor -- PASǻѤƤץå\n";
}

void ref_help_processor_number()
{
  cout << "PASץåֹ\n";
}

void ref_help_quit()
{
  cout << "ǥХåζλ\n";
}

void ref_info_processor()
{
  cout << "PASΥץå "<<dec(PAS_npe)<<'\n';
}

void ref_help_info_current()
{
  cout << "info current \n\n";
  cout << "߼¹ǤåƬϤ鸽ߤϤޤ\n";
  cout << "ե֥Ԥʤɽ롥\n";
}

void ref_help_info()
{
  cout << "info KEYWORD -- KEYWORDФɽ롥\n";
  cout << "KEYWORDʲ˼\n";
  cout << "\n";
  cout << " register, pid, slots classname, methods classname,\n";
  cout << " class classname, classes, active, waiting, processor\n";
  cout << "ܺ٤ˤĤƤ help info KEYWORD 򻲾\n";
}

void ref_help()
{
  cout << "help -- ޥɤΰɽ롥\n";
  cout << "help COMMAND -- COMMANDǻꤵ줿ޥɤɽ롥\n";
  cout << "help expression -- break, trace, unbreak, untraceޥɤϥǡν\n";
  cout << "help pid -- åμ̻\n";
  cout << "help print_expression -- printޥɤϥǡν\n";
  cout << "help object_number -- ֥ȸֹͭ\n";
  cout << "help processor_number -- pas-dbPASץΥץֹ\n";
  cout << "info	 -- ǥХåξ֤ɽ롥\n";
  cout << "quit (exit,q) -- ǥХåζλ\n";
  cout << "run (r) -- 桼ץ¹Ԥ򳫻Ϥ롥\n";
  cout << "continue (cont, c) -- Υ֥졼ݥȤޤǼ¹ԤƳ롥\n";
  cout << "step (s,next,n) -- ƥå׼¹Ԥ롥\n";
  //  cout << "next (n) -- stepΥեФƼΥեޤǼ¹ԤƳ롥\n";
  cout << "stepi (si) -- ̿ñ̤ǤΥƥåפǼ¹ԤƳ롥\n";
  cout << "output PROCESSOR_NUMBER -- PROCESSOR_NUMBERǻꤵ줿PASץåξɽ";
  cout << "ɽڤؤ롥\n";
  cout << "trace on -- ̿Υȥ졼⡼ɤꤹ롥\n";
  cout << "trace off -- ̿Υȥ졼⡼ɤꤹ롥\n";
  cout << "break EXPRESSION -- ֥졼ݥȤꤹ롥\n";
  cout << "unbreak EXPRESSION -- ֥졼ݥȤ롥\n";
  cout << "trace EXPRESSION -- ȥ졼⡼ɤꤹ롥\n";
  cout << "untrace EXPRESSION -- ȥ졼⡼ɤ롥\n";
  cout << "print PRINT_EXPRESSION -- ץͤɽ롥\n";
}

void ref_help_step()
{
  cout << "¹ԤƳʲΤ줫λãȤǺƤߤ롥\n";
  cout << "\n";
  cout << "1  ǤդΥ֥졼ȯ\n";
  cout << "2  åľ\n";
  cout << "3  åȥμ¹\n";
  cout << "4  åȥμ¹Ը\n";
  cout << "5  ʬ̿μ¹\n";
  cout << "6  ʬ̿μ¹Ը̿\n";
  cout << "7  descendμ¹\n";
  cout << "8  descendμ¹Ը\n";
}

void ref_help_next()
{
  cout << "help step \n";
}

void ref_help_stepi()
{
  cout << "̿ñ̤ǤΥƥå׼¹ԤǤ롥\n";
}

void ref_help_run()
{
  cout << "run (r)\n";
  cout << "桼ץμ¹Ԥ򳫻Ϥ롥\n";
}

void ref_help_continue()
{
  cout << "continue (cont, c)\n";
  cout << "Υ֥졼ݥȤޤǼ¹ԤƳ롥\n";
}

void ref_help_tron()
{
  cout << "trace on\n";
  cout << "̿ȥ졼⡼ɤꤹ롥\n";
}

void ref_help_troff()
{
  cout << "trace off\n";
  cout << "̿ȥ졼⡼ɤ롥\n";
}

void ref_help_output()
{
  cout << "output PROCESSOR_NUMBER\n";
  cout << "PROCESSOR_NUMBERǻꤵ줿PASץξǥХå¦ǡɽ\n";
  cout << "뤫ݤڤؤ롥\n";
}

void ref_help_break()
{
  cout << "break EXPRESSION\n";
  cout << "\n";
  cout << "EXPRESSIONǻꤵ˥֥졼ݥȤꤹ롥\n";
  cout << "EXPRESSION ν񼰤ˤĤƤ help expression \n";
}

void ref_help_unbreak()
{
  cout << "unbreak EXPRESSION\n";
  cout << "\n";
  cout << "EXPRESSIONǻꤵꤵ줿֥졼ݥȤ롥\n";
  cout << "EXPRESSION ν񼰤ˤĤƤ help expression \n";
}

void ref_help_trace()
{
  cout << "trace EXPRESSION\n";
  cout << "\n";
  cout << "EXPRESSIONǻꤵ˥ȥ졼⡼ɤꤹ롥\n";
  cout << "EXPRESSION ν񼰤ˤĤƤ help expression \n";
}

void ref_help_untrace()
{
  cout << "untrace EXPRESSION\n";
  cout << "\n";
  cout << "EXPRESSIONǻꤵꤵ줿ȥ졼⡼ɤ롥\n";
  cout << "EXPRESSION ν񼰤ˤĤƤ help expression \n";
}

void ref_help_print()
{
  cout << "print PRINT_EXPRESSION\n";
  cout << "\n";
  cout << "PRINT_EXPRESSIONǼΤɽ롥\n";
  cout << "PRINT_EXPRESSION ǻǤΤϡhelp print_expression 򻲾\n";
}

void ref_help_expression()
{
  cout << "break, unbreak, trace, untraceޥɤϥǡν񼰤ϡʲ̤Ǥ롥\n";
  cout << "OBJECT_NUMBER ˤĤƤ help object_number 򻲾\n";
  cout << "PROTOCOL_ID ˤĤƤ help pid 򻲾\n";
  cout << "\n";
  cout << "EXPRESSION: \n";
  cout << "  PROTOCOL_ID			  % å\n";
  cout << "  classname				  % 饹\n";
  cout << "  classname \'!\' slotname		  % 饹νüå\n";
  cout << "  classname \'@\' slotname		  % 饹üå\n";
  cout << "  classname PROTOCOL_ID   % 饹Υ᥽å\n";
  cout << "  classname \'_0x\' OBJECT_NUMBER	  % ֥\n";
  cout << "  classname \'_0x\' OBJECT_NUMBER \'!\' slotname % ֥Ȥνüå\n";
  cout << "  classname \'_0x\' OBJECT_NUMBER \'@\' slotname % ֥Ȥüå\n";
  cout << "  classname \'_0x\' OBJECT_NUMBER PROTOCOL_ID % ֥ȤΥ᥽å\n";
}

void ref_help_object_number()
{
  cout << "OBJECT_NUMBER\n";
  cout << "\n";
  cout << "֥ȤˤƸͭդ줿ֹǤ롥\n";
  cout << "ǥХåǥ֥ȤλԤʤϡ¹ԻΥ֥졼ݥȤǡ\n";
  cout << "info active, info waiting, info register ǻȲǽʥ֥Ȥ˸¤롥\n";
}

void ref_help_print_expression()
{
  cout << "print ޥɤϥǡPRINT_EXPRESSIONʲ˼\n";
  cout << "OBJECT_NUMBERˤĤƤ help object_number 򻲾\n";
  cout << "\n";
  cout << "PRINT_EXPRESSION :\n";
  cout << "	  classname \'_0x\' OBJECT_NUMBER \'!\' slotname\n";
  cout << "		     ֥ȤνüåȤ\n";
  cout << "	  classname \'_0x\' OBJECT_NUMBER \'@\' slotname\n";
  cout << "		     ֥ȤüåȤ\n";
  cout << "	  classname \'_0x\' OBJECT_NUMBER\n";
  cout << "		     ֥Ȥξ\n";
  cout << "	  active\n";
  cout << "		     ¹Υ֥Ȥξ\n";
}

void ref_help_info_pid()
{
  cout << "ķprotocol_IDΰɽ롥\n";
  cout << "Ȥ߹ߤΥ᥽åɤprotocol_IDɽθ˥桼\n";
  cout << "protocol_IDɽ롥\n";
}

void ref_help_info_register()
{
  cout << "info register n m\n";
  cout << "info register m\n";
  cout << "info register\n";
  cout << "\n";
  cout << "¹ԻΥǥХåоݤPASץåΥ쥸ξ֤ɽ롥\n";
  cout << "쥸ֹϰϤꤹ뤳ȤǤReg[n]Reg[m]ޤǡ\n";
  cout << "뤤ϡReg[m]Ƥɽ롥\n";
  cout << "ϰϤλ꤬ƤʤС쥸Ƥɽ롥\n";
}

void ref_help_info_class()
{
  cout << "info class classname \n";
  cout << "\n";
  cout << "classnameǻꤵ륯饹ŪǥХåɽ롥\n";
}

void ref_help_info_methods()
{
  cout << "info methods classname \n";
  cout << "\n";
  cout << "classnameǻꤵ륯饹Υ᥽å̾ɽ롥\n";
}

void ref_help_info_slots()
{
  cout << "info slots classname \n";
  cout << "\n";
  cout << "classnameǻꤵ륯饹Υå̾ɽ롥\n";
}

void ref_help_info_processor()
{
  cout << "info processor\n";
  cout << "\n";
  cout << "PASμ¹ԥץɽ롥\n";
}

void ref_help_info_classes()
{
  cout << "info classes\n";
  cout << "\n";
  cout << "ɤ߹ޤƤ桼饹Υ饹̾ΰɽ롥\n";
  cout << "⤷ɽƤ륯饹̾¾Υ饹ѾƤ硥ʲɽԤ\n";
}

void ref_help_info_active()
{
  cout << "info active\n";
  cout << "\n";
  cout << "߼¹Υ֥Ȥ̾ɽ롥\n";
}

void ref_help_info_waiting()
{
  cout << "info waiting\n";
  cout << "\n";
  cout << "߼¹Ԥ֤Υ֥ȷ̾ɽ롥\n";
}

//void ref_help_info_scheduler()
//{
//  cout << "info scheduler\n";
//  cout << "\n";
//  cout << "¹ԻΥǥХåоݤPASץåΥ塼ξ֤ɽ롥\n";
//}

void ref_help_protocolID()
{
  cout << "PROTOCOL_ID ϥåμ̻ҤǤ롥\n";
  cout << "PROTOCOL_ID ˤäƻǤåϰĤΤ˸¤롥\n";
  cout << "PROTOCOL_ID ν񼰤ʲ˼\n";
  cout << "\n";
  cout << "    PROTOCOL_ID :\n";
  cout << "	   \':\' method_name \'/\' MODE_LIST\n";
  cout << "	MODE_LIST :\n";
  cout << "		ǤոĤMODE¤\n";
  cout << "	MODE :\n";
  cout << "		\'+\' ޤ \'-\'\n";
  cout << "\n";
  cout << "MODE_LIST ϥåγưΥ⡼ɤɽ\n";
  cout << "MODE_LIST  i ܤ MODE  i ܤΰб롥\n";
  cout << "'+'Ͻüΰ'-'üΰɽ\n";
}

int online(debugger_symbol com)
{
  switch(com){
  case HELP_PID:
    ref_help_protocolID();
    return 1;
  case INFO_PROCESSOR:
    ref_info_processor();
    return 1;
  case HELP_INFO_PROCESSOR:
    ref_help_info_processor();
    return 1;
  case HELP_INFO_CURRENT:
    ref_help_info_current();
    return 1;
  case HELP_PROCESSOR_NUMBER:
    ref_help_processor_number();
      return 1;
  case HELP_EXPRESSION:
    ref_help_expression();
    return 1;
  case HELP_PRINT_EXPRESSION:
    ref_help_print_expression();
    return 1;
  case HELP_OBJECT_NUMBER:
    ref_help_object_number();
      return 1;
  case INFO:
    ref_info();
    return 1;
  case HELP_PRINT_REGISTER:
    ref_help_info_register();
      return 1;
  case HELP_PRINT_FLAGS:
    ref_help_info_class();
    return 1;
  case HELP_INFO_SLOTS:
    ref_help_info_slots();
    return 1;
  case HELP_INFO_METHODS:
    ref_help_info_methods();
    return 1;
  case HELP_PRINT_CLASSES:
    ref_help_info_classes();
      return 1;
  case HELP_PRINT_ACTIVE:
    ref_help_info_active();
    return 1;
  case HELP_PRINT_WAITING:
    ref_help_info_waiting();
    return 1;
  case HELP_INFO_PID:
    ref_help_info_pid();
    return 1;
      //case HELP_PRINT_SCHEDULER:
    //ref_help_info_scheduler();
    // return 1;
  case HELP_PRINT:
    ref_help_print();
    return 1;
  case HELP_BREAK:
    ref_help_break();
    return 1;
  case HELP_UNBREAK:
    ref_help_unbreak();
    return 1;
  case HELP_TRACE:
      ref_help_trace();
    return 1;
  case HELP_UNTRACE:
    ref_help_untrace();
    return 1;
    case HELP_OUTPUT:
    ref_help_output();
    return 1;
  case HELP_TRON:
    ref_help_tron();
    return 1;
  case HELP_TROFF:
    ref_help_troff();
      return 1;
  case HELP_CONTINUE:
    ref_help_continue();
    return 1;
  case HELP_RUN:
    ref_help_run();
    return 1;
  case HELP_NEXT:
    ref_help_next();
    return 1;
  case HELP_STEP:
    ref_help_step();
    return 1;
  case HELP_QUIT:
    ref_help_quit();
    return 1;
  case HELP_STEP_I:
    ref_help_stepi();
    return 1;
  case HELP_INFO:
    ref_help_info();
    return 1;
  case HELP:
    ref_help();
    return 1;
  default:
    break;
  }
  return 0;
}
