/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/aumtype.h"
#include "aum/object.h"
#include "aum/word.h"
#include "aum/types.h"
#include "aum/protocolid.h"
#include "aum/global.h"
#include "aum/tstream.h"
#include "class/template.h"
#include "class/clink.h"
#ifdef PAS_DEBUGGER
#include "aum/trace.h"
#include <stream.h>

extern int TraceStreamLevel;
extern void message_to_Listener(debugger_symbol,unsigned char*);
extern const char* dis_assemble_code(const Instruction *const oa, int* na);

void disasm_method()
    // {}
    // åμ¹ԳϤ鸽ߤϤޤ
    // ̿εե֥Ԥʤ
    // {}
{
    int next;
    if (CurrentObject) {
	if (CurrentMessage) {
	    if (InstructionPointer == (Instruction*)0) return;
	    Instruction* insp = (Instruction*)
		(CurrentObject->ClassTemplate()->SearchMethod(CurrentMessage));
	    for (;;){
		next = 0;
		char* discode = (char*)dis_assemble_code(insp,&next);
		if (InstructionPointer == (Instruction*)0) break;
		if (next == 0) break;
		tstream tout = tstream();
		tout.form("%02d:",PAS_self_peno);
		tout <<CurrentObject->Printname()<<":"<<
		    CurrentMessage->Print ()
		    <<"	 "<< discode <<"\n";
		message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
		tout.Initialize();
		if (insp == InstructionPointer) break;
		insp += next;
	    }
	}
    }
}
#endif
/*-----------------
 * Local Variables:
 * c-argdecl-indent:4
 * c-indent-level:4
 * c-label-offset:-4
 * c-continued-statement-offset:4
 * End:
 */
