/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
#include "aum/debugger.h"
#include "command.h"

Command command_table[] = {
    {1,{"run"},RUN},
    {1,{"exit"},QUIT},
    {1,{"quit"},QUIT},
    {1,{"next"},NEXTSTEP},
    {1,{"stepi"},STEPINST},
    {1,{"step"},STEP},
//    {1,{"assemble"},ASSEMBLE},
    {1,{"continue"},CONTINUE},
    {1,{"cont"},CONTINUE},
    {1,{"tron"},TRACE_ON},
    {1,{"troff"},TRACE_OFF},
    {2,{"trace","on"},TRACE_ON},
    {2,{"trace","off"},TRACE_OFF},

    {2,{"untrace","objmethodname"},UTROBJMETHOD},
    {2,{"untrace","objslotname"},UTROBJSLOT},
    {2,{"untrace","objectname"},UTROBJECT},
    {2,{"untrace","methodname"},UTRMETHOD},
    {2,{"untrace","slotname"},UTRSLOT},
    {2,{"untrace","pidsymbol"},UTRPID},
    {2,{"untrace","classname"},UTRCLASS},

    {2,{"trace","objmethodname"},DTROBJMETHOD},
    {2,{"trace","objslotname"},DTROBJSLOT},
    {2,{"trace","objectname"},DTROBJECT},
    {2,{"trace","methodname"},DTRMETHOD},
    {2,{"trace","slotname"},DTRSLOT},
    {2,{"trace","pidsymbol"},DTRPID},
    {2,{"trace","classname"},DTRCLASS},

    {2,{"unbreak","objmethodname"},UBPOBJMETHOD},
    {2,{"unbreak","objslotname"},UBPOBJSLOT},
    {2,{"unbreak","objectname"},UBPOBJECT},
    {2,{"unbreak","methodname"},UBPMETHOD},
    {2,{"unbreak","slotname"},UBPSLOT},
    {2,{"unbreak","pidsymbol"},UBPPID},
    {2,{"unbreak","classname"},UBPCLASS},

    {2,{"break","objmethodname"},DBPOBJMETHOD},
    {2,{"break","objslotname"},DBPOBJSLOT},
    {2,{"break","objectname"},DBPOBJECT},
    {2,{"break","methodname"},DBPMETHOD},
    {2,{"break","slotname"},DBPSLOT},
    {2,{"break","pidsymbol"},DBPPID},
    {2,{"break","classname"},DBPCLASS},

    //{2,{"describe","classname"},DESCRIBE},

    {3,{"help","info","register"},HELP_PRINT_REGISTER},
    {3,{"help","info","class","classname"},HELP_PRINT_FLAGS},
    {3,{"help","info","slots","classname"},HELP_INFO_SLOTS},
    {3,{"help","info","methods","classname"},HELP_INFO_METHODS},
    {3,{"help","info","classes"},HELP_PRINT_CLASSES},
    {3,{"help","info","active"},HELP_PRINT_ACTIVE},
    {3,{"help","info","waiting"},HELP_PRINT_WAITING},
    {3,{"help","info","processor"},HELP_INFO_PROCESSOR},
    {3,{"help","info","current"},HELP_INFO_CURRENT},
    //{3,{"help","info","scheduler"},HELP_PRINT_SCHEDULER},
    {3,{"help","info","pid"},HELP_INFO_PID},

    {3,{"info","methods","classname"},METHOD_LIST},
    {2,{"info","classes"},CLASSES},
    {3,{"info","class","classname"},CLASSINFO},
    {3,{"info","slots","classname"},SLOT_LIST},
    //{2,{"info","scheduler"},DUMP_SCHEDULER},
    {2,{"info","register","number","number"},DUMP_REG},
    {2,{"info","register","number"},DUMP_REG},
    {2,{"info","register"},DUMP_REG},
    {2,{"info","reg"},DUMP_REG},
    {2,{"info","pid"},DUMP_PID},
    {2,{"info","active"},OBJACT},
    {2,{"info","waiting"},OBJWAIT},

    {2,{"info","current"},INFO_CURRENT},
    {2,{"info","PROCESSOR"},INFO_PROCESSOR},
    {2,{"info","processor"},INFO_PROCESSOR},
    {1,{"info"},INFO},

    {2,{"help","EXPRESSION"},HELP_EXPRESSION},
    {2,{"help","expression"},HELP_EXPRESSION},
    {2,{"help","PRINT_EXPRESSION"},HELP_PRINT_EXPRESSION},
    {2,{"help","print_expression"},HELP_PRINT_EXPRESSION},
    {2,{"help","object_number"},HELP_OBJECT_NUMBER},

    {2,{"help","pid"},HELP_PID},

    {2,{"help","PROCESSOR_NUMBER"},HELP_PROCESSOR_NUMBER},
    {2,{"help","processor_number"},HELP_PROCESSOR_NUMBER},

    {2,{"help","print"},HELP_PRINT},
    {3,{"help","trace","on"},HELP_TRON},
    {3,{"help","trace","off"},HELP_TROFF},
    {2,{"help","break"},HELP_BREAK},
    {2,{"help","unbreak"},HELP_UNBREAK},
    {2,{"help","trace"},HELP_TRACE},
    {2,{"help","untrace"},HELP_UNTRACE},
    {2,{"help","output"},HELP_OUTPUT},
    {2,{"help","continue"},HELP_CONTINUE},
    {2,{"help","run"},HELP_RUN},
    {2,{"help","quit"},HELP_QUIT},
    {2,{"help","exit"},HELP_QUIT},
    {2,{"help","stepi"},HELP_STEP_I},
    {2,{"help","step"},HELP_STEP},
    {2,{"help","next"},HELP_NEXT},
    {2,{"help","info"},HELP_INFO},
    {1,{"help"},HELP},

    {1,{"output"},OUTPUT},
    {2,{"print","objslotname"},PRINT_SLOT},
    {2,{"print","objectname"},OBJSTAT},
    {2,{"print","classname"},OBJSTAT},

    {1,{"next"},STEP},
    {1,{"si"},STEPINST},
    {2,{"b","objmethodname"},DBPOBJMETHOD},
    {2,{"b","objslotname"},DBPOBJSLOT},
    {2,{"b","objectname"},DBPOBJECT},
    {2,{"b","methodname"},DBPMETHOD},
    {2,{"b","slotname"},DBPSLOT},
    {2,{"b","pidsymbol"},DBPPID},
    {2,{"b","classname"},DBPCLASS},
    {2,{"t","objmethodname"},DTROBJMETHOD},
    {2,{"t","objslotname"},DTROBJSLOT},
    {2,{"t","objectname"},DTROBJECT},
    {2,{"t","methodname"},DTRMETHOD},
    {2,{"t","slotname"},DTRSLOT},
    {2,{"t","pidsymbol"},DTRPID},
    {2,{"t","classname"},DTRCLASS},
    {1,{"c"},CONTINUE},
    {1,{"n"},NEXTSTEP},
    {1,{"q"},QUIT},
    {1,{"s"},STEP},
    {1,{"r"},RUN},
    {1,{"?"},HELP},
};

int comtsize = (int)(sizeof(command_table)/sizeof(Command));
