/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "config.h"

#include <stdio.h>
#include <stream.h>

#include "aum/debugger.h"
#ifdef PAS_DEBUGGER
#include <assert.h>
#include "aum/stdlib.h"
#include "aum/string.h"
#include "aum/fetch.h"
#include "aum/global.h"
#include "aum/globlmsg.h"
#include "aum/localmsg.h"
#include "aum/parallel.h"
#include "aum/scheduler.h"
#include "aum/tstream.h"
#include "class/template.h"
#include "class/method.h"
#include "class/supers.h"
#include "class/clink.h"
#include "table/protocol.h"
#include "table/atomhash.h"
#include "debugger/src/debugpe.h"
#include "debugger/src/online.h"

//#define OBJECT_DEBUG
extern "C"{
    void Resouce_Monitoring();
};
typedef const ClassTmpl	 ConstClassTmpl;

extern void display_error_code(int w,ReceiveErrorCode ec);
extern ProtocolEntry *SearchProtocolID (ProtocolID & so);
extern char* next_p;
extern debugger_symbol command_parser(char* command);
extern ClassInfo* ClassTable[ClassTableSize];
extern _ProtocolTable* ProtocolTable;
extern void DumpScheduleTable();
extern void DumpClassTable();
extern void DumpProtocolIDTable();
extern ClassInfo* Find_class_info(Name);
extern int Symbol2Pid_Entry_Index(u_char*);
extern Name print(Word w);
extern int aum_assembler(const char* name);
extern void doInterpreter();
extern int Texport;
extern int Timport;
extern int receive_messages;
extern Initialize_private(int, int);
extern void execute_sys_message(GlobalMessage* gm);
extern void display_filenames();
extern void disasm_method();

/* Debugger data definition */
/* Begin */
/* Var */ static u_char* next_str_pointer;
/* Expl Begin */
// ޥɲϻ˼˲Ϥ٤ʸ֤¸뤿Υݥ
/* Expl End */
/* Var */ static u_char textbuff[BUFSIZ];
/* Expl Begin */
// ȤƥޥɲϤΥΰ衤ɽΤΥΰʤɤ˻ѤƤ롥
/* Expl End */
/* Var */ static int search_loop;
/* Expl Begin */
// åȥ᥽åɥΥǥåΥ󥿡ʥ
/* Expl End */
/* Var */ int slotcount;
/* Expl Begin */
// åȥΥǥåΥ
/* Expl End */
/* Var */ int methodcount;
/* Expl Begin */
// ᥽åɥΥǥåΥ
/* Expl End */
/* Var */ Boolean now_running;
/* Expl Begin */
// ߥ桼ץμ¹椫򼨤ѿ
/* Expl End */
/* Var */ static int from,to;
/* Expl Begin */
// 쥸ɽΰ٤ֹǼѿ
/* Expl End */
/* Var */ char bit[7];
/* Expl Begin */
// ǥХåե饰ξɽΤΥʸ
/* Expl End */

/* Data End */

void error_message_to_Listener(ReceiveErrorCode ec)
    // {}
    // FUNCTION
    // void error_message_to_Listener(ReceiveErrorCode ec)
    // {}
    // ǥХåץˤơ顼ɥå롥
    // {}
{
    if (PAS_npe>1) {
	GlobalMessage* gms = (GlobalMessage*)0;
	gms = new_GlobalMessage(Msg_Debugger,32,(ProtocolID&)0);
	gms->Argv(0,ERECEIVE);
	gms->Argv(1,PAS_self_peno);
	gms->Argv(2,ec);
	PAS_send(DEBUGGER_PE,gms);
    } else {
	display_error_code(PAS_self_peno,ec);
    }
}

void queued_sys_message(GlobalMessage* gms_rec)
    // {}
    // FUNCTION
    // void queued_sys_message(GlobalMessage* gms_rec)
    // {}
    // ᥽åɼ¹˳Ƥ륷ƥå¹Ԥȥ
    // ȤλȲ˲ͭ뤿ᡤĤΥå塼
    // Ū˻¸롥
    // {}
{
    if (!global_message_queue){
	global_message_queue = gms_rec;
	return;
    }

    MessageLink* next;
    next = global_message_queue->nextMessage();
    GlobalMessage* wp;
    wp = global_message_queue;
    while (next){
	wp = (GlobalMessage*)next;
	next = wp->nextMessage();
    }
    MessageLink* last;
    last = (MessageLink*)gms_rec;
    wp->nextMessage(last);
    return;
}

void message_to_Listener(debugger_symbol com,u_char* str)
    // {}
    // FUNCTION
    // void message_to_Listener(debugger_symbol com,u_char* str)
    // {}
    // ǥХåץФƥåcomȤʸ
    // ĥå롥ƥǥХåץΥХå
    // ԤġΤȤ¾PASץΥƥåʤ
    // å塼¸Interpreterǡ¸å˼¹
    // 롥
    // {}
{
    if (PAS_npe == 1) {
	cout << (char*)str;
	cout.flush();
	return;
    }
    u_char* jstr = (u_char*)jis_to_euc((const u_char*)str);
    int length = jstrlen(jstr);
    int packets = length/PACKET_SIZE+1;
    int work = 0;
    GlobalMessage* gms_rec = (GlobalMessage*)0;
    for (;work < length;) {
	GlobalMessage* gms = (GlobalMessage*)0;
	gms = new_GlobalMessage(Msg_Debugger,32,(ProtocolID&)0);
	gms->Argv(0,com);
	gms->Argv(1,PAS_self_peno);
	gms->Argv(2,packets);
	for (int ac = 3;(ac<32)&&(work<length);ac++,work++) {
	    unsigned int lett = *(jstr+work);
	    if (IsEUC(lett)) {
	      work++;
	      lett <<=8;
	      lett += *(jstr+work);
	  }
	    gms->Argv(ac,lett);
	}
	if (ac < 32) {
	    gms->Argv(ac,0);
	}
	PAS_send(DEBUGGER_PE,gms);
    loop:
	if (gms_rec) {
	    if ((gms_rec->Tag()) == Msg_Debugger) {
		MessageLink* next;
		next = gms_rec->nextMessage(),gms_rec->nextMessage(NULL);
		execute_sys_message(gms_rec);
		gms_rec->Free();
		gms_rec = (GlobalMessage*)next;
		continue;
	    } else {
		MessageLink* next;
		next = gms_rec->nextMessage(),gms_rec->nextMessage(NULL);
		queued_sys_message(gms_rec);
		gms_rec = (GlobalMessage*)next;
		goto loop;
	    }
	} else {
	    if (!(gms_rec = PAS_receive_in_nonblocking()))
		gms_rec = PAS_receive();
	    goto loop;
	}
    }
    CancellString((char*)jstr);
    while (gms_rec) {
	MessageLink* next;
	next = gms_rec->nextMessage(),gms_rec->nextMessage(NULL);
	if ((gms_rec->Tag()) == Msg_Debugger) {
	    execute_sys_message(gms_rec);
	    gms_rec->Free();
	}else
	    queued_sys_message(gms_rec);
	gms_rec = (GlobalMessage*)next;
    }
}

void message_to_Listener(debugger_symbol com)
    // {}
    // FUNCTION
    // void message_to_Listener(debugger_symbol com)
    // {}
    // ǥХåץФơåcomİʤå
    // 롥
    // {}
{
    if (PAS_npe == 1)
	return ;
    GlobalMessage* gms = (GlobalMessage*)0;
    gms = new_GlobalMessage(Msg_Debugger,3,(ProtocolID&)0);
    gms->Argv(0,com);
    gms->Argv(1,PAS_self_peno);
    PAS_send(DEBUGGER_PE,gms);
}

int outletslotindex(const ClassTmpl* ctmp,u_char* str,Boolean top = TRUE)
    // {}
    // FUNCITION
    // int outletslotindex(const ClassTmpl* ctmp,u_char* str,Boolean top = TRUE)
    // {}
    // 饹ƥץ졼ctmpηѾƵŪéʤ顤üå̾str
    // ǼüåȤõǥå֤topTRUEʤ
    // ӽФΡǾ̤ǤȤǥåΥȤƤ롥
    // {}
{
    Supers* su = ctmp->Supers();
    int no = ctmp->no_of_outlets();
    int pp;
    if (top) search_loop = 0;
    for (pp = 0;pp < no;pp++,search_loop++)
	if (strcmp((ctmp->OutletSlotName(pp)),(char*)str)==0)
	    return search_loop;
    int sps = su->no_of_supers();
    for (int sc = 0;sc < sps;sc++) {
	const ClassTmpl* dtmp = su->Element(sc)->ClassTemplate();
	if (outletslotindex(dtmp,str,FALSE)>=0)
	    return search_loop;
    }
    return -1;
}

int inletslotindex(const ClassTmpl* ctmp,u_char* str,Boolean top = TRUE)
    // {}
    // FUNCITION
    // int inletslotindex(const ClassTmpl* ctmp,u_char* str,Boolean top = TRUE)
    // {}
    // 饹ƥץ졼ctmpηѾƵŪéʤ顤üå̾str
    // ǼüåȤõǥå֤topTRUEʤ
    // ӽФΡǾ̤ǤȤǥåΥȤƤ롥
    // {}
{
    Supers* su = ctmp->Supers();
    int ni = ctmp->no_of_inlets();
    int pp;
    if (top) search_loop = 0;
    for (pp = 0;pp < ni;pp++,search_loop++)
	if (strcmp((ctmp->InletSlotName(pp)),(char*)str)==0)
	    return search_loop;
    int sps = su->no_of_supers();
    for (int sc = 0;sc < sps;sc++) {
	const ClassTmpl* dtmp = su->Element(sc)->ClassTemplate();
	if (inletslotindex(dtmp,str,FALSE)>=0) {
	    return search_loop;
	}
    }
    return -1;
}

ClassInfo* class_symbol_2_info(u_char* str,u_char eof_char)
    // {}
    // FUNCTION
    // ClassInfo* class_symbol_2_info(u_char* str,u_char eof_char)
    // {}
    // 饹̾strΥ饹ե᡼õơ֥ǤϤ ֤
    // eof_charʸΥ饹̾νüʬ򸡽ФʸɤꤷƤ
    // 롥
    // {}
{
    char obj_name[BUFSIZ];
    for(char* wp = obj_name;((*str != '\0')&&(*str != ' ')&&
			     (*str != eof_char));str++,wp++)
	*wp = *str;
    if ( (*str != eof_char)&&(*str == '\0') ) return (ClassInfo*)0;
    *wp = '\0';
    next_str_pointer = str;
    return Find_class_info(obj_name);
}

void debugg_slots(u_char* oname,debugger_symbol s)
    // {}
    // 饹ƥץ졼ȤΥåȤΥǥХåӥåȤ
    // {}
{
    Boolean is_outlet = FALSE;
    for(u_char* wp = oname;((*wp != '\0')&&(*wp != '@')&&(*wp != '!'));wp++);
    if (*wp == '\0') return;
    if (*wp == '!')
	is_outlet =TRUE;
    char eof_char = (is_outlet) ? '!' : '@' ;
    ClassInfo* input_class;
    if ((input_class = class_symbol_2_info(oname,eof_char))==(ClassInfo*)0) {
	error_message_to_Listener(UnKnownClass);
	return;
    }
    for(;*next_str_pointer ==' ';)
	next_str_pointer++;
    next_str_pointer++;
    for(int u = 1;;next_str_pointer++) {
	switch (*next_str_pointer) {
	case ' ': case '\t':
	    break;
	case '\0':
	    error_message_to_Listener(UnKnownSlot);
	    return;
	default:
	    u = 0;
	    break;
	}
	if (!u)break;
    }
    int search_loop = 0;
    Boolean find = FALSE;
    ClassTmpl* ctmp = input_class->ClassTemplate();
    if (is_outlet) {
	if ((search_loop = outletslotindex(ctmp,next_str_pointer))>=0)
	    find = TRUE;
	search_loop += ctmp->no_of_all_inlets();
    } else {
	if ((search_loop = inletslotindex(ctmp,next_str_pointer))>=0)
	    find = TRUE;
    }
    if (!find) {
	error_message_to_Listener(UnKnownSlot);
	return;
    }
    tstream tout = tstream();
    switch (s) {
    case DBPSLOT:
	ctmp->SetBreakSlot(search_loop);
	tout <<form("%02d",PAS_self_peno)<<" Set Bpt Slot " << (char*)(oname)<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case UBPSLOT:
	ctmp->SetUnBreakSlot(search_loop);
	tout <<form("%02d",PAS_self_peno)<<" Reset Bpt Slot " << (char*)oname<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case DTRSLOT:
	ctmp->SetTraceSlot(search_loop);
	tout <<form("%02d",PAS_self_peno)<<" Set Tr Slot " << (char*)oname<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    default:
	ctmp->SetUnTraceSlot(search_loop);
	tout <<form("%02d",PAS_self_peno)<<" Reset Tr Slot " << (char*)oname<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    }
    message_to_Listener(NRECEIVE);
}

void debugg_methods(u_char* oname,debugger_symbol s)
    // {}
    // 饹ƥץ졼ȤΥ᥽åɤΥǥХåӥåȤ
    // {}
{
    ClassInfo* input_class;
    if ((input_class = class_symbol_2_info(oname,':'))==(ClassInfo*)0) {
	error_message_to_Listener(UnKnownClass);
	return;
    }
    for(;*next_str_pointer ==' ';)
	next_str_pointer++;
    next_str_pointer++;
    ClassTmpl* ctmp = input_class->ClassTemplate();
    for(int u = 1;;next_str_pointer++) {
	switch (*next_str_pointer) {
	case ' ': case '\t':
	    break;
	case '\0':
	    error_message_to_Listener(UnKnownMethod);
	    return;
	default:
	    u = 0;
	    break;
	}
	if (!u)break;
    }
    int me;
    if ((me = ctmp->LookMethodIndex(next_str_pointer))<0) {
	error_message_to_Listener(UnKnownMethod);
	return;
    }
    tstream tout = tstream();
    switch (s) {
    case DBPMETHOD:
	ctmp->SetBreakMethod(me);
	tout <<form("%02d",PAS_self_peno)<<" Set Bpt Method " << (char*)oname<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case DTRMETHOD:
	ctmp->SetTraceMethod(me);
	tout <<form("%02d",PAS_self_peno)<<" Set Tr Method " << (char*)oname<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case UBPMETHOD:
	ctmp->SetUnBreakMethod(me);
	tout <<form("%02d",PAS_self_peno)<<" Reset Bpt Method " << (char*)oname<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    default:
	ctmp->SetUnTraceMethod(me);
	tout <<form("%02d",PAS_self_peno)<<" Reset Tr Method " << (char*)oname<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    }
    message_to_Listener(NRECEIVE);
}

void debugg_class(u_char* oname,debugger_symbol s)
    // {}
    // 饹ƥץ졼ȤΥ饹ΥǥХåӥåȤ롥
    // onameϥ饹̾s϶Ūʥӥåġ
    // {}
{
    ClassInfo* input_class;
    if ((input_class = class_symbol_2_info(oname,'\0'))==(ClassInfo*)0) {
	error_message_to_Listener(UnKnownClass);
	return;
    }
    ClassTmpl* ctmp = input_class->ClassTemplate();
    tstream tout = tstream();
    switch (s) {
    case DBPCLASS:
	ctmp->SetBreakClass();
	tout <<form("%02d",PAS_self_peno)<<
	    " Set Bpt Class " << ctmp->Printname()<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	message_to_Listener(NRECEIVE);
	return;
    case UBPCLASS:
	ctmp->SetUnBreakClass();
	tout <<form("%02d",PAS_self_peno)<<
	    " Reset Bpt Class " << ctmp->Printname()<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	message_to_Listener(NRECEIVE);
	return;
    case DTRCLASS:
	ctmp->SetTraceClass();
	tout <<form("%02d",PAS_self_peno)<<
	    " Set Tr Class " << ctmp->Printname()<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	message_to_Listener(NRECEIVE);
	return;
    default:
	ctmp->SetUnTraceClass();
	tout <<form("%02d",PAS_self_peno)<<
	    " Reset Tr Class " << ctmp->Printname()<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	message_to_Listener(NRECEIVE);
	return;
    }
}
void debug_pid(u_char* aname,debugger_symbol com)
    // {}
    // ProtocolTableProtocolEntryΥǥХåӥåȤ
    // {}
{
    for(;*aname == ':';aname++)
	if (*aname  == '\0') {
	    error_message_to_Listener(UnKnownPid);
	    return;
	}
    int ind;
    if ((ind = Symbol2Pid_Entry_Index(aname))<0) {
	error_message_to_Listener(UnKnownPid);
	return;
    }
    tstream tout = tstream();
    ProtocolEntry* pe = ProtocolTable->get_ProtocolEntry((u_int)ind);
    switch (com) {
    case UBPPID:
	pe->UnSetBreakPoint();
	tout <<form("%02d",PAS_self_peno)<<" Reset Bpt Pid :" << (char*)aname<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case DBPPID:
	pe->SetBreakPoint();
	tout <<form("%02d",PAS_self_peno)<<" Set Bpt Pid :" << (char*)aname<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case DTRPID:
	pe->SetTracePoint();
	tout <<form("%02d",PAS_self_peno)<<" Set Tr Pid :" << (char*)aname<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    default:
	pe->UnSetTracePoint();
	tout <<form("%02d",PAS_self_peno)<<" Reset Tr Pid :" << (char*)aname<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    }
    message_to_Listener(NRECEIVE);
}

Object* object_symbol_2_address(u_char* str,Object* obj,u_char eof_char)
    // {}
    // 饹̾_0xɥ쥹 Υܥ뤫鳺륪֥Ȥ̵ͭǧ
    // ǧǤСΥɥ쥹֤ǤʤС(Object*)0 ֤
    // {}
{
    u_char obj_name[BUFSIZ];
    int op = 0;
    unsigned int addr = 0;
    Boolean under = FALSE;
    for(;;) {
	if (*str == '\0')
	    return (Object*)0;
	if ((*str == '_')&&(*(str+1) == '0')&&(*(str+2) == 'x')) {
	    str += 3;
	    under = TRUE;
	    break;
	}
	obj_name[op] = *str;
	str++;op++;
    }
    if (!under)
	return (Object*)0;
    obj_name[op] = '\0';
    while(*str != eof_char) {
	if ((*str>='0')&&(*str<='9'))
	    addr = (addr << 4)+(*str - '0');
	if ((*str>='a')&&(*str<='f'))
	    addr = (addr << 4)+(*str - 'a')+0x0a;
	if ((*str>='A')&&(*str<='F'))
	    addr = (addr << 4)+(*str - 'A')+0x0a;
	str++;
    }
    next_str_pointer = str;
    Object* objp = (Object*)addr;
    if (objp != obj) {
	ScheduleLink* object_queue = ScheduleTable.object_queue(0);
	if (object_queue->Search_object_queue(objp)) {
	    ClassTmpl* ctmp = objp->ClassTemplate();
	    if (!strcmp(ctmp->Printname(),(char*)obj_name))
		return objp;
	} else {
	    for (int regs = 0;regs < MAX_REG;regs++) {
		if (IsObject(Reg[regs])) {
		    Object* op = Object_ptr(Reg[regs]);
		    if (objp == op) {
			ClassTmpl* ctmp = objp->ClassTemplate();
			if (!strcmp(ctmp->Printname(),(char*)obj_name))
			    return objp;
		    }
		}
	    }
	    objp = (Object*)0;
	}
	objp = (Object*)0;
    }
    return objp;
}

void debug_object(u_char* objn,Object* obj,debugger_symbol c)
    // {}
    // ֥ȤΥ󥹥󥹼ȤΥǥХåӥåȤ򤹤롥
    // {}
{
    Object*  input_object;
    if ((input_object = object_symbol_2_address(objn,obj,'\0'))==(Object*)0) {
	error_message_to_Listener(UnKnownObject);
	return;
    }
    tstream tout = tstream();
    switch (c) {
    case UBPOBJECT:
	input_object->UnSetBreakObject();
	tout <<form("%02d",PAS_self_peno)<< " Reset Bpt Obj " <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case DTROBJECT:
	input_object->SetTraceObject();
	tout <<form("%02d",PAS_self_peno)<<" Set Tr Obj " <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case UTROBJECT:
	input_object->UnSetTraceObject();
	tout <<form("%02d",PAS_self_peno)<< " Reset Tr Obj " <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    default:
	input_object->SetBreakObject();
	tout <<form("%02d",PAS_self_peno)<< " Set Bpt Obj " <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    }
    message_to_Listener(NRECEIVE);
}

void debug_object_method(u_char* objn,Object* obj,debugger_symbol c)
    // {}
    // ֥ȤΥ󥹥󥹤Υ᥽åɤΥǥХåӥåȤ򤹤롥
    // {}
{
    Object*  input_object;
    if ((input_object = object_symbol_2_address(objn,obj,':'))==(Object*)0) {
	error_message_to_Listener(UnKnownObject);
	return;
    }
    ClassTmpl* ctmp = input_object->ClassTemplate();
    for(;*next_str_pointer ==' ';)
	next_str_pointer++;
    next_str_pointer++;
    for(int u = 1;;next_str_pointer++) {
	switch (*next_str_pointer) {
	case ' ': case '\t':
	    break;
	case '\0':
	    error_message_to_Listener(UnKnownMethod);
	    return;
	default:
	    u = 0;
	    break;
	}
	if (!u)break;
    }
    int me = ctmp->LookMethodIndex(next_str_pointer);
    if (me < 0) {
	error_message_to_Listener(UnKnownMethod);
	return;
    }
    tstream tout = tstream();
    switch (c) {
    case UBPOBJMETHOD:
	input_object->UnSetBreakObjectMethod(me);
	tout <<form("%02d",PAS_self_peno)<< " Reset Bpt Object Method "
	    <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case DTROBJMETHOD:
	input_object->SetTraceObjectMethod(me);
	tout <<form("%02d",PAS_self_peno)<< " Set Tr Object Method "
	    <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case UTROBJMETHOD:
	input_object->UnSetTraceObjectMethod(me);
	tout <<form("%02d",PAS_self_peno)<< " Reset Tr Object Method "
	    <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	return ;
    default:
	input_object->SetBreakObjectMethod(me);
	tout <<form("%02d",PAS_self_peno)<< " Set Bpt Object Method "
	    <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    }
    message_to_Listener(NRECEIVE);
}

void debug_object_slot(u_char* objn,Object* obj,debugger_symbol s)
    // {}
    // ֥ȤΥ󥹥󥹤ΥåȤΥǥХåӥåȤ򤹤롥
    // {}
{
    Boolean is_outlet = FALSE;
    for(u_char* wp = objn;((*wp != '\0')&&(*wp != '@')&&(*wp != '!'));wp++);
    if (*wp=='\0')
	return;
    if (*wp == '!')
	is_outlet =TRUE;
    char eof_char = (is_outlet) ? '!' : '@' ;
    Object*  input_object;
    if ((input_object = object_symbol_2_address(objn,obj,eof_char))==(Object*)0) {
	error_message_to_Listener(UnKnownObject);
	return;
    }
    for(;*next_str_pointer ==' ';)
	next_str_pointer++;
    next_str_pointer++;
    Boolean find = FALSE;
    ClassTmpl* ctmp = input_object->ClassTemplate();
    int search_l;
    if (is_outlet) {
	if ((search_l = outletslotindex(ctmp,next_str_pointer))>=0)
	    find = TRUE;
	search_l += ctmp->no_of_all_inlets();
    } else {
	if ((search_l = inletslotindex(ctmp,next_str_pointer))>=0)
	    find = TRUE;
    }
    if (!find) {
	error_message_to_Listener(UnKnownSlot);
	return;
    }
    tstream tout = tstream();
    switch (s) {
    case DBPOBJSLOT:
	input_object->SetBreakObjectSlot(search_l);
	tout <<form("%02d",PAS_self_peno)<< " Set Bpt Object Slot "
	    <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case UBPOBJSLOT:
	input_object->UnSetBreakObjectSlot(search_l);
	tout <<form("%02d",PAS_self_peno)<< " Reset Bpt Object Slot "
	    <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    case DTROBJSLOT:
	input_object->SetTraceObjectSlot(search_l);
	tout <<form("%02d",PAS_self_peno)<< " Set Tr Object Slot "
	    <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    default:
	input_object->UnSetTraceObjectSlot(search_l);
	tout <<form("%02d",PAS_self_peno)<< " Reset Tr Object Slot "
	    <<(char*)objn<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
	break;
    }
    message_to_Listener(NRECEIVE);
}

void assemble_file_load(u_char* textbuffp)
{
    u_char aname[BUFSIZ];
    u_char* wp;
    while (*textbuffp !='\0') {
	while (*textbuffp ==' ')
	    textbuffp++;
	if (*textbuffp=='\0')
	    break;
	wp = aname;
	for (;(*textbuffp != '\0')&&(*textbuffp !=' ');wp++,textbuffp++)
	    *wp= *textbuffp;
	*wp = '\0';
	if (aum_assembler((char*)aname)<0) {
	    message_to_Listener(TRECEIVE,(u_char*)"  unloaded !!\n");
	}
    }
    message_to_Listener(NRECEIVE);
}

void display_classes()
{
    for (register int location = 0; location < ClassTableSize; location++) {
	for (register ClassInfo* ht = ClassTable[location];ht;ht = ht->NextChain()) {
	    char tb[BUFSIZ];
	    sprintf(tb,"%s\n",(ht->ClassPrintname()));
	    message_to_Listener(TRECEIVE,(u_char*)(tb));
	    Supers* sp = ht->ClassTemplate()->Supers();
	    sp->DumpNames(4);
	}
    }
    message_to_Listener(NRECEIVE);
}

void describe_class(u_char* aname)
{
    ClassInfo* ci = Find_class_info((char*)aname);
    if (ci != (ClassInfo*)NULL) {
	ci->Dump();
	message_to_Listener(NRECEIVE);
    } else {
	error_message_to_Listener(UnKnownClass);
    }
}

void display_inherited_inlets(ClassTmpl* tmp,Supers* su)
    // {}
    // ƵŪ˷Ѿéʤ顤üå̾ȥǥХåӥåȤɽ롥
    // ǥХåӥåȤμΤϡtmpΥӥåȥ٥ˤ롥
    // {}
{
    int nos = su->no_of_supers();
    int sucount;
    for (sucount = 0;sucount < nos;sucount++) {
	const ClassTmpl* dtmp = su->Element(sucount)->ClassTemplate();
	int nfi = dtmp->no_of_inlets();
	int n;
	for (n = 0;n<nfi;n++,slotcount++) {
	    char tb[BUFSIZ];
	    char* slotname = (char*)(dtmp->InletSlotName(n));
	    bit[1] = (tmp->IsTraceSlot(slotcount)?'t':'-');
	    bit[2] = (tmp->IsBreakSlot(slotcount)?'b':'-');
	    sprintf(tb," %s @%s (#%s)\n",bit,slotname,dtmp->Printname());
	    message_to_Listener(TRECEIVE,(u_char*)tb);
	}
	display_inherited_inlets(tmp,dtmp->Supers());
    }
}
void display_inherited_outlets(ClassTmpl* tmp,Supers* su)
    // {}
    // ƵŪ˷Ѿéʤ顤üå̾ȥǥХåӥåȤɽ롥
    // ǥХåӥåȤμΤϡtmpΥӥåȥ٥ˤ롥
    // {}
{
    int nos = su->no_of_supers();
    int sucount;
    for (sucount = 0;sucount < nos;sucount++) {
	const ClassTmpl* dtmp = su->Element(sucount)->ClassTemplate();
	int nfo = dtmp->no_of_outlets();
	int n;
	for(n = 0;n<nfo;n++,slotcount++) {
	    char tb[BUFSIZ];
	    char* slotname = (char*)(dtmp->OutletSlotName(n));
	    bit[1] = (tmp->IsTraceSlot(slotcount)?'t':'-');
	    bit[2] = (tmp->IsBreakSlot(slotcount)?'b':'-');
	    sprintf(tb," %s !%s (#%s)\n",bit,slotname,dtmp->Printname());
	    message_to_Listener(TRECEIVE,(u_char*)tb);
	}
	display_inherited_outlets(tmp,dtmp->Supers());
    }
}

void display_inherited_method(ClassTmpl* tmp,Supers* su)
    // {}
    // ƵŪ˷Ѿéʤ顤᥽å̾ȥǥХåӥåȤɽ롥
    // ǥХåӥåȤμΤϡtmpΥӥåȥ٥ˤ롥
    // {}
{
    int ns = su->no_of_supers();
    for(int gg = 0;gg<ns;gg++) {
	const ClassTmpl* dtmp = su->Element(gg)->ClassTemplate();
	const char* super = dtmp->Printname();
	class MethodDict* mdp = dtmp->MethodDict();
	int no_of_methods = mdp->no_of_methods();
	for (int pp = 0;pp < no_of_methods;pp++,methodcount++) {
	    char tb[BUFSIZ];
	    MethodDictElement* me = mdp->entry(pp);
	    ProtocolID pid = me->PID();
	    bit[1] = (tmp->IsTraceMethod(methodcount)?'t':'-');
	    bit[2] = (tmp->IsBreakMethod(methodcount)?'b':'-');
	    sprintf(tb," %s :%s (#%s)\n",bit,PidPrintname(pid),super);
	    message_to_Listener(TRECEIVE,(u_char*)tb);
	}
	display_inherited_method(tmp,dtmp->Supers());
    }
}

void display_class_status(u_char* class_name,DisplayState option = All)
    // {}
    // class_nameǼ륯饹ΥǥХåե饰ξ֤ɽ롥option 
    // SlotꤹȤΥ饹Υå̾ȡΥåȤΥǥХåե
    // ξ֤ɽ롥
    // {}
{
    ClassInfo* tif;
    if ((tif = class_symbol_2_info(class_name,'\0'))==(ClassInfo*)0) {
	error_message_to_Listener(UnKnownClass);
	return;
    }
    ClassTmpl* tmp = tif->ClassTemplate();
    Supers* su = tmp->Supers();
    int is = tmp->no_of_inlets(),as = tmp->no_of_outlets();
    int n;
    slotcount = 0;
    if (option == All) {
	tstream tout = tstream();
	char* t_flag = (char*)((tmp->IsTraceClass())?"trace on ":"trace off");
	char* b_flag = (char*)((tmp->IsBreakClass())?"break on ":"break off");
	tout << " Debug Mode "
	    <<(char*)class_name << "\n" << " "<<t_flag <<"\n"
		<<" "<< b_flag<<"\n";
	message_to_Listener(TRECEIVE,(u_char*)tout.Result());
	tout.Initialize();
    }
    if ((option == All)||(option == Slot)) {
	bit[0] = ' '; bit[3] = ' '; bit[4] = ' '; bit[5] = ' '; bit[6] = '\0';
	for(n = 0;n<is;n++,slotcount++) {
	    tstream tout = tstream();
	    char* slotname = (char*)tmp->InletSlotName(n);
	    bit[1] = (tmp->IsTraceSlot(slotcount)?'t':'-');
	    bit[2] = (tmp->IsBreakSlot(slotcount)?'b':'-');
	    tout <<bit<< " @"<<slotname<<"\n";
	    message_to_Listener(TRECEIVE,(u_char*)tout.Result());
	    tout.Initialize();
	}
	if (su)
	    display_inherited_inlets(tmp,su);
	slotcount = is;
	for(n = 0;n<as;n++,slotcount++) {
	    tstream tout = tstream();
	    char* slotname = (char*)(tmp->OutletSlotName(n));
	    bit[1] = (tmp->IsTraceSlot(slotcount)?'t':'-');
	    bit[2] = (tmp->IsBreakSlot(slotcount)?'b':'-');
	    tout <<bit<< " !"<<slotname<<"\n";
	    message_to_Listener(TRECEIVE,(u_char*)tout.Result());
	    tout.Initialize();
	}
	if (su)
	    display_inherited_outlets(tmp,su);
    }
    if ((option == All)||(option == Method)) {
	MethodDict* mdp = tmp->MethodDict();
	int no_of_methods = mdp->no_of_methods();
	bit[0] = ' ';bit[3] = ' ';bit[4] = '\0';
	if (no_of_methods) {
	    for (methodcount = 0;methodcount < no_of_methods;methodcount++) {
		char tb[BUFSIZ];
		MethodDictElement* me = mdp->entry(methodcount);
		ProtocolID pid = me->PID();
		bit[1] = (tmp->IsTraceMethod(methodcount)?'t':'-');
		bit[2] = (tmp->IsBreakMethod(methodcount)?'b':'-');
		sprintf(tb," %s :%s \n",bit,PidPrintname(pid));
		message_to_Listener(TRECEIVE,(u_char*)tb);
	    }
	}
	if(su)
	    display_inherited_method(tmp,su);
    }
    message_to_Listener(NRECEIVE);
}

void SendTraceMode(TraceMode t)
    // {}
    // ̿ȥ졼⡼ɤON,OFFλؼ˽ɥåecho
    // back֤
    // {}
{
    if (PAS_npe>1) {
	GlobalMessage* gmm = (GlobalMessage*)0;
	while (!(gmm = PAS_receive_in_nonblocking()));
	gmm->Argv(1,PAS_self_peno);
	gmm->Argv(2,t);
	PAS_send(DEBUGGER_PE,gmm);
    } else {
	if (t == TraceOn) {
	    pelog("Trace Mode On  PE# %d ",PAS_self_peno);
	} else {
	    pelog("Trace Mode Off PE# %d ",PAS_self_peno);
	}
    }
}

void decision_dump_register_numbers()
    // {}
    // DUMP_REGΥޥɤȤɽ٤쥸ϰϤꤹ롥
    // {}
{
    from = -1;
    to = -1;
    char* wp = (char*)textbuff;
    for (;*wp;wp++){
	if ((*wp != ' ')&&(*wp != '\n')&&(*wp != '\t'))break;
    }
    Boolean ft = FALSE,tt = FALSE;
    int from_w = 0;
    int to_w = 0;
    for (;*wp;wp++) {
	if ((*wp >= '0')&&(*wp <= '9')){
	    ft = TRUE;
	    from_w *= 10;
	    from_w += (*wp-'0');
	}
	if (*wp == ' ')break;
	if (*wp == '\n')break;
	if (*wp == '\t')break;
    }
    for (;*wp;wp++){
	if ((*wp != ' ')&&(*wp != '\n')&&(*wp != '\t'))break;
    }
    for (;*wp;wp++) {
	if ((*wp >= '0')&&(*wp <= '9')){
	    tt = TRUE;
	    to_w *= 10;
	    to_w += (*wp-'0');
	}
	if (*wp == ' ')break;
	if (*wp == '\n')break;
	if (*wp == '\t')break;
    }

    if (ft){
	if (tt){
	    if (from_w>to_w){
		from = to_w;
		to = from_w+1;
	    }else{
		to = to_w+1;
		from = from_w;
	    }
	}else{
	    from = from_w;
	    to = from_w+1;
	}
    }else{
	from = 0;
	to = MAX_REG;
    }
}

debugger_symbol control_input()
    // {}
    // PAS_npe2ʾǵưȡPASץ¦ΥޥɼԤ
    // PAS_npe1λˤϡޥľܸƤӥǥХå롼ؾ
    // ϤΤȤPAS̿ϩϻѤʤޤΥ롼Ǥϡ
    // ޥɤ¨¹Ԥ٤ԤäƤ롥
    // {}
{
    debugger_symbol com;
    MessageLink* next;
    GlobalMessage* gm  = (GlobalMessage*)0;
    for(int pp = 0;pp< BUFSIZ;pp++)
	textbuff[pp] = '\0';
    if (PAS_npe > 1) {
	for (;;) {
	    if (gm) {
		if ((gm->Tag()) == Msg_Debugger) {
		    break;
		}
		next = gm->nextMessage(),gm->nextMessage(NULL);
		execute_sys_message(gm);
		gm = (GlobalMessage*)next;
	    } else {
		if (!(gm = PAS_receive_in_nonblocking())) {
		    gm = PAS_receive();
		}
	    }
	}
	receive_messages++;
	com = (debugger_symbol)gm->Argv(0);
	if ((com == STEP)||(com == CONTINUE)||(com == QUIT)||(com == NEXTSTEP)
	    ||(com == STEPINST)) {
	    next = gm->nextMessage(),gm->nextMessage(NULL);
	    gm->Free();
	    for (gm = (GlobalMessage*)next;gm;gm = (GlobalMessage*)next) {
		next = gm->nextMessage(),gm->nextMessage(NULL);
		execute_sys_message(gm);
	    }
	    message_to_Listener(DEFAULT);
	    return com;
	}
	int packets = (unsigned int)gm->Argv(1);
	u_char* wp = textbuff;
	if (packets >= 1) {
	    for (int pp = 3;pp<32;pp++,wp++) {
		unsigned int ui = gm->Argv(pp);
		if (!ui) break;
		if (IsEUC((ui>>8)&0xff)) {
		    *wp = (ui>>8)&0xff;
		    *(wp+1) = ui &0xff;
		    wp++;
		} else {
		    *(wp) = ui &0xff;
		}
	    }
	    if (pp < 32) {
		message_to_Listener(DEFAULT);
		next = gm->nextMessage(),gm->nextMessage(NULL);
		gm->Free();
		gm = (GlobalMessage*)next;
		receive_messages--;
	    } else {
		message_to_Listener(DEFAULT);
		next = gm->nextMessage(),gm->nextMessage(NULL);
		gm->Free();
		gm = (GlobalMessage*)next;
		receive_messages--;
		packets--;
		for (;packets>0;) {
		    if (!gm) {
			if (!(gm = PAS_receive_in_nonblocking())) {
			    gm = PAS_receive();
			}
		    }
		    if (!gm)
			return DEFAULT;
		    if (gm->Tag() != Msg_Debugger) {
			next = gm->nextMessage(),gm->nextMessage(NULL);
			execute_sys_message(gm);
			gm = (GlobalMessage*)next;
			continue;
		    }
		    message_to_Listener(DEFAULT);
		    for (int pp = 3;pp<32;pp++,wp++) {
			unsigned int ui = gm->Argv(pp);
			if (!ui) break;
			if (IsEUC((ui>>8)&0xff)) {
			    *wp = (ui>>8)&0xff;
			    *(wp+1) = ui &0xff;
			    wp++;
			} else {
			    *(wp+1) = ui &0xff;
			}
		    }
		    next = gm->nextMessage(),gm->nextMessage(NULL);
		    gm->Free();
		    gm = (GlobalMessage*)next;
		}
	    }
	} else {
	    message_to_Listener(DEFAULT);
	    next = gm->nextMessage(),gm->nextMessage(NULL);
	    gm->Free();
	    gm = (GlobalMessage*)next;
	    receive_messages--;
	}
    } else {
	char tb[BUFSIZ];
	if (now_running) {
	    sprintf(tb,"%02d:%s",PAS_self_peno,PT_EXECUTE);
	} else {
	    sprintf(tb,"%02d:%s",PAS_self_peno,PT_NORMAL);
	}
	cout << tb;
	cout.flush();
	tb[0] = '\0';
	if (gets(tb) == (char*)0) return QUIT;
	com = command_parser(tb);
	if (next_p) strcpy((char*)textbuff,next_p);
    }
    switch (com) {
    case DUMP_REG:
	decision_dump_register_numbers();
	break;
    case TRACE_OFF:
	trace_switch = FALSE;
	SendTraceMode(TraceOff);
	break;
    case TRACE_ON:
	trace_switch = TRUE;
	SendTraceMode(TraceOn);
	break;
    case DBPCLASS:  case UBPCLASS:  case DTRCLASS: case UTRCLASS:
	debugg_class(textbuff,com);
	break;
    case DTRMETHOD: case UTRMETHOD: case DBPMETHOD: case UBPMETHOD:
	debugg_methods(textbuff,com);
	break;
    case DBPSLOT: case UBPSLOT: case DTRSLOT: case UTRSLOT:
	debugg_slots(textbuff,com);
	break;
    case CLASSINFO:
	display_class_status(textbuff);
	break;
    case METHOD_LIST:
	display_class_status(textbuff,Method);
	break;
    case SLOT_LIST:
	display_class_status(textbuff,Slot);
	break;
#ifndef config_symmetry_h
	//case ASSEMBLE:
	//assemble_file_load(textbuff);
	//break;
#endif
    case CLASSES:
	display_classes();
	break;
    case DESCRIBE:
	describe_class(textbuff);
	break;
    case UBPPID:    case DBPPID:    case DTRPID:    case UTRPID:
	debug_pid(textbuff,com);
	break;
    case DBPOBJSLOT: case UBPOBJSLOT: case DTROBJSLOT: case UTROBJSLOT:
    case DBPOBJMETHOD: case UBPOBJMETHOD: case DTROBJMETHOD: case UTROBJMETHOD:
    case OBJSTAT: case UBPOBJECT: case DTROBJECT: case UTROBJECT:
    case DBPOBJECT: case PRINT_SLOT:
    default:
	break;
    }
    if (PAS_npe > 1) {
	if (gm) {
	    while (gm) {
		next = gm->nextMessage(),gm->nextMessage(NULL);
		execute_sys_message(gm);
		gm = (GlobalMessage*)next;
	    }
	}
    }
    return com;
}

void set_debug_flags_object_slot(Object* io,ClassTmpl* tp,int sc)
{
    bit[0] = (tp->IsTraceSlot(sc)? 't':'-');
    bit[1] = (tp->IsBreakSlot(sc)? 'b':'-');
    bit[2] = (io->IsTraceObjectSlot(sc)? 't':'-');
    bit[3] = (io->IsBreakObjectSlot(sc)? 'b':'-');
}

void set_debug_flags_object_method(Object* io,ClassTmpl* tp,int mc)
{
    bit[1] = (tp->IsTraceMethod(mc)? 't':'-');
    bit[2] = (tp->IsBreakMethod(mc)? 'b':'-');
    bit[3] = (io->IsTraceObjectMethod(mc)? 't':'-');
    bit[4] = (io->IsBreakObjectMethod(mc)? 'b':'-');
}

void display_object_inlets_super(Object* input_object,Supers* su)
    // {}
    // ƵŪ˥֥ȤΥ󥹥νüåȤդưʲΤ
    // ɽ롥
    // ǥХåե饰 ex. "----" "tb--"....
    // flag ΰ̣ʺ
    //	  饹ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  饹ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    //	  󥹥󥹤ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  󥹥󥹤ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    // å̾
    // åȤ
    // {}
{
    ClassTmpl* tmp = input_object->ClassTemplate();
    int nos = su->no_of_supers();
    int sucount;
    for (sucount = 0;sucount < nos;sucount++) {
	const ClassTmpl* dtmp = su->Element(sucount)->ClassTemplate();
	int nfi = dtmp->no_of_inlets();
	const char* ctname = dtmp->Printname();
	int n;
	for(n = 0;n<nfi;n++,slotcount++) {
	    char tb[BUFSIZ];
	    bit[5] = '\0'; bit[4] = ' ';
	    set_debug_flags_object_slot(input_object,tmp,slotcount);
	    sprintf(tb,"  %s @%s : %s (#%s)\n",bit,(dtmp->InletSlotName(n)),
		    print(input_object->Slot(slotcount)),ctname);
	    message_to_Listener(TRECEIVE,(u_char*)tb);
	}
	display_object_inlets_super(input_object,dtmp->Supers());
    }
}

void display_object_outlets_super(Object* input_object,Supers* su)
    // {}
    // ƵŪ˥֥ȤΥ󥹥νüåȤդưʲΤ
    // ɽ롥
    // ǥХåե饰 ex. "----" "tb--"....
    // flag ΰ̣ʺ
    //	  饹ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  饹ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    //	  󥹥󥹤ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  󥹥󥹤ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    // å̾
    // åȤ
    // {}
{
    ClassTmpl* tmp = input_object->ClassTemplate();
    int nos = su->no_of_supers();
    int sucount;
    for (sucount = 0;sucount < nos;sucount++) {
	const ClassTmpl* dtmp = su->Element(sucount)->ClassTemplate();
	int nfo = dtmp->no_of_outlets();
	const char* ctname = dtmp->Printname();
	int n;
	for(n = 0;n<nfo;n++,slotcount++) {
	    char tb[BUFSIZ];
	    bit[5] = '\0'; bit[4] = ' ';
	    set_debug_flags_object_slot(input_object,tmp,slotcount);
	    sprintf(tb,"  %s !%s : %s (#%s)\n",bit,
		    (dtmp->OutletSlotName(n)),
		    print(input_object->Slot(slotcount)),ctname);
	    message_to_Listener(TRECEIVE,(u_char*)tb);
	}
	display_object_outlets_super(input_object,dtmp->Supers());
    }
}

void display_object_methods_super(Object* input_object,Supers* su)
    // {}
    // ƵŪ˥֥ȤΥ󥹥Υ᥽åɤդưʲΤΤɽ
    // 롥
    // ǥХåե饰 ex. "----" "tb--"....
    // flag ΰ̣ʺ
    //	  饹Υ᥽åɤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  饹Υ᥽åɤФ֥졼ݥȤOn = "b",Off = "-"
    //	  󥹥󥹤Υ᥽åɤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  󥹥󥹤Υ᥽åɤФ֥졼ݥȤOn = "b",Off = "-"
    // ᥽å̾
    // {}
{
    ClassTmpl* tmp = input_object->ClassTemplate();
    int ns = su->no_of_supers();
    int sucount;
    for(sucount = 0;sucount<ns;sucount++) {
	const ClassTmpl* dtmp = su->Element(sucount)->ClassTemplate();
	class MethodDict* mdp = dtmp->MethodDict();
	const char* ctname = dtmp->Printname();
	int no_of_methods = mdp->no_of_methods();
	for (int pp = 0;pp < no_of_methods;pp++,methodcount++) {
	    char tb[BUFSIZ];
	    MethodDictElement* me = mdp->entry(pp);
	    ProtocolID pid = me->PID();
	    bit[0] = ' '; bit[5] = '\0';
	    set_debug_flags_object_method(input_object,tmp,methodcount);
	    sprintf(tb," %s :%s (#%s)\n",bit,PidPrintname(pid),ctname);
	    message_to_Listener(TRECEIVE,(u_char*)tb);
	}
	display_object_methods_super(input_object,dtmp->Supers());
    }
}

void display_object_status(u_char* objn,Object* obj)
    // {}
    // ֥ȤΥ󥹥󥹤դưʲΤΤɽ롥
    // ǥХåե饰 ex. "----" "tb--"....
    // flag ΰ̣ʺ
    //	  饹ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  饹ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    //	  󥹥󥹤ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  󥹥󥹤ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    // ֥̾
    // å̾üüˤȤ
    // ᥽å̾
    // {}
{
    Object* input_object = obj;
    if (!strcmp((const char*)objn,"active")) {
    }else if ((input_object = object_symbol_2_address(objn,obj,'\0'))==(Object*)0) {
	error_message_to_Listener(UnKnownObject);
	return;
    }
    ClassTmpl* tmp = input_object->ClassTemplate();
    int is = tmp->no_of_inlets();
    int as = tmp->no_of_outlets();
    int n;
    char tb[BUFSIZ];
    bit[4] = '\0';
    bit[0] = (tmp->IsTraceClass()) ? 't':'-';
    bit[1] = (tmp->IsBreakClass()) ? 'b':'-';
    bit[2] = (input_object->IsTraceObject()) ? 't':'-';
    bit[3] = (input_object->IsBreakObject()) ? 'b':'-';
    sprintf(tb,"  %s Object : %s \n",bit,input_object->Print());
    message_to_Listener(TRECEIVE,(u_char*)tb);
    slotcount = 0;
    for(n = 0;n<is;n++,slotcount++) {
	bit[5] = '\0';	bit[4] = ' ';
	set_debug_flags_object_slot(input_object,tmp,slotcount);
	sprintf(tb,"  %s @%s : %s\n",bit,
		(tmp->InletSlotName(n)),print(input_object->Slot(n)));
	message_to_Listener(TRECEIVE,(u_char*)tb);
    }
    Supers* su = tmp->Supers();
    if (su)
	display_object_inlets_super(input_object,su);
    for(n = 0;n<as;n++,slotcount++) {
	bit[5] = '\0'; bit[4] = ' ';
	set_debug_flags_object_slot(input_object,tmp,slotcount);
	sprintf(tb,"  %s !%s : %s \n",bit,
		(tmp->OutletSlotName(n)),print(input_object->Slot(slotcount)));
	message_to_Listener(TRECEIVE,(u_char*)tb);
    }
    if (su)
	display_object_outlets_super(input_object,su);
#ifndef OBJECT_DEBUG
    return ;
#endif
    MethodDict* mdp = tmp->MethodDict();
    int no_of_methods = mdp->no_of_methods();
    if (no_of_methods) {
	for (methodcount = 0;methodcount < no_of_methods;methodcount++) {
	    MethodDictElement* me = mdp->entry(methodcount);
	    ProtocolID pid = me->PID();
	    bit[0] = ' '; bit[5] = '\0';
	    set_debug_flags_object_method(input_object,tmp,methodcount);
	    sprintf(tb," %s :%s\n",bit,PidPrintname(pid));
	    message_to_Listener(TRECEIVE,(u_char*)tb);
	}
    }
    if(su)
	display_object_methods_super(input_object,su);
}

Boolean display_object_inlets(Object* obj,char ioro,char*slname,Supers* su)
    // {}
    // 󥹥objüåȤƵŪõslname˹פ륹
    // ̾ǡioro'@'ʤСʲɽԤ
    // ǥХåե饰 ex. "----" "tb--"....
    // flag ΰ̣ʺ
    //	  饹ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  饹ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    //	  󥹥󥹤ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  󥹥󥹤ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    // å̾
    // åȤ
    // {}
{
    ClassTmpl* tmp = obj->ClassTemplate();
    int nos = su->no_of_supers();
    int sucount;
    for (sucount = 0;sucount < nos;sucount++) {
	const ClassTmpl* dtmp = su->Element(sucount)->ClassTemplate();
	const char* cname = dtmp->Printname();
	int nfi = dtmp->no_of_inlets();
	int n;
	for(n = 0;n<nfi;n++,slotcount++) {
	    bit[5] = '\0'; bit[4] = ' ';
	    set_debug_flags_object_slot(obj,tmp,slotcount);
	    const char* sltname = dtmp->InletSlotName(n);
	    if ((ioro == '@')&&(!strcmp(sltname,slname))) {
		char tb[BUFSIZ];
		sprintf(tb,"%s @%s : %s (#%s)\n",bit,
			sltname,print(obj->Slot(n)),cname);
		message_to_Listener(TRECEIVE,(u_char*)tb);
		return TRUE;
	    }
	}
	if (display_object_inlets(obj,ioro,slname,dtmp->Supers()))
	    return TRUE;
    }
    return FALSE;
}

Boolean display_object_outlets(Object* obj,char ioro,char* slname,Supers* su)
    // {}
    // 󥹥objüåȤƵŪõslname˹פ륹
    // ̾ǡioro'@'ʤСʲɽԤ
    // ǥХåե饰 ex. "----" "tb--"....
    // flag ΰ̣ʺ
    //	  饹ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  饹ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    //	  󥹥󥹤ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  󥹥󥹤ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    // å̾
    // åȤ
    // {}
{
    ClassTmpl* tmp = obj->ClassTemplate();
    int nos = su->no_of_supers();
    int sucount;

    for (sucount = 0;sucount < nos;sucount++) {
	const ClassTmpl* dtmp = su->Element(sucount)->ClassTemplate();
	const char* cname = dtmp->Printname();
	int nfo = dtmp->no_of_outlets();
	int n;
	for(n = 0;n<nfo;n++,slotcount++) {
	    bit[4] = ' '; bit[5] = '\0';
	    const char* sltname = dtmp->OutletSlotName(n);
	    set_debug_flags_object_slot(obj,tmp,slotcount);
	    if ((ioro == '!')&&(!strcmp(sltname,slname))) {
		char tb[BUFSIZ];
		sprintf(tb,"%s !%s : %s (#%s)\n",bit,sltname,
			print(obj->Slot(slotcount)),cname);
		message_to_Listener(TRECEIVE,(u_char*)tb);
		return TRUE;
	    }
	}
	if (display_object_outlets(obj,ioro,slname,dtmp->Supers()))
	    return TRUE;
    }
    return FALSE;
}

void display_object_slot(Object* obj,char ioro,char* slname)
    // {}
    // 󥹥objΥåõslname˹פ륹å̾ǡ
    // ioroåȤΥ⡼ɤȹפΤʤСʲɽԤ
    // ǥХåե饰 ex. "----" "tb--"....
    // flag ΰ̣ʺ
    //	  饹ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  饹ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    //	  󥹥󥹤ΥåȤФȥ졼⡼ɤOn = "t",Off = "-"
    //	  󥹥󥹤ΥåȤФ֥졼ݥȤOn = "b",Off = "-"
    // å̾
    // åȤ
    // {}
{
    ClassTmpl* tmp = obj->ClassTemplate();
    const char* cname = tmp->Printname();
    int is = tmp->no_of_inlets();
    int as = tmp->no_of_outlets();
    int n;
    for(n = 0;n<is;n++,slotcount++) {
	bit[5] = '\0';	bit[4] = ' ';
	set_debug_flags_object_slot(obj,tmp,slotcount);
	const char* sltname = tmp->InletSlotName(n);
	if ((ioro == '@')&&(!strcmp(sltname,slname))) {
	    char tb[BUFSIZ];
	    sprintf(tb,"%s @%s : %s (#%s)\n",bit,sltname,
		    print(obj->Slot(n)),cname);
	    message_to_Listener(TRECEIVE,(u_char*)tb);
	    return;
	}
    }
    Supers* su = tmp->Supers();
    if (su) {
	if (display_object_inlets(obj, ioro,slname,su))
	    return;
    }
    for(n = 0;n<as;n++,slotcount++) {
	bit[5] = '\0';
	bit[4] = ' ';
	const char* sltname = tmp->OutletSlotName(n);
	set_debug_flags_object_slot(obj,tmp,slotcount);
	if ((ioro == '!')&&(!strcmp(sltname,slname))) {
	    char tb[BUFSIZ];
	    sprintf(tb,"%s !%s : %s (#%s)\n",bit,sltname,
		    print(obj->Slot(slotcount)),cname);
	    message_to_Listener(TRECEIVE,(u_char*)tb);
	    return;
	}
    }
    if (su) {
	if (display_object_outlets(obj, ioro,slname,su))
	    return;
    }
    error_message_to_Listener(UnKnownSlot);
}

void CommandShell()
    // {}
    // runˤϤεưԤޤǡǥХåΥޥɤμդԤ
    // ɤˡϡPAS_npe1λϡɸϤϤβϷ̤
    // ľ㤤PAS_npe2ʾǤϡPAS̿ϩ顤åη
    // Ƥ륳ޥɤ롥ޥɤˤϡϤ
    // ФǥХåԤ
    // {}
{
    now_running = FALSE;
    trace_switch = FALSE;
    step = FALSE;
    next_step = FALSE;
    if (PAS_npe > 1) {
	GlobalMessage* gm  = (GlobalMessage*)0;
	if (PAS_self_peno == 0) {
	    for (int o = 0;o < 2;o++) {
	    loop:
		if (gm != (GlobalMessage*)0) {
		    MessageLink* next;
		    next = gm->nextMessage(),gm->nextMessage(NULL);
		    gm->Free();
		    gm = (GlobalMessage*)next;
		} else {
		    if (!(gm = PAS_receive_in_nonblocking())) {
			gm = PAS_receive();
		    }
		    goto loop;
		}
	    }
	}
    }

    for(;;) {
	db_cont = control_input();
	if (online(db_cont)) continue;
	switch (db_cont) {
	case QUIT:
	    return;
	case RUN:
	    break_method = FALSE;
	    now_running = TRUE;
	    if (PAS_npe == 1)
		display_filenames();
	    doInterpreter();
	    return;
	case DBPOBJECT: case UBPOBJECT: case DTROBJECT: case UTROBJECT:
	case DBPOBJMETHOD: case UBPOBJMETHOD: case DTROBJMETHOD:
	case UTROBJMETHOD: case DBPOBJSLOT: case UBPOBJSLOT: case DTROBJSLOT:
	case UTROBJSLOT: case STEP: case CONTINUE: case OBJSTAT: case OBJWAIT:
	case PRINT_SLOT: case OBJACT: case NEXTSTEP: case STEPINST:
	case DUMP_REG: case INFO_CURRENT:
	    pelog("Only Executing mode command");
	    break;
	case TRACE_ON: case TRACE_OFF: case METHOD_LIST: case UBPPID:
	case DBPPID: case UBPCLASS: case DTRPID: case DBPCLASS: case DTRCLASS:
	case UTRPID: case DESCRIBE: case DBPSLOT: case UTRCLASS: case ASSEMBLE:
	case DBPMETHOD: case DTRMETHOD: case UBPMETHOD: case UTRMETHOD:
	case UBPSLOT: case DTRSLOT: case UTRSLOT: case CLASSINFO: case CLASSES:
	case SLOT_LIST:
	    break;
	case DUMP_PID:
	    DumpProtocolIDTable();
	    break;
	case DUMP_CLASS:
	    DumpClassTable();
	    break;
	default:
	    pelog(ErrM_UNDEFINED);
	    break;
	}
    }
}

void disp_active(Object* obj)
    // {}
    // ߤPEǼ¹Υ󥹥󥹤Υܥʥåޤˤɽ
    // 롥
    // {}
{
    if (!obj) return;
    message_to_Listener(TRECEIVE,(u_char*)"*** active object ***\n");
    if (obj->oTag() != ERROR) {
	char tb[BUFSIZ];
	sprintf(tb,"%s\n",obj->Printname());
	message_to_Listener(TRECEIVE,(u_char*)tb);
    } else {
	message_to_Listener(TRECEIVE,(u_char*)"\n");
    }
}

void disp_waiting(Object* obj)
    // {}
    // ߤPEǼ¹Ԥ֤ˤ륤󥹥󥹤Υܥʥåޤ
    // ɽ롥
    // {}
{
    message_to_Listener(TRECEIVE,(u_char*)"*** waiting object ***\n");
    ScheduleTable.Dump_wait_object();
}

void dump_registers()
    // {}
    // ̿ᥢ֥ǰ쥸ƤɽԤʤɽԤ
    // Τϡ桼ץμ¹Ԥ֥졼ݥȤãǤ롥
    // {}
{
    char tb[BUFSIZ];
    int cline = 0;
    for (int regs = from;regs < to;regs++,cline++) {
	Word register_value = Reg[regs];
	sprintf(tb," Reg[ %d ] ",regs);
	message_to_Listener(TRECEIVE,(u_char*)tb);
	if (IsErrorObject(register_value)) {
	    sprintf(tb," *ErrorObject*\n");
	}else{
	    sprintf(tb," %s\n",print(register_value));
	}
	message_to_Listener(TRECEIVE,(u_char*)tb);
	if (cline > 24){
	    if (PAS_npe == 1){
		cout << "--- type <return> key ---";
		cout.flush();
		getchar();
		cline = 0;
	    }
	}
    }
}


void is_enter_break_loop(Object* object,Message* cmp)
    // cmp    : interpreterǼ¹Ԥ褦ȤƤå
    // object : interpreterscheduleоݤˤʤäƤ륪֥
    // {}
    // interpreterǡBreakLoop뤫ݤԤʤ
    // ⤷BreakLoop٤ˤϡåϤ롥
    // BreakLoopʤǤtraceե饰ꤵƤС
    // åϤ롥
    // {}
{
    int	    meth_index = 0;
    char    prb[BUFSIZ];
    ProtocolID pi = cmp->PID ();
    ProtocolEntry *pe = SearchProtocolID (pi);
    Boolean trace_pe = FALSE;
    Boolean break_pe = FALSE;
    if (pe) {
	strcpy (prb, (PidPrintname (pi)));
	if ((meth_index = object->ClassTemplate ()->LookMethodIndex ((unsigned char *) prb)) < 0) {
	    if ((meth_index = object->ClassTemplate ()->LookMethodIndex ((unsigned char *) "DEFAULT")) >= 0) {
	    }
	}
	trace_pe = (pe->IsTracePoint ()) ? TRUE : FALSE;
	break_pe = (pe->IsBreakPoint ()) ? TRUE : FALSE;
    }
    else {
	if (pi.Type () != PT_Compound) {
	    strcpy (prb, (PidPrintname (pi)));
	    if ((meth_index = object->ClassTemplate ()->LookMethodIndex ((unsigned char *) prb)) < 0) {
		if ((meth_index = object->ClassTemplate ()->LookMethodIndex ((unsigned char *) "DEFAULT")) >= 0) {
		}
	    }
	}
    }
    stop = step || ((meth_index >= 0) && object->IsBreakObjectMethod (meth_index)) ||
	((meth_index >= 0) && object->ClassTemplate ()->IsBreakMethod (meth_index)) ||
	    break_pe || (object->ClassTemplate ()->IsBreakClass ()) ||
		(object->IsBreakObject ());
    if (break_pe && !step) {
	char	teb[BUFSIZ];
	sprintf (teb, "%02d:Bpt %s protocol %s\n", PAS_self_peno,
		 object->Printname (), cmp->Print ());
	message_to_Listener (TRECEIVE, (unsigned char *) teb);
    }
    if ((meth_index >= 0) && object->ClassTemplate ()->IsBreakMethod (meth_index) && !step) {
	char	teb[BUFSIZ];
	sprintf (teb, "%02d:Bpt class %s method %s\n",
		 PAS_self_peno, object->ClassTemplate ()->Printname (), cmp->Print ());
	message_to_Listener (TRECEIVE, (unsigned char *) teb);
    }
    if ((meth_index >= 0) && object->IsBreakObjectMethod (meth_index) && !step) {
	char	teb[BUFSIZ];
	sprintf (teb, "%02d:Bpt object %s method %s\n", PAS_self_peno,
		 object->Printname (), cmp->Print ());
	message_to_Listener (TRECEIVE, (unsigned char *) teb);
    }
    if (object->ClassTemplate ()->IsBreakClass () && !step) {
	char	teb[BUFSIZ];
	sprintf (teb, "%02d:Bpt class %s\n", PAS_self_peno,
		 object->ClassTemplate ()->Printname ());
	message_to_Listener (TRECEIVE, (unsigned char *) teb);
    }
    if (object->IsBreakObject () && !step) {
	char	teb[BUFSIZ];
	sprintf (teb, "%02d:Bpt object %s\n",
		 PAS_self_peno, object->Printname ());
	message_to_Listener (TRECEIVE, (unsigned char *) teb);
    }
    if (step || stop || trace_switch || trace_pe ||
	(object->IsTraceObject ()) ||
	((meth_index >= 0) && object->IsTraceObjectMethod (meth_index)) ||
	(object->ClassTemplate ()->IsTraceClass ()) ||
	((meth_index >= 0) && object->ClassTemplate ()->IsTraceMethod (meth_index))) {
	char	teb[BUFSIZ];
	const char *object_name;
	if (IsUserObject (ObjectWord (object)))
	    object_name = object->Printname ();
	else
	    object_name = print (ObjectWord (object));
	sprintf (teb, "%02d:<Enter> %s:%s\n", PAS_self_peno,
		 object_name, cmp->Print ());
	message_to_Listener (TRECEIVE, (unsigned char *) teb);
    }
}

debugger_symbol BreakLoop(Boolean* trace,Object* obj)
    // {}
    // 桼ץμ¹Ԥ֥졼ݥȤޤãȤ˸ƤФ롼
    // ǤǥХåΥޥɤμդԤޥɤˡϡ
    // PAS_npe1λϡɸϤϤβϷ̤ľ㤤PAS_npe2
    // ǤϡPAS̿ϩ顤åηƤ륳ޥ
    // 롥ޥɤˤϡϤФǥХå
    // 
    // {}
{
    message_to_Listener(BREAK);
    for(;;) {
	debugger_symbol db_cont_in_execute;
	db_cont_in_execute = control_input();
	if (online(db_cont_in_execute)) continue;
	switch (db_cont_in_execute) {
	case TRACE_ON:	case TRACE_OFF:
	    break;
	case DBPOBJECT: case DTROBJECT: case UBPOBJECT: case UTROBJECT:
	    debug_object(textbuff,obj,db_cont_in_execute);
	    break;
	case DBPOBJSLOT: case UBPOBJSLOT: case DTROBJSLOT: case UTROBJSLOT:
	    debug_object_slot(textbuff,obj,db_cont_in_execute);
	    break;
	case DBPOBJMETHOD: case DTROBJMETHOD: case UBPOBJMETHOD:
	case UTROBJMETHOD:
	    debug_object_method(textbuff,obj,db_cont_in_execute);
	    break;
	case PRINT_SLOT:
	    for (char* work = (char*)textbuff;(*work != '!')&&(*work != '@');
		 work++);
	    Object* object = object_symbol_2_address(textbuff,obj,*work);
	    if (object)
		display_object_slot(object,*work,(work+1));
	    else
		error_message_to_Listener(UnKnownObject);
	    message_to_Listener(NRECEIVE);
	    break;
	case QUIT: case CONTINUE:  case STEP:  case NEXTSTEP:  case STEPINST:
	    return db_cont_in_execute;
	case OBJSTAT:
	    display_object_status(textbuff,obj);
	    message_to_Listener(NRECEIVE);
	    break;
	case OBJACT:
	    disp_active(obj);
	    message_to_Listener(NRECEIVE);
	    break;
	case OBJWAIT:
	    disp_waiting(obj);
	    message_to_Listener(NRECEIVE);
	    break;
	case DUMP_REG:
	    dump_registers();
	    message_to_Listener(NRECEIVE);
	    break;
	case INFO_CURRENT:
	    disasm_method();
	    message_to_Listener(NRECEIVE);
	    break;
	case DUMP_PID:
	    DumpProtocolIDTable();
	    break;
	case DUMP_CLASS:
	    DumpClassTable();
	    break;
	case DUMP_SCHEDULER:
	    DumpScheduleTable();
	    break;
	case UBPPID: case DBPPID: case DESCRIBE: case UBPCLASS: case DBPCLASS:
	case CLASSES: case UTRCLASS: case DTRCLASS: case UTRPID: case DTRPID:
	case DBPMETHOD: case DBPSLOT: case DTRMETHOD: case DTRSLOT:
	case UBPMETHOD: case UBPSLOT: case UTRMETHOD: case UTRSLOT:
	case DUMP_OBJECT: case CLASSINFO: case SLOT_LIST:
	case METHOD_LIST:
	    break;
	case DEFAULT:
	    if (PAS_npe == 1){
		pelog(ErrM_UNDEFINED);
	    }
	    break;
	default:
	    if (PAS_npe == 1)
		pelog(ErrM_UNDEFINED);
	    break;
	}
    }
}

/*************************************************************************
*  ʹߤΥ롼ϳƽϤ̿ǻѤ⥸塼Ǥ롥*
**************************************************************************/

void is_enter_break_loop_send(Word x,LocalMessage* mp)
{
    ClassTmpl* ctmpl = CurrentObject->ClassTemplate();
    stop = (step&&(!trace_switch));
    if (trace_switch||stop||(CurrentObject->IsTraceObject())||
	(ctmpl->IsTraceClass())) {
	if (IsObject(x)) {
	    Object* ro = Object_ptr(x);
	    tstream tout = tstream();
	    switch(ro->Type()){
	    case SUSPENDED: case SLEEPING: case CLOSED: case READY:
		tout.form("%02d:",PAS_self_peno);
		tout << print(x)<<":" <<mp->Print()<<"\n";
		message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
		tout.Initialize();
		break;
	    default:
		tout.form("%02d:",PAS_self_peno);
		tout << print(x) <<":" <<mp->Print()<<"\n";
		message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
		tout.Initialize();
		break;
	    }
	} else {
	    tstream tout = tstream();
	    tout.form("%02d:",PAS_self_peno);
	    tout << print(x) << ":" <<mp->Print() << "\n";
	    message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	    tout.Initialize();
	}
    }
}

void is_enter_break_loop_connect(Word x,Word y)
{
    ClassTmpl* ctmpl = CurrentObject->ClassTemplate();
    stop = (step&&(!trace_switch))||CurrentObject->IsBreakObject()||
	ctmpl->IsBreakClass();
    if (trace_switch||stop||CurrentObject->IsTraceObject()||
	ctmpl->IsTraceClass()){
	tstream	 tout = tstream();
	tout.form("%02d:<Connect> ",PAS_self_peno);
	tout << print(x)<<" = ^"<<print(y)<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
    }
}

void is_enter_break_loop_getoutlet(Word x,int index,short lab)
{
    stop = (step && (!trace_switch)) ||
	((CurrentObject->IsBreakObjectSlot(index))||
	 (CurrentObject->ClassTemplate()->IsBreakSlot(index)));
    if (stop && !step) {
	tstream tout = tstream();
	tout.form("%02d:Bpt slot ",PAS_self_peno);
	tout << CurrentObject->Printname() << "!"
	    <<(CurrentClass->OutletSlotName(lab)) <<"\n";
	message_to_Listener (TRECEIVE, (unsigned char *)tout.Result());
	tout.Initialize();
    }
    const char* printobjx = print(x);
    if (trace_switch || stop || (CurrentObject->IsTraceObject())||
	(CurrentObject->ClassTemplate()->IsTraceClass()) ||
	(CurrentObject->IsTraceObjectSlot(index))||
	(CurrentObject->ClassTemplate()->IsTraceSlot(index))) {
	tstream tout = tstream();
	if (!stop) {
	    tout.form("%02d:<Gets> ",PAS_self_peno);
	    tout << CurrentObject->Printname()<<" !"
		<< (CurrentClass->OutletSlotName (lab))
		    << " =>" << printobjx <<"\n";
	} else {
	    tout.form("%02d:<Gets> !",PAS_self_peno);
	    tout << (CurrentClass->OutletSlotName (lab))
		<< " =>" << printobjx <<"\n";
	}
	message_to_Listener (TRECEIVE, (unsigned char *)tout.Result());
	tout.Initialize();
    }
}
void is_enter_break_loop_setoutlet(Word x,int index,short lab)
{
    stop = (step && (!trace_switch)) ||
	((CurrentObject->IsBreakObjectSlot(index))||
	 (CurrentObject->ClassTemplate()->IsBreakSlot(index)));
    if (stop && !step) {
	tstream tout = tstream();
	tout << form("%02d:Bpt slot ",PAS_self_peno);
	tout << CurrentObject->Printname() << "!"
	    << CurrentClass->OutletSlotName(lab) << "\n";
	message_to_Listener (TRECEIVE, (unsigned char *)tout.Result());
	tout.Initialize();
    }
    if (trace_switch || stop || (CurrentObject->IsTraceObject())||
	(CurrentObject->ClassTemplate()->IsTraceClass()) ||
	(CurrentObject->IsTraceObjectSlot(index))||
	(CurrentObject->ClassTemplate()->IsTraceSlot(index))) {
	tstream tout = tstream();
	if (!stop) {
	    tout.form("%02d:<Sets> ",PAS_self_peno);
	    tout << print(x) << " => " << CurrentObject->Printname() << "!"
		<< (CurrentClass->OutletSlotName (lab)) << "\n";
	} else {
	    tout.form("%02d:<Sets> ",PAS_self_peno);
	    tout << print(x) << " => !" << (CurrentClass->OutletSlotName (lab))
		<< "\n";
	}
	message_to_Listener (TRECEIVE, (unsigned char *)tout.Result());
	tout.Initialize();
    }
}

void is_enter_break_loop_setinlet(Word x ,int index,short lab)
{
    stop = (step&&(!trace_switch))||
	((CurrentObject->IsBreakObjectSlot(index))||
	 (CurrentObject->ClassTemplate()->IsBreakSlot(index)));
    if (stop && !step){
	tstream tout = tstream();
	tout.form("%02d:Bpt slot ",PAS_self_peno);
	tout << CurrentObject->Printname() << "@"
	    << CurrentClass->InletSlotName(lab)<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
    }
    if (trace_switch||stop||(CurrentObject->IsTraceObject())||
	(CurrentObject->ClassTemplate()->IsTraceClass())||
	(CurrentObject->IsTraceObjectSlot(index))||
	(CurrentObject->ClassTemplate()->IsTraceSlot(index))){
	tstream tout = tstream();
	if (!stop) {
	    tout.form("%02d:<Sets> ",PAS_self_peno);
	    tout <<print(x) <<" => " << CurrentObject->Printname() << "@"
		    <<(CurrentClass->InletSlotName(lab))<<"\n";
	}else{
	    tout.form("%02d:<Sets> ",PAS_self_peno);
	    tout <<print(x)<<" => @"<<(CurrentClass->InletSlotName(lab))<<"\n";
	}
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
    }
}

void is_enter_break_loop_getinlet(Word x,int index,short lab)
{
    stop = (step&&(!trace_switch))||
	((CurrentObject->IsBreakObjectSlot(index))||
	 (CurrentObject->ClassTemplate()->IsBreakSlot(index)));
    if (stop && !step){
	tstream tout = tstream();
	tout.form("%02d:Bpt slot ",PAS_self_peno);
	tout << CurrentObject->Printname() << "@"
	    << CurrentClass->InletSlotName(lab)<<"\n";
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
    }
    const char* printobjx = print(x);
    if (stop||(CurrentObject->IsTraceObject())||
	(CurrentObject->ClassTemplate()->IsTraceClass())||
	(CurrentObject->IsTraceObjectSlot(index))||
	(CurrentObject->ClassTemplate()->IsTraceSlot(index))){
	tstream tout = tstream();
	if (!stop) {
	    tout.form("%02d:<Gets> ",PAS_self_peno);
	    tout << CurrentObject->Printname() << "@"
		<<(CurrentClass->InletSlotName(lab))
		    <<" => "<< printobjx <<"\n";
	}else{
	    tout.form("%02d:<Gets> ",PAS_self_peno);
	    tout << "@" <<(CurrentClass->InletSlotName(lab))
		    <<" => "<< printobjx <<"\n";
	}
	message_to_Listener(TRECEIVE,(unsigned char*)tout.Result());
	tout.Initialize();
    }
}

void is_enter_break_loop_close(Object* object)
    // object : interpreterscheduleоݤˤʤäƤ륪֥
    // {}
    // closeåμ¹Ԥˤơ
    // interpreterǡBreakLoop뤫ݤԤʤ
    // ⤷BreakLoop٤ˤϡåϤ롥
    // BreakLoopʤǤtraceե饰ꤵƤС
    // åϤ롥
    // {}
{
    int	    meth_index = 0;
    if ((meth_index = object->ClassTemplate ()->LookMethodIndex ((unsigned char *) "::")) >= 0) {
	stop = step || ((meth_index >= 0) && object->IsBreakObjectMethod (meth_index)) ||
	    ((meth_index >= 0) && object->ClassTemplate ()->IsBreakMethod (meth_index)) ||
		(object->ClassTemplate ()->IsBreakClass ()) ||
		    (object->IsBreakObject ());
	if ((meth_index >= 0) && object->ClassTemplate ()->IsBreakMethod (meth_index) && !step) {
	    char    teb[BUFSIZ];
	    sprintf (teb, "%02d:Bpt class %s method ::\n",
		     PAS_self_peno, object->ClassTemplate ()->Printname ());
	    message_to_Listener (TRECEIVE, (unsigned char *) teb);
	}
	if ((meth_index >= 0) && object->IsBreakObjectMethod (meth_index) && !step) {
	    char    teb[BUFSIZ];
	    sprintf (teb, "%02d:Bpt object %s method ::\n", PAS_self_peno,
		     object->Printname ());
	    message_to_Listener (TRECEIVE, (unsigned char *) teb);
	}
	if (object->ClassTemplate ()->IsBreakClass () && !step) {
	    char    teb[BUFSIZ];
	    sprintf (teb, "%02d:Bpt class %s\n", PAS_self_peno,
		     object->ClassTemplate ()->Printname ());
	    message_to_Listener (TRECEIVE, (unsigned char *) teb);
	}
	if (object->IsBreakObject () && !step) {
	    char    teb[BUFSIZ];
	    sprintf (teb, "%02d:Bpt object %s\n",
		     PAS_self_peno, object->Printname ());
	    message_to_Listener (TRECEIVE, (unsigned char *) teb);
	}
	if (step || stop || trace_switch ||
	    (object->IsTraceObject ()) ||
	    ((meth_index >= 0) && object->IsTraceObjectMethod (meth_index)) ||
	    (object->ClassTemplate ()->IsTraceClass ()) ||
	    ((meth_index >= 0) && object->ClassTemplate ()->IsTraceMethod (meth_index))) {
	    char    teb[BUFSIZ];
	    const char *object_name;
	    if (IsUserObject (ObjectWord (object)))
		object_name = object->Printname ();
	    else
		object_name = print (ObjectWord (object));
	    sprintf (teb, "%02d:<Enter> %s::\n", PAS_self_peno,
		     object_name);
	    message_to_Listener (TRECEIVE, (unsigned char *) teb);
	}
    }
}

#endif /*PAS_DEBUGGER*/
/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */


