/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stream.h>
#include "aum/debugger.h"
#include "command.h"

extern Command command_table[];
extern int comtsize;
extern "C" {
  int strcmp(const char*,const char*);
  int strlen(const char*);
};

char* next_p;
char* current_p;
char* strstr(const char* str1,const char* str2)
{
    char* wp = (char*)0;
    while((*str1 != '\0')&&(*str2 != '\0')){
	if (*str1 == *str2){
	    wp = (char*)str1;
	    break;
	}
	if (*str1 != ' ')
	    return NULL;
	str1++;
    }
    if (*str1 == '\0')
	return NULL;
    while((*str1 != '\0')&&(*str2 != '\0')){
	if (*str1 != *str2){
	    return NULL;
	}
	str1++;
	str2++;
    }
    if (*str2 == '\0')
	return wp;
    return NULL;
}

Boolean IsNumber();
Boolean IsObjectName();
Boolean IsClassName();
Boolean IsSlotName();
Boolean IsMethodName();

//#define COM_DEB

debugger_symbol command_parser(char* command)
{
  if (!strcmp(command,""))
    return DEFAULT;
    for (int com = 0;com < comtsize;com++){
      next_p = command;
      int tk,max = (command_table[com].no_of_token);
      Boolean match = TRUE;
      for (tk = 0;tk < max;tk++){
	current_p = next_p;
	if (!strcmp(command_table[com].token[tk],"number")){
	  if (IsNumber()){
#ifdef COM_DEB
	    pelog (" command table id %x ",command_table[com].id);
#endif
	    return command_table[com].id;
	  }
	  match = FALSE;
	  break;
	}else if (!strcmp(command_table[com].token[tk],"objmethodname")){
	  if ((IsObjectName())&&(IsMethodName())){
#ifdef COM_DEB
	    pelog (" command table id %x ",command_table[com].id);
#endif
	    return command_table[com].id;
	  }
	  match = FALSE;
	  break;
	}else if (!strcmp(command_table[com].token[tk],"objslotname")){
	  if ((IsObjectName())&&(IsSlotName())){
#ifdef COM_DEB
	    pelog (" command table id %x ",command_table[com].id);
#endif
	    return command_table[com].id;
	  }
	  match = FALSE;
	  break;
	}else if (!strcmp(command_table[com].token[tk],"objectname")){
	  if (IsObjectName()){
#ifdef COM_DEB
	    pelog (" command table id %x ",command_table[com].id);
#endif
	    return command_table[com].id;
	  }
	  match = FALSE;
	  break;
	}else if (!strcmp(command_table[com].token[tk],"methodname")){
	  if ((IsClassName())&&(IsMethodName())){
#ifdef COM_DEB
	    pelog (" command table id %x ",command_table[com].id);
#endif
	    return command_table[com].id;
	  }
	  match = FALSE;
	  break;
	}else if (!strcmp(command_table[com].token[tk],"slotname")){
	  if ((IsClassName())&&(IsSlotName())){
#ifdef COM_DEB
	    pelog (" command table id %x ",command_table[com].id);
#endif
	    return command_table[com].id;
	  }
	  match = FALSE;
	  break;
	}else if (!strcmp(command_table[com].token[tk],"pidsymbol")){
	  if (IsMethodName()){
#ifdef COM_DEB
	    pelog (" command table id %x ",command_table[com].id);
#endif
	    return command_table[com].id;
	  }
	  match = FALSE;
	  break;
	}else if (!strcmp(command_table[com].token[tk],"classname")){
	  if (IsClassName()){
#ifdef COM_DEB
	    pelog (" command table id %x ",command_table[com].id);
#endif
	    return command_table[com].id;
	  }
#ifdef COM_DEB
	  pelog (" classname not matched %d ",command_table[com].id);
#endif
	  match = FALSE;
	  break;
	}else if ((next_p = strstr(next_p,command_table[com].token[tk]))){
	  next_p += strlen(command_table[com].token[tk]);
	  while(*next_p ==' ')next_p++;
	}else{
	  match = FALSE;
	  break;
	}
      }
      if (match){
	if (tk == max){
#ifdef COM_DEB
	  pelog ("final	 command table id %x ",command_table[com].id);
#endif
	  return command_table[com].id;
	}
      }
    }
#ifdef COM_DEB
  pelog (" return default  ");
#endif
  return DEFAULT;
}

Boolean IsNumber()
{
  //cout "  // enter is number " << current_p << '\n';
  while((*current_p == ' ')&&(*current_p == '\t')&&(*current_p != '\0'))
    current_p++;
  if (*current_p == '\0') return FALSE;
  for (;*current_p;current_p++){
    if ((*current_p >= '0')&&(*current_p <='9'))
      continue;
      else{
	current_p--;
	break;
      }
  }
  return TRUE;
}

Boolean IsObjectName()
{
  //cout "  // enter is object " << current_p << '\n';
  while((*current_p == ' ')&&(*current_p == '\t')&&(*current_p != '\0'))
    current_p++;
  if (*current_p == '\0')
    return FALSE;
  for (;;current_p++) {
    if ((*current_p == ' ')||(*current_p == '\t')||(*current_p == '\0'))
      return FALSE;
    if ((*current_p == '_')&&(*(current_p+1) == '0')&&(*(current_p+2) == 'x')){
      current_p += 3;
      break;
    }
  }
  for (;;) {
    switch (*current_p) {
    case ':'  :	   case '!' :
    case '@'  :
      current_p--;
      return TRUE;
    case '\0' :	 case ' ':
      //*current_p = '\0';
      return TRUE;
    default:
      break;
    }
    current_p++;
  }
}

Boolean IsClassName()
{
  for(;;current_p++){
    if ((*current_p == ':')||(*current_p == '!')||(*current_p == '@'))
      return FALSE;
    if (*current_p == '\0')
      return FALSE;
    if ((*current_p != ' ')&&(*current_p != '\t')&&(*current_p != '\n'))
      break;
  }
  if (*current_p == '\0')
    return TRUE;
  for (;;) {
    switch (*current_p) {
    case ':' :
    case '!' :
    case '@' :
      current_p--;
      return TRUE;
    case '\0' :
    case ' '  :
      //*current_p = '\0';
      return TRUE;
    default:
      break;
    }
    current_p++;
  }
}

Boolean IsSlotName()
{
//  cout <<"  // enter is slot " << current_p << '\n';
  while(((*current_p == ' ')||(*current_p == '\t'))&&(*current_p != '\0'))
    current_p++;
  if (*current_p == '\0')
    return FALSE;
  for (;;) {
    if ((*current_p == ' ')||(*current_p == '\t')||(*current_p == '\0'))
      return FALSE;
    if ((*current_p == '!')||(*current_p == '@')){
      current_p++;
      break;
    }
    current_p++;
  }
  //cout <<"  // secound is slot " << current_p << '\n';
  for (;;) {
    if (*current_p == '\0'){
      return FALSE;
    }else{
      if ((*current_p == '\t')||(*current_p == ' '))
	continue;
      break;
    }
    current_p++;
  }
  for (;;) {
    if ((*current_p == ' ')||(*current_p == '\t')||(*current_p == '\0')){
      break;
    }
    current_p++;
  }
  return TRUE;
}

Boolean IsMethodName()
{
  //cout <<"   enter is method " << current_p << '\n';
  while(((*current_p == ' ')||(*current_p == '\t'))&&(*current_p != '\0'))
    current_p++;
  //cout <<"   first pass  \n";
  if (*current_p == '\0')
    return FALSE;
  for (;;) {
    if ((*current_p == ' ')||(*current_p == '\t')||(*current_p == '\0'))
      return FALSE;
    if ((*current_p == ':')){
      current_p++;
      break;
    }
    current_p++;
  }
  //cout <<"   second pass  \n";
  for (;;) {
    if ((*current_p == '/')||(*current_p == ' ')||
	(*current_p == '\t')||(*current_p == '\0'))
      break;
    current_p++;
  }
  if (*current_p != '/')
    return TRUE;
  current_p++;
  //cout << "third pass \n";
  for (;;) {
    if ((*current_p == ' ')||(*current_p == '\t')||(*current_p == '\0')){
      //cout << "final pass \n";
      return TRUE;
    }else{
      //cout << "false pass" << form(" %c",*current_p) << '\n';
      if ((*current_p != '+')&&(*current_p != '-'))
	return FALSE;
    }
    current_p++;
  }
  //cout << "final pass \n";
  return TRUE;
}



