/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef class_template_h
#define class_template_h

#include "config.h"
#include "aum/bool.h"
#include "aum/aumtype.h"
#include "aum/types.h"
#include "aum/rc.h"
#include "aum/objecttag.h"
#include "aum/header.h"
#include "table/protocol.h"
#include "aum/protocolid.h"
#include "aum/word.h"
#include "aum/message.h"
#include "aum/code.h"
#include "class/method.h"
#include "class/supers.h"
#include "class/codemodule.h"
#include "aum/alloc.h"

class SlotDict;
class MethodDict;
class ForeignDict;
class CodeModule;
class ClassTmpl;
class ForeignNameList;

class MethodInfoClass {
 private:
    const ClassTmpl * tmpl;
    u_long  method_index;
    u_short ibase;
    u_short obase;
 public:
    void    Initialize (const ClassTmpl *, int, u_short i, u_short);
    void    Add_iobase (u_short i, u_short o);
    const Instruction *Commit () const;
};

class ClassTmpl {
 private:
    int	    version;
    Word    name;
    Supers *supers;
    u_short ninlets;
    u_short noutlets;
    SlotDict *slot_dict;
    MethodDict *method_dict;
    ForeignDict *foreign_dict;
    CodeModule *code_module;

#ifdef	PAS_DEBUGGER
    u_int   debug_bits;
    u_int   no_of_all_methods;
    Word   *debug_bits_set;

#endif
    //
    void    SetVersion (long vno);

 public:
	    ClassTmpl (Word, u_short, u_short,
			       Supers *,
			       SlotDict *,
			       MethodDict *,
			       ForeignDict *,
			       CodeModule *);

    void   *operator new (size_t s);
    void   operator delete (void *);

    Boolean DefineOnly ();
    void    SetNofSlots (u_short i, u_short o);
    void    SetSupers (class Supers *);
    void    SetSlotDict (class SlotDict *);
    void    SetMethodDict (class MethodDict *);
    void    SetForeignDict (class ForeignDict *);
    void    SetCodeModule (class CodeModule *);
    //
    u_long  size_of_instance () const;
    u_short no_of_inlets () const;
    u_short no_of_all_inlets () const;
    u_short no_of_outlets () const;
    u_short no_of_all_outlets () const;
    u_long  no_of_slots () const;
    u_long  no_of_all_slots () const;

    Supers *Supers () const;
    SlotDict *SlotDict () const;
    MethodDict *MethodDict () const;
    ForeignDict *ForeignDict () const;
    CodeModule *CodeModule () const;
    //
    u_long  HashValue () const;
    Word    ClassName () const;
    //
    const Instruction *GetCode (int method_index) const;
    const Instruction *SearchMethod (Message *) const;
    const Instruction *SearchCloseMethod () const;
    int	    Find_method (const ProtocolID &) const;
    MethodInfoClass *Find_method_in_supers (const ProtocolID &) const;
    Boolean LookMethod (ProtocolID pid);
    Word    MakeInstance (Priority p);
    //
    const ForeignNameList *ForeignInfo (int) const;
    //
    Name    InletSlotName (short n) const;
    Name    OutletSlotName (short n) const;
    Name    Printname () const;
    Name    Print () const;
    void    Dump (int indent = 0);
    //
#ifdef	PAS_DEBUGGER
    int	    LookMethodIndex (unsigned char *);
    int	    no_of_methods ();
    void    SetBreakClass ();
    void    SetUnBreakClass ();
    void    SetTraceClass ();
    void    SetUnTraceClass ();
    Boolean IsBreakClass ();
    Boolean IsTraceClass ();
    void    SetBreakMethod (int p = 0);
    void    SetUnBreakMethod (int p = 0);
    void    SetTraceMethod (int p = 0);
    void    SetUnTraceMethod (int p = 0);
    Boolean IsBreakMethod (int p = 0);
    Boolean IsTraceMethod (int p = 0);
    void    SetBreakSlot (int p = 0);
    void    SetUnBreakSlot (int p = 0);
    void    SetTraceSlot (int p = 0);
    void    SetUnTraceSlot (int p = 0);
    Boolean IsBreakSlot (int p = 0);
    Boolean IsTraceSlot (int p = 0);
    friend void CollectTemplate (ClassTmpl * ct);
#endif
};

inline void
ClassTmpl::SetVersion (long vno)
{
    if (vno > version)
	version = vno;
}

inline Boolean
ClassTmpl::DefineOnly ()
{
    return version == 0 ? TRUE : FALSE;
}

inline void
ClassTmpl::SetNofSlots (u_short i, u_short o)
{
    ninlets = i;
    noutlets = o;
}

inline void
ClassTmpl::SetSupers (class Supers * s)
{
    supers = s;
}

inline void
ClassTmpl::SetSlotDict (class SlotDict * s)
{
    slot_dict = s;
}

inline void
ClassTmpl::SetMethodDict (class MethodDict * m)
{
    method_dict = m;
}

inline void
ClassTmpl::SetForeignDict (class ForeignDict * f)
{
    foreign_dict = f;
}

#ifndef PAS_DEBUGGER
inline void
ClassTmpl::SetCodeModule (class CodeModule * c)
{
    if (DefineOnly () == TRUE)
	version = 1;
    code_module = c;
}
#endif

inline u_long
ClassTmpl::HashValue () const
{
    return _atom_val_ (name);
}

inline Word
ClassTmpl::ClassName () const
{
    return name;
}

inline u_short
ClassTmpl::no_of_inlets () const
{
    return ninlets;
}

inline u_short
ClassTmpl::no_of_all_inlets () const
{
    return supers->no_of_all_inlets ();
}

inline u_short
ClassTmpl::no_of_outlets () const
{
    return noutlets;
}

inline u_short
ClassTmpl::no_of_all_outlets () const
{
    return supers->no_of_all_outlets ();
}

inline u_long
ClassTmpl::no_of_slots () const
{
    return ninlets + noutlets;
}

inline u_long
ClassTmpl::no_of_all_slots () const
{
    return supers->no_of_slots ();
}

inline class Supers *
ClassTmpl::Supers () const
{
    return supers;
}

inline class SlotDict *
ClassTmpl::SlotDict () const
{
    return slot_dict;
}

inline class MethodDict *
ClassTmpl::MethodDict () const
{
    return method_dict;
}

inline class ForeignDict *
ClassTmpl::ForeignDict () const
{
    return foreign_dict;
}

inline class CodeModule *
ClassTmpl::CodeModule () const
{
    return code_module;
}

inline const Instruction *
ClassTmpl::GetCode (int index) const
{
    return (const Instruction *) & code_module->code[method_dict->v[index].ment];
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */

#endif				/* !class_template_h */
