/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdio.h>
#include <stream.h>
#include <assert.h>
#include "config.h"
#include "aum/error.h"
#include "aum/object.h"
#include "aum/alloc.h"
#include "table/atomhash.h"
#include "table/protocol.h"
#include "table/nlist.h"
#include "class/template.h"
#include "class/supers.h"
#include "class/slotdict.h"
#include "class/method.h"
#include "class/foreigndict.h"
#include "class/codemodule.h"
#include "class/clink.h"

#ifdef PAS_DEBUGGER
#include <stream.h>
#endif

u_long
ClassTmpl::size_of_instance () const
{
#ifdef PAS_DEBUGGER
    u_long  element_size = no_of_all_slots () + no_of_all_methods;
    u_long  sizeof_word = sizeof (Word);
    u_long  bit_vector_size = (element_size * 2) / (sizeof_word * 8) + sizeof_word;
    u_long  nbytes = ((sizeof (Object) - sizeof_word)
		      + (element_size * sizeof_word) + bit_vector_size);
#else
    u_long  nbytes = ((sizeof (Object) - sizeof (Word))
		      + (no_of_all_slots () * sizeof (Word)));
#endif
    return nbytes;
}

void   *
	ClassTmpl::operator
new (size_t s)
{
    return SHARED_ALLOC (s);
}

void
ClassTmpl::operator
delete (void *v)
{
    SHARED_FREE (v, sizeof (class ClassTmpl));
}


Supers *
MakeSupers (int nclasses)
// {}
// Ѿ饹(supers)
// {}
// Ѿ륯饹Ρؿ(nclasses)٤ͿơѾ饹
// Υݥ󥿤֤Ǥ Supers::Initialize() ˤ
// ʤƤϤʤ
// {}
{
    Supers *supers = (Supers *) SHARED_ALLOC (sizeofSupers (nclasses));
    return supers;
}

void
Supers::Initialize (Name class_name, int argc, const char *const argv[],
		    u_short nin, u_short nout)
// {}
// Ѿ饹(argc, argv)ʤӤ˥åȤο򸵤˷Ѿ
// Υݥ󥿤֤Ǥ SupersElement::
// Initialize() ˤ롥

// {}
{
    nsupers = argc;
    short   ibase = nin;
    short   obase = nout;
    for (int n = 0; n < argc; n++) {
	Boolean created;
	const ClassInfo *cli = Intern_class_info (argv[n], created);
	if (created) {
	    fatal ("Super class definition",
		   "\"#%s\" must be defined before \"#%s\"",
		   argv[n],class_name);
	}
	else {
	    const ClassTmpl *clt = cli->ClassTemplate ();
	    v[n].Initialize (clt, ibase, obase);
	    ibase += clt->no_of_all_inlets ();
	    obase += clt->no_of_all_outlets ();
	}
    }

    whole_inlets = ibase;
    whole_outlets = obase;
}

#ifdef PAS_DEBUGGER
extern void message_to_Listener (debugger_symbol, unsigned char *);
extern void message_to_Listener (debugger_symbol);
char	tb[BUFSIZ];
void
Supers::DumpNames (int indent = 0)
// {}
// ǥХåѴؿѾ饹ɸϤ˽Ϥ롥
// {}
{
    if (nsupers == 0)
	return;
    for (u_int tc = 0; tc < nsupers; tc++) {
	const ClassTmpl *ctp = v[tc].ClassTemplate ();
	sprintf (tb, "%s Super : %d  %s \n", tabs (indent), tc, ctp->Printname ());
	message_to_Listener (TRECEIVE, (unsigned char *) tb);
    }
}
void
Supers::Dump (int indent = 0)
// {}
// ǥХåѴؿѾ饹ɸϤ˽Ϥ롥
// {}
{
    sprintf (tb, "%s Super classes: %s \n", tabs (indent), hex (long (this)));
    message_to_Listener (TRECEIVE, (unsigned char *) tb);
}
#else
void
Supers::Dump (int indent = 0)
// {}
// ǥХåѴؿѾ饹ɸϤ˽Ϥ롥
// {}
{
    cout << tabs (indent) << "Super classes: " << hex (long (this)) <<nl ();
}
#endif

Word
ClassTmpl::MakeInstance (Priority p = 0)
// {}
// 饹Υ󥹥󥹥֥Ȥ롥ץ饤ƥ p
// ꤹ// {}
{
    Word    instance = CreateObject (this, p);
    return instance;
}

ClassTmpl::ClassTmpl (Word a, u_short i, u_short o,
		      Supers * s,
		      SlotDict * sd,
		      MethodDict * md,
		      ForeignDict * fd,
		      CodeModule * cm)
// {}
// 饹ƥץ졼Ȥιۻҡϰʲ̤Ǥ롥
// Word		饹ƥץ졼̾ʥȥࡥ
// u_short i	üåȤο
// u_short o	üåȤο
// SupersP		ƤΥ饹
// ReferencesP	Ȥ륯饹
// SlotDictP	åȼ
// MethodDictP	᥽åɼ
// CodeModuleP	ɥ⥸塼
// {}
{
    name = a;
    ninlets = i;
    noutlets = o;
    supers = s;
    slot_dict = sd;
    method_dict = md;
    foreign_dict = fd;
    code_module = cm;
    version = (cm == NULL) ? 0 : 1;
#ifdef PAS_DEBUGGER
    debug_bits = 0x0;
    no_of_all_methods = 0;
#endif
    // cout << form("new ClassTemplate = %#x", long(this)) << nl();
}

const ForeignNameList *
ClassTmpl::ForeignInfo (int index)
    const
{
    assert (0 <= index && index < foreign_dict->Nitems ());
    return foreign_dict->Getv (index);
}

#ifdef	PAS_DEBUGGER
void
ClassTmpl::Dump (int indent)
// {}
// ǥХåѴؿ饹ɸϤ˽Ϥ롥
// {}
{
    sprintf (tb, "%s ClassTemplate: 0x%s \n", tabs (indent), hex (long (this)));
    message_to_Listener (TRECEIVE, (unsigned char *) tb);
    indent += DUMPINDENT;
    sprintf (tb, "%s Version Number: %d \n", tabs (indent), version);
    message_to_Listener (TRECEIVE, (unsigned char *) tb);
    sprintf (tb, "%s # of inlets   : %d \n", tabs (indent), ninlets);
    message_to_Listener (TRECEIVE, (unsigned char *) tb);
    sprintf (tb, "%s # of outlets  : %d \n", tabs (indent), noutlets);
    message_to_Listener (TRECEIVE, (unsigned char *) tb);
    supers->Dump (indent);
    slot_dict->Dump (indent);
    method_dict->Dump (indent);
    code_module->Dump (indent);
    sprintf (tb, " %s\n %s\n", (IsTraceClass () ? "trace_class" : "untrace_class"),
	     (IsBreakClass () ? "break_class\n" : "unbreak_class\n"));
    message_to_Listener (TRECEIVE, (unsigned char *) tb);
    message_to_Listener (NRECEIVE);
}
#else
void
ClassTmpl::Dump (int indent)
// {}
// ǥХåѴؿ饹ɸϤ˽Ϥ롥
// {}
{
    cout << tabs (indent) << "ClassTemplate: 0x" << hex (long (this)) <<nl ();
    indent += DUMPINDENT;
    cout << tabs (indent) << "Version Number is " << version << nl ();
    cout << tabs (indent) << "# of inlet is " << ninlets << nl ();
    cout << tabs (indent) << "# of outlet is " << noutlets << nl ();
    supers->Dump (indent);
    slot_dict->Dump (indent);
    method_dict->Dump (indent);
    code_module->Dump (indent);
}
#endif

Name
ClassTmpl::Printname ()
const
// {}
// ǥХåѴؿ饹̾ʸȤ֤
// {}
{
    return AtomPrintname (name);
}

Name
ClassTmpl::Print ()
const
// {}
// ǥХåѴؿ饹ƥץ졼Ȥΰ̾ʸȤ֤
// {}
{
    return AtomPrintname (name);
}

Name
ClassTmpl::InletSlotName (short n)
const
// {}
// ǥХåѴؿåֹ n ͿüåȤΰ
// ֤̾
// {}
{
    return slot_dict->SlotName (n);
}

Name
ClassTmpl::OutletSlotName (short n)
const
// {}
// ǥХåѴؿåֹ n ͿüåȤΰ
// ֤̾
// {}
{
    return slot_dict->SlotName (n + ninlets);
}
#ifdef PAS_DEBUGGER
int
no_of_inherited_methods (Supers * s)
{

    if (!s)
	return 0;
    int	    no_of_supers;
    if ((no_of_supers = s->no_of_supers ()) == 0)
	return 0;
    int	    sum = 0;
    for (int co = 0; co < no_of_supers; co++) {
	const ClassTmpl *ctmp = s->Element (co)->ClassTemplate ();
	MethodDict *md = ctmp->MethodDict ();
	sum += md->no_of_methods ();
	sum += no_of_inherited_methods (ctmp->Supers ());
    }
    return sum;
}

void
ClassTmpl::SetCodeModule (class CodeModule * c)
{
    if (DefineOnly () == TRUE)
	version = 1;
    code_module = c;
    no_of_all_methods += method_dict->no_of_methods ();
    if (supers)
	no_of_all_methods += no_of_inherited_methods (supers);
    int	    sizeofword = sizeof (Word);
    int	    word_size = ((no_of_all_methods + ninlets + noutlets) * 2) /
    (sizeofword * 8) + 1;
    debug_bits_set = (Word *) SHARED_ALLOC (word_size * sizeofword);
    for (int ggg = 0; ggg < word_size; ggg++) {
	debug_bits_set[ggg] = 0;
    }
}

void
CollectTemplate (ClassTmpl * ct)
{
    if (!ct)
	return;
    Supers *sp = ct->Supers ();
    if (sp)
	SHARED_FREE ((void *) sp, sizeof (Supers));
    u_long  sizeof_word = sizeof (Word);
    u_long  element_size = ct->no_of_all_slots () + ct->no_of_all_methods;
    u_long  bit_vector_size = (element_size * 2) / (sizeof_word * 8) + sizeof_word;
    SHARED_FREE (ct->debug_bits_set, bit_vector_size);
    SlotDict *sd = ct->SlotDict ();
    if (sd)
	sd->Free ();
    MethodDict *md = ct->MethodDict ();
    if (md)
	md->Free ();
    CodeModule *cm = ct->CodeModule ();
    if (cm)
	cm->Free ();
    SHARED_FREE (ct, sizeof (ClassTmpl));
}

int
ClassTmpl::no_of_methods ()
{
    return (int) no_of_all_methods;
}
void
ClassTmpl::SetBreakClass ()
{
    debug_bits |= 0x01;
}
void
ClassTmpl::SetUnBreakClass ()
{
    debug_bits &= ~0x01;
}
void
ClassTmpl::SetTraceClass ()
{
    debug_bits |= 0x02;
}
void
ClassTmpl::SetUnTraceClass ()
{
    debug_bits &= ~0x02;
}
Boolean
ClassTmpl::IsBreakClass ()
{
    return (debug_bits & 0x1) ? TRUE : FALSE;
}
Boolean
ClassTmpl::IsTraceClass ()
{
    return (debug_bits & 0x2) ? TRUE : FALSE;
}
void
ClassTmpl::SetBreakMethod (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    noofslots = supers->no_of_slots ();
    int	    rewrite_pos = ((noofslots + p) * 2) / (sizeofword * 8);
    int	    rewrite_bit = ((noofslots + p) * 2) % (sizeofword * 8);
    debug_bits_set[rewrite_pos] |= (0x01 << rewrite_bit);
    cout.flush ();
}
void
ClassTmpl::SetUnBreakMethod (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    noofslots = supers->no_of_slots ();
    int	    rewrite_pos = ((noofslots + p) * 2) / (sizeofword * 8);
    int	    rewrite_bit = ((noofslots + p) * 2) % (sizeofword * 8);
    debug_bits_set[rewrite_pos] &= ~(0x01 << rewrite_bit);
}
void
ClassTmpl::SetTraceMethod (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    noofslots = supers->no_of_slots ();
    int	    rewrite_pos = ((noofslots + p) * 2 + 1) / (sizeofword * 8);
    int	    rewrite_bit = ((noofslots + p) * 2 + 1) % (sizeofword * 8);
    debug_bits_set[rewrite_pos] |= (0x01 << rewrite_bit);
}
void
ClassTmpl::SetUnTraceMethod (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    noofslots = supers->no_of_slots ();
    int	    rewrite_pos = ((noofslots + p) * 2 + 1) / (sizeofword * 8);
    int	    rewrite_bit = ((noofslots + p) * 2 + 1) % (sizeofword * 8);
    debug_bits_set[rewrite_pos] &= ~(0x01 << rewrite_bit);
}
Boolean
ClassTmpl::IsBreakMethod (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    noofslots = supers->no_of_slots ();
    int	    rewrite_pos = ((noofslots + p) * 2) / (sizeofword * 8);
    int	    rewrite_bit = ((noofslots + p) * 2) % (sizeofword * 8);
    return (debug_bits_set[rewrite_pos] & (0x01 << rewrite_bit)) ? TRUE : FALSE;
}
Boolean
ClassTmpl::IsTraceMethod (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    noofslots = supers->no_of_slots ();
    int	    rewrite_pos = ((noofslots + p) * 2 + 1) / (sizeofword * 8);
    int	    rewrite_bit = ((noofslots + p) * 2 + 1) % (sizeofword * 8);
    return (debug_bits_set[rewrite_pos] & (0x01 << rewrite_bit)) ? TRUE : FALSE;
}
void
ClassTmpl::SetBreakSlot (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    rewrite_pos = (p * 2) / (sizeofword * 8);
    int	    rewrite_bit = (p * 2) % (sizeofword * 8);
    debug_bits_set[rewrite_pos] |= (0x01 << rewrite_bit);
}
void
ClassTmpl::SetUnBreakSlot (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    rewrite_pos = (p * 2) / (sizeofword * 8);
    int	    rewrite_bit = (p * 2) % (sizeofword * 8);
    debug_bits_set[rewrite_pos] &= ~(0x01 << rewrite_bit);
}
void
ClassTmpl::SetTraceSlot (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    rewrite_pos = (p * 2 + 1) / (sizeofword * 8);
    int	    rewrite_bit = (p * 2 + 1) % (sizeofword * 8);
    debug_bits_set[rewrite_pos] |= (0x01 << rewrite_bit);
}
void
ClassTmpl::SetUnTraceSlot (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    rewrite_pos = (p * 2 + 1) / (sizeofword * 8);
    int	    rewrite_bit = (p * 2 + 1) % (sizeofword * 8);
    debug_bits_set[rewrite_pos] &= ~(0x01 << rewrite_bit);
}
Boolean
ClassTmpl::IsBreakSlot (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    rewrite_pos = (p * 2) / (sizeofword * 8);
    int	    rewrite_bit = (p * 2) % (sizeofword * 8);
    return (debug_bits_set[rewrite_pos] & (0x01 << rewrite_bit)) ? TRUE : FALSE;
}
Boolean
ClassTmpl::IsTraceSlot (int p = 0)
{
    int	    sizeofword = sizeof (Word);
    int	    rewrite_pos = (p * 2 + 1) / (sizeofword * 8);
    int	    rewrite_bit = (p * 2 + 1) % (sizeofword * 8);
    return (debug_bits_set[rewrite_pos] & (0x01 << rewrite_bit)) ? TRUE : FALSE;
}

#endif

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
