/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef class_supers_h
#define class_supers_h

#include "config.h"
#include "aum/types.h"


class ClassTmpl;		// pre-define

// {}
// Ѿ饹
// {}
// 饹ؤΥݥ󥿤ӥåȥ١ΰ֡Supers 
// {}
class SupersElement {
private:
    const ClassTmpl *classtmpl; // ѾƤΥ饹ؤΥݥ
    short	inlet_base;	// ƿƥ饹ΥåȤΥ١֡ƤΥ
    short	outlet_base;	// 饹ΥåȤѤåȥ١
				// ΰ֤ؤ뤿Ѥ롥̤
				// λͤ롥
public:
    void	Initialize(const ClassTmpl*, short ibase, short obase);
    const ClassTmpl* ClassTemplate () const { return classtmpl; }
    short	InletSlotBase () const	{ return inlet_base; }
    short	OutletSlotBase () const { return outlet_base; }
};

inline void
SupersElement::Initialize(const ClassTmpl* tmpl, short ibase, short obase)
{
    classtmpl = tmpl;
    inlet_base = ibase;
    outlet_base = obase;
}

// {}
// Ѿ饹(supers)
// {}
// Ѿ˥饹ؤΥݥ󥿤ӥåȥ١ΰ֤¤٤
// {}
class Supers {
private:
    Length nsupers;		// Ѿ饹礭
    u_short	whole_inlets;	// åȤοʼʬȡܿơˡʬȤΥ
    u_short	whole_outlets;	// 饹ΥåȤο˿ƤΥ饹ΥåȤ
				// äΡ󥹥󥹥֥Ȥ
				// 礭ꤹѤ롥
    SupersElement v[1];

public:
    void	Initialize(Name class_name, int argc, const char*const argv[],
			   u_short nin, u_short nout);
    const SupersElement* Element (short n) const { return &v[n]; }
    int		no_of_supers () const { return nsupers; }
    u_short	no_of_all_inlets() const;
    u_short	no_of_all_outlets() const;
    u_long	no_of_slots() const;
    //
    void	Dump(int indent = 0);
#ifdef PAS_DEBUGGER
    void	DumpNames(int indent = 0);
#endif
};

inline u_short	Supers::no_of_all_inlets()
    const
{
    return whole_inlets;
}

inline u_short	Supers::no_of_all_outlets()
    const
{
    return whole_outlets;
}

inline u_long	Supers::no_of_slots()
    const
{
    return whole_inlets + whole_outlets;
}

inline Bytes sizeofSupers(Uint n)
{
    if (n > 1) n -= 1;
    return sizeof(Supers) + sizeof(SupersElement) * n;
}


extern Supers* MakeSupers (int argc);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !class_supers_h */
