/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef class_slotdict_h
#define class_slotdict_h

#include "config.h"
#include "aum/word.h"

class ClassTmpl;

// {}
// åȸ
// {}
// {}
class SlotDictElement {
friend class SlotDict;
    const char* name;		// å̾
    char	outlet;		// åȤüü򼨤
    unsigned short position;	// 饹Υåȥ١Υեåȡ
#ifdef PAS_DEBUGGER
    char debugg_bits;
#endif
public:
    void	Initialize(const char*, int, int);
#ifdef PAS_DEBUGGER
    inline Boolean IsBreakSlot();
    inline Boolean IsTraceSlot();
    inline void SetBreakSlot();
    inline void SetTraceSlot();
    inline void UnSetBreakSlot();
    inline void UnSetTraceSlot();
#endif
};

// {}
// åȸ(slot dictionary)
// {}
// ꤵ줿å̾Ф륹åȤƥ󥹥󥹡֥
// Ȥݻ륹åȥơ֥βˤ뤫򸡺뤿μǤ
// 롥å̾򥭡ȤơåȤη¤Ӥ˥åȥơ֥⥪
// եåȤϥåɽǤ롥ξϡǥХåΤѰ
// Ƥ롥
// {}
typedef class SlotDict {
private:
    int nslots;		// åȿ
    SlotDictElement v[1];

public:
    int		NofSlots() const;
    Name	SlotName(short n) const;
    Boolean	IsOutlet(u_long n) const;
    int		Position(u_long n) const;
    void	Dump(int indent = 0);
#ifdef PAS_DEBUGGER
    void	Free();
#endif
friend SlotDict* MakeSlotDictionary(int nslots);
}*	SlotDictP;

inline int  SlotDict::NofSlots() const
{
    return nslots;
}

inline Name SlotDict::SlotName(short n) const
{
    return v[n].name;
}

inline Boolean SlotDict::IsOutlet(u_long n) const
{
    return v[n].outlet ? TRUE : FALSE;
}

inline int  SlotDict::Position(u_long n) const
{
    return v[n].position;
}

inline Bytes sizeofSlotDict(u_long n)
{
    if (n > 1) n -= 1;
    return sizeof(SlotDict) + sizeof(SlotDictElement) * n;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !class_slotdict_h */
