/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
// slotdict.c
// Υեϥ饹ƥץ졼ȤΥåȼطδؿǼ
// Ƥ롥
//
#include <stream.h>
#include "config.h"
#include "aum/global.h"
#include "aum/error.h"
#include "table/atomhash.h"
#include "aum/alloc.h"
#include "class/template.h"
#include "class/slotdict.h"
#include "loader/info.h"

// {}
// åȸ(slot dictionary)ν
// {}
// åȸǤ롥å̾øʸ
// string ǡ flag (outlet=1, inlet=0) ǡƥåֹ
// number Ϳ롥
// {}
void SlotDictElement::Initialize(const char* string, int flag, int number)
{
    name = SavePureString(string);
    outlet = flag;
    position = number;
}

// {}
// åȸ(slot dictionary)
// {}
// Υ饹ΡإåȤο٤Ϳơåȸ
// ݥ󥿤֤
// ƥåȥȥϡSlotDictElement::Initialize() ˤ
// 롥
// {}
SlotDictP MakeSlotDictionary(int nslots)
{
    SlotDictP slotdp = SlotDictP(SHARED_ALLOC(sizeofSlotDict(nslots)));
    slotdp->nslots = nslots;

    for (register int n = 0; n < nslots; n++) {
	SlotInfop s = slot_info_table[n];
	slotdp->v[n].Initialize(s->name, s->type, s->offset);
    }
    return slotdp;
}
#ifdef PAS_DEBUGGER
void SlotDict::Free()
{
    unsigned int ll = (nslots > 1) ? nslots-1 : 0;
    SHARED_FREE(this,sizeof(SlotDict)+sizeof(SlotDictElement)*ll);
}
#endif

// {}
// SlotDict::Dump(int indent)
// {}
// ǥХåѴؿåȸɸϤ˽Ϥ롥
// {}
void SlotDict::Dump(int indent = 0)
{
    cout << tabs(indent) << "Slot dictionary: " << hex(long(this));
    cout << ", # of slot is " << nslots << dotnl();
    indent += DUMPINDENT;
    for (register int n = 0; n < nslots; n++) {
	cout << tabs(indent) << "slot[" << v[n].position << "] = ";
	cout << (v[n].outlet ? "!" : "@") << v[n].name;
	cout << nl();
    }
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
