/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
//
// methoddict.c
// Υեϥ饹ƥץ졼ȤΥ᥽åɸطδؿ
// ǼƤ롥
//
#include <stream.h>
#include "aum/error.h"
#include "aum/global.h"
#include "aum/alloc.h"
#include "class/template.h"
#include "class/method.h"
#include "loader/info.h"

void
MethodDictElement::Initialize(ProtocolID id, u_long offset)
    // {}
    // ڥ᥽åɸǤνۥ᥽åɸǤ
    // 롥(name,arity,modes,offset)ץȥɣĤᡤ
    // Ȥƥ᥽åɤΡإƬΥեåȡ٤Ͽ롥
    // {}

{
    pid = id;
    ment = offset;
#ifdef PAS_DEBUGGER
    debug_bits = 0x0;
#endif
}

MethodDict*
MakeMethodDictionary(int nm)
    // {}
    // ڥ᥽åɸϢɽ(method dictionary)ۤΥ饹Ρإ
    // åɤο٤Ϳơ᥽åɸϢۼΥݥ
    // ֤ϡMethodDictElement::Initialize() ˤ
    // 롥
    // {}
{
    MethodDict* methodp = (MethodDict*)SHARED_ALLOC(sizeofMethodDict(nm));
    methodp->nmethods = nm;

    for (register int n = 0; n < nm; n++) {
	MethodInfop m = method_info_table[n];
	ProtocolID pid = pid_info_table[m->pid_idx]->pid;
	methodp->v[n].Initialize(pid, m->offset);
    }
    return methodp;
}

#ifdef PAS_DEBUGGER
void MethodDict::Free()
{
   SHARED_FREE((void*)this,sizeofMethodDict(nmethods));
}
#endif
#ifdef PAS_DEBUGGER
void
MethodDict::Dump(int indent = 0)
    // {}
    // ǥХåѴؿ᥽åɸϢɽɸϤ˽Ϥ롥
    // {}
{
    cout << tabs(indent) << "Method dictionary: " << hex(long(this));
    cout << ", # of method is " << nmethods << dotnl();
    indent += DUMPINDENT;
    for (register int n = 0; n < nmethods; n++) {
	cout << tabs(indent) <<
	    dec(v[n].ment, 4) << " = " << v[n].pid.Printname() << dotnl();
    }
}
#else
void
MethodDict::Dump(int indent = 0)
    // {}
    // ǥХåѴؿ᥽åɸϢɽɸϤ˽Ϥ롥
    // {}
{
    cout << tabs(indent) << "Method dictionary: " << hex(long(this));
    cout << ", # of method is " << nmethods << dotnl();
    indent += DUMPINDENT;
    for (register int n = 0; n < nmethods; n++) {
	cout << tabs(indent) <<
	    dec(v[n].ment, 4) << " = " << v[n].pid.Printname() << dotnl();
    }
}
#endif
/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
