/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef class_method_h
#define class_method_h
#include "config.h"
#include "aum/debugger.h"

// {}
// ᥽åɸϢɽ
// {}
// {}
class MethodDictElement {
friend class	MethodDict;
friend class	ClassTmpl;
private:
    ProtocolID	pid;		// ץȥ뼱̻
    int		ment;		// ɡ⥸塼⥪եå
#ifdef PAS_DEBUGGER
    Uint      debug_bits;  // פˤʤ롣
#endif
public:
    void	Initialize(ProtocolID, u_long);

#ifdef PAS_DEBUGGER
    inline ProtocolID PID();
    inline Boolean   IsTracePoint();
    inline Boolean   IsBreakPoint();
    inline void	     SetBreakPoint();
    inline void	     SetUnBreakPoint();
    inline void	     SetTracePoint();
    inline void	     SetUnTracePoint();
#endif
};

#ifdef PAS_DEBUGGER
inline ProtocolID  MethodDictElement::PID()
{
    return pid;
}
inline Boolean	   MethodDictElement::IsTracePoint()
{
    return (debug_bits & 0x02) ? TRUE : FALSE;
}
inline Boolean	   MethodDictElement::IsBreakPoint()
{
    return (debug_bits & 0x01) ? TRUE : FALSE;
}
inline void	   MethodDictElement::SetBreakPoint()
{
    debug_bits |= 0x01;
}
inline void	   MethodDictElement::SetUnBreakPoint()
{
    debug_bits &= ~0x01;
}
inline void	   MethodDictElement::SetTracePoint()
{
    debug_bits |= 0x02;
}
inline void	   MethodDictElement::SetUnTracePoint()
{
    debug_bits &= ~0x02;
}
#endif

// {}
// ᥽åɸϢɽ(method dictionary)
// {}
// ᥽åɼ̾ PID ϥå塦Ȥơɡ⥸塼⥪
// å MENT ϥåɽǤ롥
// {}
class MethodDict {
    friend MethodDict* MakeMethodDictionary(int nmethods);
friend class	ClassTmpl;
private:
    int		nmethods;	// ᥽åɤο
    MethodDictElement v[1];

public:
    int		Find_method (const ProtocolID& pid) const;
    void	Dump(int indent = 0);
#ifdef PAS_DEBUGGER
    inline MethodDictElement* entry(int i);
    inline int no_of_methods();
    void       Free();
#endif
};

inline Bytes sizeofMethodDict(int n)
{
    if (n > 1) n -= 1;
    return sizeof(MethodDict) + sizeof(MethodDictElement) * n;
}

#ifdef PAS_DEBUGGER
inline MethodDictElement* MethodDict::entry(int i)
{
    return v+i;
}
inline int MethodDict::no_of_methods()
{
    return (int)(nmethods);
}
#endif

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !class_method_h */
