/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/error.h"
#include "aum/global.h"
#include "aum/j-c.h"
#include "aum/trace.h"
#include "aum/object.h"
#include "class/template.h"
#include "class/method.h"
#include "class/codemodule.h"
#include "class/clink.h"

#ifdef PAS_DEBUGGER
#include "aum/debugger.h"
#endif /* PAS_DEBUGGER */

static const ClassInfo* superObject;

#ifdef nodef
static void
get_args (Message* cmp)
{
    register int n = cmp->Arity();
    while (--n >= 0) {
	Word x = (*cmp)[n];

	while (IsObject(x)) {

	    assert (J_C_ptr(x)->oTag() != GARBAGE);
	    assert (J_C_ptr(x)->LRC() > 0);

	    switch (Pointer(x)->oTag()) {
	    case MJ_C:
		x = MJ_C_ptr(x)->Dereference ();
		continue;

	    case MJ_Mut:
		x = MJ_Mut_ptr(x)->Dereference ();
		continue;

	    case AJ_C:
		/* empty */

	    default:
		goto assign;
	    }
	}
    assign:
	Reg[n] = x;
    }
}
#endif

static void
get_args (const Message* cmp)
{
    register int n = cmp->Arity();
    while (--n >= 0)
	Reg[n] = cmp->Argv (n);
}

/////////////////////////////////////////////////////////////////////////
static MethodInfoClass MethodInfo;
void
MethodInfoClass::Initialize (const ClassTmpl* ct, int mx, u_short i, u_short o)
{
    tmpl = ct;
    method_index = mx;
    ibase = i, obase = o;
}

void
MethodInfoClass::Add_iobase (u_short i, u_short o)
{
    ibase += i;
    obase += o;
}

const Instruction*
MethodInfoClass::Commit ()
    const
{
    CurrentObject->Set_slot_bases (ibase, obase);
    CurrentClass = tmpl;
    return tmpl->GetCode (method_index);
}

/////////////////////////////////////////////////////////////////////////
int
MethodDict::Find_method (const ProtocolID& pid)
    const
{
    for (int n = 0; n < nmethods; n++) {
	if (v[n].pid == pid)
	    return n;
    }
    return -1;
}

int
ClassTmpl::Find_method (const ProtocolID& pid)
    const
{
    return method_dict->Find_method (pid);
}

MethodInfoClass*
ClassTmpl::Find_method_in_supers (const ProtocolID& pid)
    const
    // {}
    // Ѿ˽äƿƤΥ᥽åɤƵŪܤĤäˤϥ
    // 饹ƥץ졼ȡ᥽åɰ֡åȥ١򥻥åȤ᥽
    // ɾ֤
    // {}
{
    const int n_supers = supers->no_of_supers ();
    for (int n = 0; n < n_supers; n++) {
	const SupersElement* se = supers->Element (n);
	const int ibase = se->InletSlotBase ();
	const int obase = se->OutletSlotBase ();
	const ClassTmpl* ct = se->ClassTemplate ();
	const int index = ct->Find_method (pid);
	if (index >= 0) {
	    MethodInfo.Initialize (ct, index, ibase, obase);
	    return &MethodInfo;
	}
	MethodInfoClass* mip = ct->Find_method_in_supers (pid);
	if (mip) {
	    mip->Add_iobase (ibase, obase);
	    return mip;
	}
    }
    return NULL;
}

const Instruction*
ClassTmpl::SearchMethod(Message *mp)
    const
    // {}
    // å mp б᥽åɤ򸡺б᥽åɡ
    // ɤؤΥݥ󥿤֤
    // {}
{
    int index = Find_method (mp->PID ());
    if (index >= 0) {
	get_args (mp);
	MethodInfo.Initialize (this, index, 0, 0);
	return MethodInfo.Commit ();
    }
    if (supers) {
	const MethodInfoClass* mip = Find_method_in_supers (mp->PID ());
	if (mip) {
	    get_args (mp);
	    return mip->Commit ();
	}
    }

    if (!superObject) {
	superObject = Find_class_info ("Object");
    }
    if (!superObject) {
	error ("SearchMethod", "System library is not loaded");
	//"Library \"system.aas\" has't been loaded");
    } else {
	const ClassTmpl* ct = superObject->ClassTemplate ();
	index = ct->Find_method (mp->PID ());
	if (index >= 0) {
	    get_args (mp);
	    MethodInfo.Initialize (ct, index, 0, 0);
	    return MethodInfo.Commit ();
	}
    }

    index = Find_method (PID_DEFAULT);
    if (index >= 0) {
	Reg[0] = mp->CreateMessageObject ();
	MethodInfo.Initialize (this, index, 0, 0);
	return MethodInfo.Commit ();
    }
    if (supers) {
	const MethodInfoClass* dip = Find_method_in_supers (PID_DEFAULT);
	if (dip) {
	    Reg[0] = mp->CreateMessageObject ();
	    return dip->Commit ();
	}
    }
    fatal("SearchMethod",
	  "Can't find the method: #%s:%s",  Printname(), mp->Print());
    return NULL;
}

const Instruction*
ClassTmpl::SearchCloseMethod()
    const
    // {}
    // ץȥɣ PID_CLOSE ɽ᥽åɤ¸ߤФΥ
    // ֤ǤʤХ֤
    // {}
{
    register const class MethodDict *const mdp = method_dict;
    register int n = mdp->nmethods;
    while (--n >= 0) {
	if (mdp->v[n].pid == PID_CLOSE) {
	    MethodInfo.Initialize (this, n, 0, 0);
	    return MethodInfo.Commit ();
	}
    }
    return (Instruction*)0;
}

Boolean
ClassTmpl::LookMethod(ProtocolID pid)
    // {}
    // ץȥɣ pid ɽ᥽åɤ¸ߤ TRUE ֤
    // Ǥʤ FALSE ֤ޤ᥽åɤ¸ߤƤ᥽
    // ɤؤΥɤѿ LastLookedMethod ˥åȤ롥
    // {}
{
    for (register int n = 0; n < method_dict->nmethods; n++) {
	if (method_dict->v[n].pid == pid)
	    return TRUE;
    }
    return FALSE;
}

#ifdef PAS_DEBUGGER
extern Name PidPrintname(ProtocolID pid);
inline Boolean p_strcmp(unsigned char* a,unsigned char* b)
{
    for (;*a;a++,b++){
	if (*a != *b) return FALSE;
	if (!(*b)&&(a)) return FALSE;
    }
    if ((*b == '+')||(*b == '-'))
	return FALSE;
    return TRUE;
}

int methodindex;
int look_super_class_methods(Supers* supers,unsigned char* str)
{
    int n_supers = supers->no_of_supers ();
    for (int n = 0; n < n_supers; n++) {
	const ClassTmpl* dtmp = supers->Element(n)->ClassTemplate();
	class MethodDict* mdp = dtmp->MethodDict ();
	for (int p = 0;p < (mdp->no_of_methods());p++,methodindex++) {
	    if (p_strcmp((unsigned char*)PidPrintname(mdp->entry(p)->PID()),str)){
		return methodindex;
	    }
	}
	int ret;
	if ((ret = look_super_class_methods(dtmp->Supers(),str))>=0)
	    return ret;
    }
    return -1;
}
int ClassTmpl::LookMethodIndex(unsigned char* str)
{
    methodindex = 0;
    for (;methodindex<(method_dict->no_of_methods());methodindex++) {
	if (p_strcmp((unsigned char*)PidPrintname(method_dict->v[methodindex].pid),str))
	    return methodindex;
    }
    //if (p_strcmp((unsigned char*)"DEFAULT",str))
    //return -1;
    int ret;
    if (supers){
	if ((ret = look_super_class_methods(supers,str))>=0)
	    return ret;
    }
    return -1;
}
#endif

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */

