/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef class_foreigndict_h
#define class_foreigndict_h

#include "config.h"

class ForeignNameList;

// ¾μ
class ForeignDict {
private:
    int nitems;
    ForeignNameList* v[1];
public:
    int Nitems () const
	{
	    return nitems;
	}
    void Nitems (int n)
	{
	    nitems = n;
	}
    void Setv (int, ForeignNameList *);
    const ForeignNameList* Getv (int n) const
	{
	    return v[n];
	}
    void Dump (int indent = 0);
};

inline int sizeofForeignDict (int n)
{
    if (n > 1) n -= 1;
    return sizeof (ForeignDict) + sizeof (ForeignNameList *) * n;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !class_foreigndict_h */
