/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stream.h>
#include "aum/alloc.h"
#include "aum/error.h"
#include "class/foreigndict.h"
#include "table/nlist.h"
#include "loader/info.h"

ForeignDict*
MakeForeignDictionary (int nf)
{
    ForeignDict* fdi = (ForeignDict *) SHARED_ALLOC (sizeofForeignDict(nf));
    fdi->Nitems (nf);

    for (register int n = 0; n < nf ; n++) {
	ForeignInfop f = foreign_info_table[n];
	fdi->Setv (n, f->fnlp);
    }
    return fdi;
}

void
ForeignDict::Setv (int n, ForeignNameList *np)
{
    np->RC_plus (1);
    v[n] = np;
}

#ifndef DYNAMIC_LINK

void
ForeignDict::Dump (int indent = 0)
    // {}
    // ǥХåѴؿ
    // {}
{
    cout.form ("Foreign language interface dictionary: 0x%x ", this);
    cout.form ("has %d members.\n", nitems);
    for (register int n = 0; n < nitems; n++) {
	cout.form ("%d: ", n);
	ForeignNameList *np = v[n];
	dump_foreign_namelist (np);
    }
}

#endif /* DYNAMIC_LINK */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
