/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
// codemodule.c
// Υեϥ饹ƥץ졼ȤΥɥ⥸塼طδؿ
// ǼƤ롥
//
#include <stream.h>
#include "config.h"
#include "aum/error.h"
#include "aum/global.h"
#include "aum/alloc.h"
#include "class/template.h"
#include "class/codemodule.h"
#include "loader/info.h"
#include "loader/disasm.h"

void CodeModule::Initialize()
    // {}
    // ɥ⥸塼Ǥ롥
    // {}
{
    for (register int n = l_total; --n >= 0; code[n] = tc[n]) ;
}

CodeModuleP MakeCodeModule(Uint ncode, Uint ndata, Uint ntmpl)
    // {}
    // ɥ⥸塼(code module)
    // {}
    // Υ饹Ρؼ¹ԥɷ礭١إդǡ礭
    // ¤Ӥˡإ饹ƥץ졼ȤؤΥݥ󥿷礭٤ñ̥
    // ɤͿơɥ⥸塼Υݥ󥿤֤Ʒ
    // Ǥϡ줾 CodeModule::Initialize()ˤ롥
    // {}
{
    Uint total = ncode + ndata + ntmpl;
    CodeModuleP cmp = CodeModuleP(SHARED_ALLOC(sizeofCodeModule(total)));
    cmp->l_total = total;
    cmp->l_code = ncode;
    cmp->l_data = ndata;
    cmp->l_tmpl = ntmpl;
    cmp->Initialize();
    return cmp;
}

void CodeModule::Dump(int indent = 0)
    // {}
    // ǥХåѴؿɥ⥸塼ɸϤ˽Ϥ롥
    // {}
{
    cout << tabs(indent) << "Code Module: " << hex(long(this)) << nl();

    indent += DUMPINDENT;
    const char* s;
    DisAssembler x(this);
    while ((s = x.dis_assemble()) != 0)
	cout << tabs(indent) << s << nl();
}
#ifdef PAS_DEBUGGER
void CodeModule::Free()
{
    SHARED_FREE(this,sizeofCodeModule(l_total));
}
#endif

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
