/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef class_clink_h
#define class_clink_h

#include "aum/header.h"
#include "table/atomhash.h"

class ClassTmpl;

class Subs {
    ClassTmpl*		classtmpl;
    Subs*		nextchain;

public:
    inline		Subs();
    inline	       ~Subs();
#ifdef PAS_DEBUGGER
    inline	       Subs* Next();
#endif
    //
    void		Dump(int indent = 0);
};

inline Subs::Subs() {}
inline Subs::~Subs() {}

#ifdef PAS_DEBUGGER
inline Subs* Subs::Next() {return nextchain;}
#endif

class ClassInfo : public Header {
private:
    Word		classname;
    ClassTmpl*		classtmpl;
    ClassInfo*		nextchain;
    Subs*		subs;

#ifdef	PAS_DEBUGGER
    u_long		debug_bits;
#endif

public:
    inline		ClassInfo();
    //
    void		Initialize(ClassTmpl*, ClassInfo*);
    //
    inline Boolean	Equal(ClassTmpl*) const;
    inline Boolean	EqualName(Word) const;
    inline ClassInfo*	NextChain() const;
    inline Word		ClassName() const;
    inline ClassTmpl*	ClassTemplate() const;
    inline Subs*	SubClasses() const;
    inline const char*	ClassPrintname() const;
    void		Dump(int indent = 0);
#ifdef	PAS_DEBUGGER
    void		Clear();
#endif
};

inline ClassInfo::ClassInfo() : (UNUSED) {}

inline Boolean		ClassInfo::EqualName(Word atom)
    const
    // {}
    // ̾ atom ȥ饹̾Ʊʤп򤽤Ǥʤе
    // ֤
    // {}
{
    return _wordeq_(atom, classname) ? TRUE : FALSE;
}

inline Boolean		ClassInfo::Equal(ClassTmpl* tmpl)
    const
    // {}
    // 饹ƥץ졼 tmpl ȥ饹̾Ʊʤп򤽤
    // Ǥʤе֤
    // {}
{
    return _wordeq_(tmpl->ClassName(), classname) ? TRUE : FALSE;
}

inline ClassInfo*	ClassInfo::NextChain() const
{
    return nextchain;
}

inline Word		ClassInfo::ClassName() const
{
    return classname;
}

inline ClassTmpl*	ClassInfo::ClassTemplate() const
{
    return classtmpl;
};

inline Subs*		ClassInfo::SubClasses() const
{
    return subs;
}

inline Name		ClassInfo::ClassPrintname() const
{
    return AtomPrintname(classname);
}


// Ǥ륯饹κ
#define MAX_CLASSES 1024

extern ClassInfo  ClassInfoTable[MAX_CLASSES];
extern int	  no_of_class_info;
extern ClassInfo* Find_class_info (Word class_atom);
extern ClassInfo* Find_class_info (Name class_name);
extern ClassInfo* Intern_class_info (Word class_atom, Boolean& created);
extern ClassInfo* Intern_class_info (Name class_name, Boolean& created);
extern Word	  Create_instance (const ClassInfo* cip);
extern Word	  Create_local_instance (const ClassInfo* cip);
extern Word	  Create_instance_on_it (const ClassInfo* cip, u_char pe);

/* size of CLASS-TEMPLATE's hash table */
#define ClassTableSize	509

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !class_clink_h */
