/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stream.h>
#include <assert.h>
#include "config.h"
#include "aum/error.h"
#include "class/template.h"
#include "class/clink.h"

ClassInfo* ClassTable[ClassTableSize];


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

void Subs::Dump(int indent)
{
    cout << tabs(indent) << "Sub Classes: " << hex(long(this)) << nl();
}

/////////////////////////////////////////////////////////////////////////////

// 饹Υơ֥롥饹ȤϤΥơ֥Υǥå
// ƹԤʤ

ClassInfo ClassInfoTable[MAX_CLASSES];

// Υ饹θĿ

int no_of_class_info;

static ClassInfo*
new_ClassInfo(ClassTmpl* tmpl, ClassInfo* info)
{
    if (no_of_class_info >= MAX_CLASSES)
	fatal("new_ClassInfo", "too many class definition");
    ClassInfo* cp = &ClassInfoTable[no_of_class_info++];
    cp->Initialize(tmpl, info);
    return cp;
}

void
ClassInfo::Initialize (ClassTmpl* tmpl, ClassInfo* next)
{
    classtmpl = tmpl;
    nextchain = next;
    classname = tmpl->ClassName();
}

#ifdef PAS_DEBUGGER
extern message_to_Listener(debugger_symbol,unsigned char*);
void ClassInfo::Clear()
{
    classtmpl = (ClassTmpl*)0;
    nextchain = (ClassInfo*)0;
}
void ClassInfo::Dump(int indent = 0)
    // {}
    // ǥХåѴؿ饹ɸϤ˽Ϥ롥
    // {}
{
    message_to_Listener(TRECEIVE,(unsigned char*)tabs(indent));
    message_to_Listener(TRECEIVE,(unsigned char*)"Class Information of ");
    message_to_Listener(TRECEIVE,(unsigned char*)form("\"%s\" (%#x) \n",ClassPrintname(),long(this)));
    indent += DUMPINDENT;
    classtmpl->Dump(indent);
    subs->Dump(indent);
}
#else
void ClassInfo::Dump(int indent = 0)
    // {}
    // ǥХåѴؿ饹ɸϤ˽Ϥ롥
    // {}
{
    cout << tabs(indent) << "Class Information of " <<
	form("\"%s\" (%#x)", ClassPrintname(), long(this)) << "\n";

    indent += DUMPINDENT;
    classtmpl->Dump(indent);
    subs->Dump(indent);
}
#endif

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

ClassInfo*
Find_class_info (Word class_atom)
    // {}
    // A'Um Υȥɽ̾ĥ饹򸫤Ĥ롥Ĥ
    // ʤ NULL ֤
    // {}
{
    u_long location = AtomNumber (class_atom) % ClassTableSize;
    ClassInfo* ht = ClassTable[location];
    while (ht) {
	if (ht->ClassName() == class_atom) {
	    return ht;
	}
	ht = ht->NextChain();
    }
    return NULL;
}

ClassInfo*
Intern_class_info (Word class_atom, Boolean& created)
    // {}
    // A'Um Υȥɽ̾ĥ饹򸫤Ĥ롥Ĥ
    // ʤϿ˥饹ȥƥץ졼Ȥ֤
    // ޤˤ created  TRUE 򥻥åȤ롥ʤ
    //  created ͤ FALSE Ǥ롥
    // {}
{
    ClassInfo* cli = Find_class_info (class_atom);
    if (cli) {
	created = FALSE;
	return cli;
    }
    u_long location = AtomNumber (class_atom) % ClassTableSize;
    ClassTmpl* clt = new ClassTmpl (class_atom, 0, 0, 0, 0, 0, 0, 0);
    cli = new_ClassInfo(clt, ClassTable[location]);
    ClassTable[location] = cli;

    created = TRUE;
    return cli;
}

#ifdef PAS_DEBUGGER
void DumpClassTable()
    // {}
    // ǥХåѴؿ饹ơ֥ƤɸϤ˽Ϥ롥
    // {}
{

    message_to_Listener(TRECEIVE,(unsigned char*)"\n*** Dump Class Table ***\n");
    for (register int location = 0; location < ClassTableSize; location++) {
	for (register ClassInfo* ht = ClassTable[location];
	     ht != (ClassInfo*)0; ht = ht->NextChain()) {
	    ht->Dump();
	    cout << nl();
	}
    }
}
#else
void DumpClassTable()
    // {}
    // ǥХåѴؿ饹ơ֥ƤɸϤ˽Ϥ롥
    // {}
{
    cout << "\n************ Dump Class Table ************\n";
    for (register int location = 0; location < ClassTableSize; location++) {
	for (register ClassInfo* ht = ClassTable[location];
	     ht != (ClassInfo*)0; ht = ht->NextChain()) {
	    ht->Dump();
	    cout << nl();
	}
    }
}
#endif


////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
ClassInfo*
Find_class_info (Name class_name)
    // {}
    // øʸɽ̾ĥ饹򸫤Ĥ롥Ĥ
    // ʤϣ֤
    // {}
{
    Word class_atom = InternAtom (class_name);
    return Find_class_info (class_atom);
}

ClassInfo*
Intern_class_info (Name class_name, Boolean& created)
    // {}
    // øʸɽ̾ĥ饹ƥץ졼Ȥ򸫤Ĥ롥
    // ĤʤϿ롥
    // {}
{
    Word class_atom = InternAtom (class_name);
    return Intern_class_info (class_atom, created);
}

#ifdef PAS_DEBUGGER

extern void CollectTemplate(ClassTmpl* ct);

void CollectClassInfo(ClassInfo* cl)
{
    while (cl != (ClassInfo*)0){
	ClassTmpl* ct = cl->ClassTemplate();
	for (Subs*	ss = cl->SubClasses();ss;){
	    Subs* work = ss;
	    ss = ss->Next();
	    SHARED_FREE(work,sizeof(Subs));
	}
	CollectTemplate(ct);
	ClassInfo* work = cl;
	cl = cl->NextChain();
	SHARED_FREE((void*)work,sizeof(ClassInfo));
    }
}

void End_ClassInfo()
{
    int index;
    for (index = 0;index < no_of_class_info;index++) {
	CollectClassInfo(ClassTable[index]);
	ClassTable[index] = (ClassInfo*)0;
    }
    for (index = 0;index < no_of_class_info;index++) {
	ClassInfoTable[index].Clear();
    }
    no_of_class_info = 0;
}
#endif

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
