/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/vector.h"
#include "aum/stdlib.h"
#include "aum/parallel.h"
#include "aum/tstream.h"
#include "aum/alloc.h"
#include "aum/trace.h"
#include "aum/who.h"
#include "aum/wait.h"
#include "builtin/extern.h"

VectorObject *
new_Vector (int len)
{
    assert (len >= 0);
    if (len == 0)
	len = 1;
    int nbytes = sizeof (Word) * (len - 1 + len / 32 + 1) + sizeof (VectorObject);
    VectorObject* vp = (VectorObject *) SHARED_ALLOC (nbytes);
    vp->nbytes = nbytes;
    return vp;
}

void
VectorObject::Initialize (int vsize, Word init)
    // {}
    // ٥֥Ȥν٤ƤǤ init ˽
    // 롣nbytes Ǥ new_Vector () ˤäꤵ롥
    // {}
{
    SideEffect::Initialize (VECTOR, 1);
    size = vsize;
    Word   *wp = element;
    int	    work = (vsize / 32) + ((vsize % 32) > 0 ? 1 : 0);
    while (vsize-- > 0)
	*wp++ = init;
    while (work-- > 0)
	*wp++ = 0;
}

void
VectorObject::Initialize (int vsize, Word * block)
    // {}
    // ٥֥ȤνǤ block ˽롣
    // {}
{
    SideEffect::Initialize (VECTOR, 1);
    size = vsize;
    int	    work = (vsize / 32) + ((vsize % 32) > 0 ? 1 : 0);
    Word   *wp = element;
    while (vsize-- > 0)
	*wp++ = *block++;
    while (work-- > 0)
	*wp++ = *block++;
}

char
VectorObject::GetMode (int index)
    // {}
    // ٥֥Ȥ index ܤǤĴ٤롥
    //  `i'֤Ǥʤ `o' ֤
    // {}
{
    return IsInlet (index) ? 'i' : 'o';
}

Boolean
VectorObject::IsInlet (int index)
    // {}
    // ٥֥Ȥ index ܤǤɤĴ٤롥
    // ʤ TRUE ֤Ǥʤ FALSE ֤
    // {}
{
    if (index < 0 || index >= size) {
	error (form ("vector index is %d", index), OUT_OF_INDEX_RANGE);
	index = 0;
    }
    Word    x = element[size + (index / 32)];
    return ((x >> (index % 32)) & 1) != 0 ? TRUE : FALSE;
}

Word
VectorObject::GetElement (int index)
    // {}
    // ٥֥Ȥ index ܤǤ֤ǤΥǥե
    // 󥹤ϹԤʤʤ
    // {}
{
    if (index < 0 || index >= size)
	error ("get_vector_element",
	       "index %d out of range [max is %d]",index,size);
    return element[index];
}

void
VectorObject::SetElement (int index, Word x, char mode)
    // {}
    // ٥֥Ȥ index ܤǤ x ˤ롣
    // {}
{
    if (index < 0 || index >= size)
	error (form ("set_vector_element", print (x), index),
	       "index %d out of range [max is %d]",index,size);
    element[index] = x;

    unsigned *work = (unsigned *) &element[size + (index / 32)];
    unsigned bitmask = 1 << (index % 32);
    if (mode == 'i')
	*work = ((*work & bitmask) != 0) ? *work : (*work ^ bitmask);
    else
	*work = ((*work & bitmask) == 0) ? *work : (*work ^ bitmask);
}

void
VectorObject::Wait_for_set_index (const ProtocolID& pid, Word index, Word value)
    // {}
    // ٥ Index ΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤå٥αꥹȤ˷
    // 롥ǸˡIndex  who åꡤԤĤ
    // ֥Ȥˤ롥
    // {}
{
    doSplit (index);

    Message* lm = CreateMessage (pid, index, value);

    ConnectionWait (lm);

    Word wait_object = Create_wait_vector_index_object (this);

    Word answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));
}

Word
VectorObject::Wait_for_elt_index (const ProtocolID& pid, Word index)
    // {}
    // ٥ Index ΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤå٥αꥹȤ˷
    // 롥ǸˡIndex  who åꡤԤĤ
    // ֥Ȥˤ롥
    // {}
{
    doSplit (index);
    Word value = new_Merger (2);

    Message* lm = CreateMessage (pid, index, value);

    ConnectionWait (lm);

    Word wait_object = Create_wait_vector_index_object (this);

    Word answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));

    return value;
}

Word
VectorObject::Wait_for_subseq_position (Word index, Word a0, Word a1)
    // {}
    // ٥ Index ΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤå٥αꥹȤ˷
    // 롥ǸˡIndex  who åꡤԤĤ
    // ֥Ȥˤ롥
    // {}
{
    doSplit (a0);
    doSplit (a1);
    Word value = new_Merger (2);

    Message* lm = CreateMessage (PID_SUBSEQ, a0, a1, value);

    ConnectionWait (lm);

    Word wait_object = Create_wait_vector_index_object (this);

    Word answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));

    return value;
}

Word
VectorObject::Subseq (Word y, Word z)
    // {}
    // ٥ʬڤФ٥롥
    // {}
{
    int begin = Fix2Int (y);
    int end   = Fix2Int (z);

    if (!Subseq_valid_position (ObjectWord(this), begin, end, size))
	return INT0;

    int len = end - begin;
    Word to = CreateVector (len, UNDEFOUTLET);

    for (int n = 0; n < len; n++) {
	int from = begin + n;
	Word x = GetElement (from);
	if (IsInlet (from)) {
	    SetElement (from, UNDEFINLET, 'i');
	    VectorObject_ptr (to)->SetElement (n, x, 'i');
	}
	else {
	    x = Dereference (x);
	    doSplit (x);
	    VectorObject_ptr (to)->SetElement (n, x, 'o');
	}
    }
    return to;
}

void
VectorObject::Close ()
    // {}
    // ٥γǤĺ롥
    // {}
{
    for (int i = 0; i < size; i++) {
	Word x = element[i];
	if (IsInlet (i)) {
	    if (!IsUndefInlet (x)) {
		Word t = ERROROBJECT;
		doConnect (t, J_NC_ptr (x));
	    }
	}
	else {
	    if (!IsUndefOutlet (x)) {
		if (PElog)
		    pelog("Close: %s", print (x));
		doClose (x);
	    }
	}
    }
}

void
VectorObject::Free ()
    // {}
    // ٥֥Ȥΰ롣
    // {}
{
    SHARED_FREE (this, nbytes);
}

Name
VectorObject::Print ()
    // {}
    // ٥֥Ȥΰ᡼ʸȤ֤
    // {}
{
    char    buff[BUFSIZ];
    tstream tout = tstream (BUFSIZ, buff);
    if (ShowRC) {
	u_short rc = LRC ();
	tout.form ("%d_%x", rc, this);
    }
    tout.form ("{");
    if (!TraceStream->TooDeep ()) {
	TraceStream->Enter ();
	for (int i = 0; i < size; i++) {
	    if (GetMode (i) == 'i')
		tout.form ("^");
	    tout << print (element[i]);
	    if (i + 1 < size) {
		tout.form (",");
	    }
	}
	TraceStream->Exit ();
    }
    else
	tout.form("...");
    tout.form ("}");
    return tout.Result ();
}

Word
VectorObject::Copy ()
    // {}
    // ʬȤʣ̤
    // {}
{
    VectorObject* vp = new_Vector (size);
    memcpy (vp, this, nbytes);
    return ObjectWord (vp);
}

Word
CreateVector (int vsize, Word init)
    // {}
    // ٥֥Ȥ롥
    // {}
{
    VectorObject *xv = new_Vector (vsize);
    xv->Initialize (vsize, init);
    return ObjectWord (xv);
}

Word
CreateVector (int vsize, Word * block)
    // {}
    // ٥֥Ȥ롥
    // {}
{
    VectorObject *xv = new_Vector (vsize);
    xv->Initialize (vsize, block);
    return ObjectWord (xv);
}

void
PrintVector (Word x)
    // {}
    // ٥֥ȤϤ롣
    // {}
{
    VectorObject *vp = (VectorObject *) Pointer (x);
    cout << vp->Print ();
    return;
}

int
CompareVector (Word x, Word y)
    // {}
    // ٥֥ȤӤ򤹤롥
    // {}
{
    VectorObject *vx = (VectorObject *) Pointer (x);
    VectorObject *vy = (VectorObject *) Pointer (y);
    if (vx != vy)
	return 1;		// ɥ쥹
    return 0;
}

Name
VectorPrintImage (Word x)
    // {}
    // ٥֥ȤΰɽʸȤ֤
    // {}
{
    VectorObject *vx = (VectorObject *) Pointer (x);
    return vx->Print ();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
