/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/stdlib.h"
#include "aum/string.h"
#include "aum/list.h"
#include "aum/vector.h"
#include "aum/fetch.h"
#include "builtin/extern.h"

static void
errmsg_subseq_must_be_integer (Word x, Word y, Word z)
{
    error (form ("%s:subseq(%s,%s,^W)",
		 print (x), print (y), print (z)),
	   "%s and %s must be integer",print (y),print (z));
}

Word
doSubseqList (Word ax, Word ay, Word az)
{
    Word y = Dereference (ay);
    if (IsFixnum (y)) {
	Word z = Dereference (az);
	if (IsFixnum (z))
	    return ListObject_ptr (ax)->Subseq (y, z);
	else if (IsUndefined (z))
	    return ListObject_ptr (ax)->Wait_for_subseq_position (z, y, z);
    }
    else if (IsUndefined (y))
	return ListObject_ptr (ax)->Wait_for_subseq_position (y, y, az);
    errmsg_subseq_must_be_integer (ax, ay, az);
    return INT0;
}

Word
doSubseqVector (Word ax, Word ay, Word az)
{
    Word y = Dereference (ay);
    if (IsFixnum (y)) {
	Word z = Dereference (az);
	if (IsFixnum (z))
	    return VectorObject_ptr (ax)->Subseq (y, z);
	else if (IsUndefined (z))
	    return VectorObject_ptr (ax)->Wait_for_subseq_position (z, y, z);
    }
    else if (IsUndefined (y))
	return VectorObject_ptr (ax)->Wait_for_subseq_position (y, y, az);
    errmsg_subseq_must_be_integer (ax, ay, az);
    return INT0;
}

Word
doSubseqString (Word ax, Word ay, Word az)
{
    Word y = Dereference (ay);
    if (IsFixnum (y)) {
	Word z = Dereference (az);
	if (IsFixnum (z)) {
	    if (IsASCII_StrObject (ax))
		return ASCII_StrObject_ptr (ax)->Subseq (y, z);
	    else
		return EUC_StrObject_ptr (ax)->Subseq (y, z);
	}
	else if (IsUndefined (z)) {
	    if (IsASCII_StrObject (ax))
		return ASCII_StrObject_ptr (ax)->Wait_for_subseq_position (z, y, z);
	    else
		return EUC_StrObject_ptr (ax)->Wait_for_subseq_position (z, y, z);
	}
    }
    else if (IsUndefined (y)) {
	if (IsASCII_StrObject (ax))
	    return ASCII_StrObject_ptr (ax)->Wait_for_subseq_position (y, y, az);
	else
	    return EUC_StrObject_ptr (ax)->Wait_for_subseq_position (y, y, az);
    }
    errmsg_subseq_must_be_integer (ax, ay, az);
    return INT0;
}

Word
doSubSeq (Word ax, Word ay, Word az)
    // {} @ METHOD BEGIN
    // {} @ CLASS     sequence
    // {} @ NOTATION  X:subseq(Y,Z,^S)
    // {} @ EXPLANATION
    // XʸޤʤYܤZܤޤǤʬ
    // ʤƱΥ֥ȤȤȥ꡼S³롥
    //
    // YZǤʤƤϤʤʤ餬̤³Υȥ꡼
    // 粿³ޤԤġ
    //
    // YZȤXʸʤ @samp{""}, ٥ʤ
    // @samp{@{@}} ȥ꡼ S ³롥
    // աʤХå֥ȤⰷϤǤ뤬
    // ϤǤϿåݤ¤뤿ʤ
    // 롥Ūˤ @code{subseq} ǥåⰷ褦ˤʤ롥
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    Word s;
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	    /* s = doSubseqList (x, ay, az); */
	    goto error_occurred;
	    break;

	case VECTOR:
	    s = doSubseqVector (x, ay, az);
	    break;

	case ASCII_STR:
	case EUC_STR:
	    s = doSubseqString (x, ay, az);
	    break;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    s = SendBuiltinMessage3 (x, PID_SUBSEQ, ay, az);
	    break;

	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	    /* s = ListObject_ptr (x)->Suspended_by_elt_index (PID_SUBSEQ, ay, az); */
	    goto error_occurred;
	    break;

	case WC_VECTOR:
	    s = VectorObject_ptr (x)->Suspended_by_elt_index (PID_SUBSEQ, ay, az);
	    break;

	case WC_ASCII_STR:
	    s = ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_SUBSEQ, ay, az);
	    break;

	case WC_EUC_STR:
	    s = EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_SUBSEQ, ay, az);
	    break;

	default:
	    goto error_occurred;
	}
    }
    else if (IsSink (x)) {
	s = SINKOBJ;
    }
    else {
    error_occurred:
	error (form ("%s:subseq(%s,%s,^W)", print (x), print (ay), print (az)),
	       CAN_NOT_FIND_METHOD,"subseq/++-");
	return INT0;
    }
    doClose (ay);
    doClose (az);
    return s;
}

METHOD (subseq, R4_OP)
    // {}
    // subseq Ri, Rj, Rk, Rresult
    // {}
    // [	   address ]
    // [  Rx|  Ry|  Rz|	 Rr]
    // {}
    //   Ri  Rj ܤ Rk ܤޤǤʬ Rresult ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b3] = doSubSeq (x, Reg[ip->b1], Reg[ip->b2]);
    doClose (x);
    JumpNextInstruction ();
}

Boolean
Subseq_valid_position (Word x, int begin, int end, int length)
    // {}
    // ڤФ֤ȽǤ롥begn == end 
    // NULL OBJECT Ȥʤ롥椨 end == length 㤨Ĺ
    // 10 ǺǸǤȤˤ subseq(9,10,^S) Ȥʤ롥
    // {}
{
    const char* fmt = "%s :subseq(%d,%d,^W) [length=%d]";
    if (begin < 0) {
	error (form (fmt, print (x), begin, end, length),
	       "%d is a negative value",begin);
	return FALSE;
    }
    if (end > length) {
	error (form (fmt, print (x), begin, end, length),
	       "%d is out of range",end);
	return FALSE;
    }
    if (begin > end) {
	error (form (fmt, print (x), begin, end, length),
	       "A beginning position is larger than an ending position");
	return FALSE;
    }
    return TRUE;
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
