/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdio.h>
#include "aum/string.h"
#include "aum/fetch.h"
#include "builtin/extern.h"

Word
doString (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS symbol bool number
    // {} @ NOTATION X:string(^Y)
    // {} @ EXPLANATION
    // X ܥ, ͤޤϿʤСΰ᡼ʸ
    // ȥ꡼Y³롥
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    char    tem[128];
    if (IsUndefined (x))
	return SendBuiltinMessage1 (x, PID_STRING);
    if (IsEUC_StrObject (x) || IsASCII_StrObject (x)) {
	doSplit (x);
	return x;
    }
    if (IsAtom (x)) {
	return CreateASCIIString ((char *) print (x));
    }
    if (IsFixnum (x)) {
	int	n = Fix2Int (x);
	sprintf (tem, "%d", n);
	return CreateASCIIString (tem);
    }
    if (IsBool (x)) {
	sprintf (tem, "%s", print (x));
	return CreateASCIIString (tem);
    }
    if (IsSFloat (x)) {
	float	f = Single2float (x);
	sprintf (tem, "%g", f);
	return CreateASCIIString (tem);
    }
    if (IsDFloat (x)) {
	double	f = Double2double (x);
	sprintf (tem, "%g", f);
	return CreateASCIIString (tem);
    }
    error (form("%s:string(^Y)",print(x)),
	   CAN_NOT_FIND_METHOD,"string/-");
    return INT0;
}

METHOD (string, R2_OP)
    // {}
    // string Ri, Rj
    // {}
    // ǽʤ Ri ʸˤ Rj ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doString (x);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
