/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include <ctype.h>
#include <math.h>
#include "aum/error.h"
#include "aum/string.h"
#include "aum/tstream.h"
#include "aum/alloc.h"
#include "aum/trace.h"
#include "aum/wait.h"
#include "aum/who.h"
#include "utils/utils.h"
#include "mathematics/ext-conv.h"
#include "builtin/extern.h"

extern char *jis_to_euc (const char *);

inline int
EUC_StrObject::index (u_short v)
{
    u_short *work = body;
    for (int ret = 0; ret < nchars; ret++, work++) {
	if (*work == v)
	    return ret;
    }
    return -1;
}

int
etoi (EUC_StrObject * str)
{
    u_short euc;
    char    asc;
    int	    length = str->no_of_chars ();
    int	    count = 0;
    int	    ret = 0;
    int	    sign = 1;
front:
    if (count >= length)
	return ret;
    euc = Fix2Int (str->Element (count));
    switch (euc) {
    case ZERO:
	return 0;
    case SPACE:
	count++;
	goto front;
	break;
    case MINUS:
	sign = -1;
	count++;
	goto loop;
	break;
    case PLUS:
	goto loop;
	break;
    default:
	if ((euc > ZERO) && (euc <= NINE)) {
	    goto loop;
	}
	break;
    }
    if (((euc >> 8) & 0xff) == 0x00) {
	asc = (char) (euc & 0xff);
	switch (asc) {
	case '0':
	    return 0;
	case ' ':
	case '\t':
	    count++;
	    goto front;
	    break;
	case '-':
	    sign = -1;
	    count++;
	    goto loop;
	    break;
	case '+':
	    count++;
	    goto loop;
	    break;
	default:
	    if ((euc > (u_short) '0') && (euc <= (u_short) '9')) {
		goto loop;
	    }
	    break;
	}
    }
    error (form ("euc-to-int %s ", str->Print ()),
	   "Invalid letter ");
    return 0;
loop:
    if (count >= length)
	return ret * sign;
    euc = Fix2Int (str->Element (count));
    if ((euc >= ZERO) && (euc <= NINE)) {
	ret = (ret * 10 + euc - ZERO);
	count++;
	goto loop;
    }
    if ((euc >= (u_short) '0') && (euc <= (u_short) '9')) {
	ret = (ret * 10 + euc - '0');
	count++;
	goto loop;
    }
    return ret * sign;
}

double
etof (EUC_StrObject * str)
{
    u_short euc;
    char    asc;
    int	    length = str->no_of_chars ();
    int	    count = 0;
    double  ret = 0;
    double  sign = 1;
    double  esign = 1;
    double  point = 0.1;
    int	    exp;
front:
    if (count >= length)
	return ret;
    euc = Fix2Int (str->Element (count));
    switch (euc) {
    case SPACE:
	count++;
	goto front;
	break;
    case MINUS:
	sign = -1;
	count++;
	goto loop;
	break;
    case PLUS:
	count++;
	goto loop;
	break;
    default:
	if ((euc >= ZERO) && (euc <= NINE)) {
	    goto loop;
	}
	break;
    }
    if (((euc >> 8) & 0xff) == 0x00) {
	asc = (char) (euc & 0xff);
	switch (asc) {
	case ' ':
	case '\t':
	    count++;
	    goto front;
	    break;
	case '-':
	    sign = -1;
	    count++;
	    goto loop;
	    break;
	case '+':
	    count++;
	    goto loop;
	    break;
	default:
	    if ((euc >= (u_short) '0') && (euc <= (u_short) '9')) {
		goto loop;
	    }
	    break;
	}
    }
    error (form ("euc-to-int %s ", (char *) str->Print ()),
	   "Invalid letter ");
    return 0;
loop:
    if (count >= length)
	return ret * sign;
    euc = Fix2Int (str->Element (count));
    if ((euc >= ZERO) && (euc <= NINE)) {
	ret = (ret * 10 + euc - ZERO);
	count++;
	goto loop;
    }
    if ((euc >= (u_short) '0') && (euc <= (u_short) '9')) {
	ret = (ret * 10 + euc - '0');
	count++;
	goto loop;
    }
    if ((euc == POINT) || (euc == (u_short) '.')) {
	count++;
	goto loop2;
    }
    return ret * sign;;
loop2:
    if (count >= length)
	return ret * sign;
    euc = Fix2Int (str->Element (count));
    if ((euc >= ZERO) && (euc <= NINE)) {
	ret = (ret + (euc - ZERO) * point);
	point /= 10;
	count++;
	goto loop2;
    }
    if ((euc >= (u_short) '0') && (euc <= (u_short) '9')) {
	ret = (ret + (euc - '0') * point);
	point /= 10;
	count++;
	goto loop2;
    }
    if ((euc == LBASE) || (euc == SBASE)) {
	count++;
	exp = 0;
	goto loop3;
    }
    return ret * sign;
loop3:
    if (count >= length)
	return ret * sign * pow (10, (double) (esign * exp));
    euc = Fix2Int (str->Element (count));
    if ((euc == PLUS) || (euc == (u_short) '+')) {
	count++;
	goto loop4;
    }
    if ((euc == MINUS) || (euc == (u_short) '-')) {
	esign = -1;
	count++;
	goto loop4;
    }
    return ret * sign * pow (10, (double) (esign * exp));
loop4:
    if (count >= length)
	return ret * sign * pow (10, (double) (esign * exp));
    euc = Fix2Int (str->Element (count));
    if ((euc >= ZERO) && (euc <= NINE)) {
	exp = exp * 10 + (euc - ZERO);
	count++;
	goto loop4;
    }
    if ((euc >= (u_short) '0') && (euc <= (u_short) '9')) {
	exp = exp * 10 + (euc - (u_short) '0');
	count++;
	goto loop4;
    }
    if ((euc == FLARGE) || (euc == FSMALL))
	return ret * sign * pow (10, (double) (esign * exp));
    if ((euc == (u_short) 'F') || (euc == (u_short) 'f'))
	return ret * sign * pow (10, (double) (esign * exp));
    return ret * sign * pow (10, (double) (esign * exp));
}

Word
EUC2Double (EUC_StrObject * x)
    // {}
    // ʸ󥪥֥Ȥư֥ȤѴ롥
    // {}
{
    return CreateDFloat (etof (x));
}

Word
EUC2Single (EUC_StrObject * x)
    // {}
    // ʸ󥪥֥Ȥñư֥ȤѴ롥
    // {}
{
    return float2Single ((float) etof (x));
}

Word
EUC2Fix (EUC_StrObject * x)
    // {}
    // ʸ󥪥֥Ȥ֥ȤѴ롥
    // {}
{
    return Int2Fix (etoi (x));
}

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//

void
EUC_StrObject::Initialize (int nb, int nc)
    // {}
    // ȥ󥰡֥Ȥ롥
    // {}
{
    SideEffect::Initialize (EUC_STR, 1);
    nchars = nc;
    nbytes = nb;
}

void
EUC_StrObject::Initialize (const u_char * string, Length len)
    // {}
    // ȥ󥰡֥Ȥ롥
    // {}
{
    int	    n = roundup (roundup (len, sizeof (u_short)), sizeof (Word)) * sizeof (u_short) + sizeof_EUC_StrObject;
    EUC_StrObject::Initialize (n, len);

    register const u_char *s = string;
    for (n = 0; n < nchars; n++) {
	if (IsEUC (*s)) {
	    body[n] = ((((u_short) s[0]) & 0xFF) << 8) + (((u_short) s[1]) & 0xFF);
	    s += 2;
	}
	else {
	    body[n] = (u_short) * s++;
	}
    }
}

Word
EUC_StrObject::Element (int index)
    // {}
    // ȥ󥰡֥Ȥ index ܤǤ֤
    // {}
{
    if (index >= nchars) {
	error (form ("%s :elt(%d,^Z)", this->Print (), index),
	       "index %d is out of range [max is %d]",index ,nchars -1);
	return INT0;
    }
    return Int2Fix (body[index]);
}

void
EUC_StrObject::Element (int index, Word x)
    // {}
    // ȥ󥰡֥Ȥ index ܤǤ x ˤ롥
    // {}
{
    int c = Fix2Int (x);
    if (index >= max_of_chars ()) {
	error (form ("%s :set(%d,&%c)", this->Print (), index, c),
	       "index %d is out of range [max is %d]",index ,nchars -1);
    }
    body[index] = c;
    if (index > nchars)
	nchars = index;
}

void
EUC_StrObject::Wait_for_set_index (const ProtocolID& pid, Word index, Word value)
    // {}
    // ʸ Index ꤹΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤå٥裰Ǥ˷
    // 롥ʸ裰(4bytes)ԤĤΥ֥ȤΥ
    // Ȥ¸ƤǸˡIndex  who åꡤ
    // ԤĤΥ֥Ȥˤ롥
    // {}
{
    doSplit (index);

    Message* lm = CreateMessage (pid, index, value);

    ConnectionWait (lm);

    Word wait_object = Create_wait_string_index_object (this);

    Word answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));
}

Word
EUC_StrObject::Wait_for_elt_index (const ProtocolID& pid, Word index)
    // {}
    // ʸ Index ꤹΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤåʸ裰Ǥ˷
    // 롥ʸ裰ǤԤĤΥ֥ȤΥåȤ¸
    // ƤǸˡIndex  who åꡤԤĤ
    // Υ֥Ȥˤ롥
    // {}
{
    doSplit (index);
    Word value = new_Merger (2);

    Message* lm = CreateMessage (pid, index, value);

    ConnectionWait (lm);

    Word wait_object = Create_wait_string_index_object (this);

    Word answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));

    return value;
}

Word
EUC_StrObject::Wait_for_subseq_position (Word index, Word a0, Word a1)
    // {}
    // ʸ Index ꤹΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤåʸ裰Ǥ˷
    // 롥ʸ裰ǤԤĤΥ֥ȤΥåȤ¸
    // ƤǸˡIndex  who åꡤԤĤ
    // Υ֥Ȥˤ롥
    // {}
{
    doSplit (a0);
    doSplit (a1);
    Word value = new_Merger (2);

    Message* lm = CreateMessage (PID_SUBSEQ, a0, a1, value);

    ConnectionWait (lm);

    Word wait_object = Create_wait_string_index_object (this);

    Word answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));

    return value;
}

Word
EUC_StrObject::Subseq (Word y, Word z)
    // {}
    // ʸʬڤФʸ롥
    // {}
{
    int begin = Fix2Int (y);
    int end   = Fix2Int (z);

    if (!Subseq_valid_position (ObjectWord(this), begin, end, no_of_chars ()))
	return INT0;

    int len = end - begin;
    EUC_StrObject* s = new_EUCString (len);
    for (int n = 0; n < len; n++) {
	s->body[n] = body[begin + n];
    }
    return ObjectWord (s);
}

Word
EUC_StrObject::Prepend (Word as)
    // {}
    // ʸϢ뤹롥
    // {}
{
    if (IsASCII_StrObject (as)) {
	int len = ASCII_StrObject_ptr (as)->nchars + nchars;
	EUC_StrObject* ns = new_EUCString (len);
	int n = ns->no_of_bytes();
	ns->Initialize (n, len);
	int from;
	int to = 0;
	for (from = 0; from < ASCII_StrObject_ptr (as)->nchars; from++)
	    ns->body[to++] = ASCII_StrObject_ptr (as)->body[from];
	for (from = 0; from < nchars; from++)
	    ns->body[to++] = body[from];
	return ObjectWord (ns);
    }
    else if (IsEUC_StrObject (as)) {
	int len = EUC_StrObject_ptr (as)->nchars + nchars;
	EUC_StrObject* ns = new_EUCString (len);
	int n = ns->no_of_bytes();
	ns->Initialize (n, len);
	int from;
	int to = 0;
	for (from = 0; from < EUC_StrObject_ptr (as)->nchars; from++)
	    ns->body[to++] = EUC_StrObject_ptr (as)->body[from];
	for (from = 0; from < nchars; from++)
	    ns->body[to++] = body[from];
	return ObjectWord (ns);
    }
    abort ();
    return INT0;
}

void
EUC_StrObject::Fill (u_short fill)
    // {}
    // ʸƤ fill ˤ롥
    // {}
{
    for (int n = 0; n < nchars; n++)
	body[n] = fill;
}

Name
EUC_StrObject::Print ()
    // {}
    // ȥ󥰡֥Ȥΰ᡼ʸȤ֤
    // {}
{
    char    buff[BUFSIZ];
    tstream tout = tstream (BUFSIZ, buff);
    u_short *work = body;
    tout.flush ();
    if (ShowRC) {
	u_short rc = LRC ();
	tout.form ("%d_%x", rc, this);
    }
    if (String_quote_p)
	tout.form ("\"");
    for (int n = 0; n < nchars; n++, work++) {
	if (*work == (u_short) 0)
	    break;
	u_char	c1 = (*work >> 8) & 0xFF;
	u_char	c2 = *work & 0xFF;
	if (c1)
	    tout.put (c1);
	tout.put (c2);
    }
    if (String_quote_p)
	tout.form ("\"");
    return tout.Result ();
}

Name
EUC_StrObject::Print (Boolean quote)
    // {}
    // ȥ󥰡֥Ȥΰ᡼ʸȤ֤
    // {}
{
    char    buff[BUFSIZ];
    tstream tout = tstream (BUFSIZ, buff);
    {
	Boolean save = String_quote_p;
	String_quote_p = quote;
	Boolean showrc = ShowRC;
	ShowRC = FALSE;
	const char* s = Print ();
	String_quote_p = save;
	ShowRC = showrc;
	tout.form (s);
    }
    return tout.Result ();
}

char   *
EUC_StrObject::new_C_string ()
    // {}
    // ΰݤơȥ󥰡֥Ȥΰ᡼
    // ʸȤ֤
    // {}
{
    int	    len = nchars * sizeof (u_short);
    char   *to = SHARED_ALLOC (len + 1);
    int	    i;
    int	    j;
    for (i = j = 0; j < nchars; j++) {
	u_short x = body[j];
	u_char	c1 = (x >> 8) & 0xFF;
	u_char	c2 = x & 0xFF;
	if (c1)
	    to[i++] = c1;
	to[i++] = c2;
    }
    to[i] = '\0';
    return to;
}

EUC_StrObject *
new_EUCString (int len)
    // {}
    // ʸĹ len Ǥʸΰݤ롥ʸǤϽ
    // ʤĹ 0 λˤ礭򾯤ʤȤ⣱ˤʤ褦
    // 롥 WC_EUC_STR ΤǤ롥
    // {}
{
    int m = (len == 0) ? 1 : len;
    int	    nchars = roundup (m, sizeof (u_short));
    int	    nbytes = roundup (nchars, sizeof (Word)) * sizeof (u_short) + sizeof_EUC_StrObject;

    assert (0 <= nbytes && nbytes < MAX_STRING_BYTES);
    EUC_StrObject *sx = (EUC_StrObject *) SHARED_ALLOC (nbytes);
    sx->Initialize (nbytes, nchars);
    return sx;
}

Word
CopyEUCString (Word mold)
    // {}
    // ȥ󥰡֥Ȥʣ̤롥
    // {}
{
    EUC_StrObject *sx = EUC_StrObject_ptr (mold);
    EUC_StrObject *sy = new_EUCString (sx->no_of_chars ());
    sy->Copyfrom (sx);
    sy->LRC () = 1;
    return ObjectWord (sy);
}

Word
CreateEUCString (const u_char * string)
    // {}
    // ȥ󥰡֥Ȥ롥
    // {}
{
    Length  len = jstrlen (string);
    EUC_StrObject *sx = new_EUCString (len);
    sx->Initialize (string, len);
    return ObjectWord (sx);
}

Word
CreateEUCString (int fill, int len)
{
    if (len < 0)
	error ("create_string", "Illegal string length");
    EUC_StrObject *sx = new_EUCString (len);
    int n = sx->no_of_bytes();
    sx->Initialize (n, len);
    sx->Fill (fill);
    return ObjectWord (sx);
}

void
PrintEUCString (Word x)
    // {}
    // ȥ󥰡֥ȤϤ롣
    // {}
{
    EUC_StrObject *sx = EUC_StrObject_ptr (x);
    cout << sx->Print ();
    return;
}

int
CompareEUCString (Word x, Word y)
    // {}
    // ȥ󥰡֥ȤӤ򤹤롥
    // {}
{
    EUC_StrObject *sx = EUC_StrObject_ptr (x);
    EUC_StrObject *sy = EUC_StrObject_ptr (y);
    if (sx != sy)
	return 1;
    return 0;
}

Name
EUCStringPrintImage (Word x)
    // {}
    // ȥ󥰡֥ȤΰɽʸȤ֤
    // {}
{
    EUC_StrObject *sx = EUC_StrObject_ptr (x);
    return sx->Print ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
