/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include <ctype.h>
#include <math.h>
#include "aum/error.h"
#include "aum/string.h"
#include "aum/tstream.h"
#include "aum/alloc.h"
#include "aum/trace.h"
#include "aum/wait.h"
#include "aum/who.h"
#include "mathematics/ext-conv.h"
#include "builtin/extern.h"

extern	"C" {
    int	    atoi (const char *);
    double  atof (const char *);
};

void
StringObject::Free ()
    // {}
    // ʸ󥪥֥Ȥΰ롥
    // {}
{
    SHARED_FREE (this, nbytes);
}

Word
ASCII2Double (ASCII_StrObject * x)
    // {}
    // ʸ󥪥֥Ȥư֥ȤѴ롥
    // {}
{
    double  d;
    char   *image = (char *) x->Print (FALSE);
    d = atof (image);
    return CreateDFloat (d);
}

Word
ASCII2Single (ASCII_StrObject * x)
    // {}
    // ʸ󥪥֥Ȥñư֥ȤѴ롥
    // {}
{
    float   f;
    char   *image = (char *) x->Print (FALSE);
    f = (float) atof (image);
    return float2Single (f);
}

Word
ASCII2Fix (ASCII_StrObject * x)
    // {}
    // ʸ󥪥֥Ȥ֥ȤѴ롥
    // {}
{
    int	    i;
    char   *image = (char *) x->Print (FALSE);
    i = atoi (image);
    return Int2Fix (i);
}

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//

void
ASCII_StrObject::Initialize (int nb, int nc)
    // {}
    // ȥ󥰡֥Ȥ롥
    // {}
{
    SideEffect::Initialize (ASCII_STR, 1);
    nbytes = nb;
    nchars = nc;
}

void
ASCII_StrObject::Initialize (const char *string, Length len)
    // {}
    // ȥ󥰡֥Ȥ롥
    // {}
{
    int	    n = roundup (len, sizeof (Word)) + sizeof_ASCII_StrObject;
    ASCII_StrObject::Initialize (n, len);
    for (n = 0; n < nchars; n++)
	body[n] = *string++;
}

Word
ASCII_StrObject::Element (int index)
    // {}
    // ȥ󥰡֥Ȥ index ܤǤ֤
    // {}
{
    if (index >= nchars) {
	fatal ("get_string_element",
		      "index %d is out of range [max is %d]", index, nchars - 1);
	return INT0;
    }
    return Int2Fix (body[index]);
}

void
ASCII_StrObject::Element (int index, Word x)
    // {}
    // ȥ󥰡֥Ȥ index ܤǤ x ˤ롥
    // {}
{
    int c = Fix2Int (x);
    if (c < 0 || c > 0xFF) {
	fatal ("set_string_element",
		      "'%d' is not in ASCII character set");
    }
    if (index >= nchars) {
	fatal ("set_string_element",
		      "index %d is out of range [max is %d]", index, nchars - 1);
    }
    body[index] = c;
}

void
ASCII_StrObject::Wait_for_set_index (const ProtocolID& pid, Word index, Word value)
    // {}
    // ʸ Index ΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤå٥αꥹȤ˷
    // 롥ǸˡIndex  who åꡤԤĤ
    // ֥Ȥˤ롥
    // {}
{
    doSplit (index);

    Message* lm = CreateMessage (pid, index, value);

    ConnectionWait (lm);

    Word wait_object = Create_wait_string_index_object (this);

    Word answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));
}

Word
ASCII_StrObject::Wait_for_elt_index (const ProtocolID& pid, Word index)
    // {}
    // ʸ Index ΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤåʸαꥹȤ˷
    // 롥ǸˡIndex  who åꡤԤĤ
    // ֥Ȥˤ롥
    // {}
{
    doSplit (index);
    Word value = new_Merger (2);

    Message* lm = CreateMessage (pid, index, value);

    ConnectionWait (lm);

    Word wait_object = Create_wait_string_index_object (this);

    Word answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));

    return value;
}

Word
ASCII_StrObject::Wait_for_subseq_position (Word index, Word a0, Word a1)
    // {}
    // ʸ Index ꤹΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤåʸαꥹȤ
    // Ҥ롥ǸˡIndex  who åꡤԤĤ
    // Υ֥Ȥˤ롥
    // {}
{
    doSplit (a0);
    doSplit (a1);
    Word value = new_Merger (2);

    Message* lm = CreateMessage (PID_SUBSEQ, a0, a1, value);

    ConnectionWait (lm);

    Word wait_object = Create_wait_string_index_object (this);

    Word answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));

    return value;
}

Word
ASCII_StrObject::Subseq (Word y, Word z)
    // {}
    // ʸʬڤФʸ롥
    // {}
{
    int begin = Fix2Int (y);
    int end   = Fix2Int (z);

    if (!Subseq_valid_position (ObjectWord(this), begin, end, no_of_chars ()))
	return INT0;

    int len = end - begin;
    ASCII_StrObject* s = new_ASCIIString (len);
    for (int n = 0; n < len; n++) {
	s->body[n] = body[begin + n];
    }
    return ObjectWord (s);
}

Word
ASCII_StrObject::Prepend (Word as)
    // {}
    // ʸϢ뤹롥
    // {}
{
    if (IsASCII_StrObject (as)) {
	int len = ASCII_StrObject_ptr (as)->nchars + nchars;
	ASCII_StrObject* ns = new_ASCIIString (len);
	int from;
	int to = 0;
	for (from = 0; from < ASCII_StrObject_ptr (as)->nchars; from++)
	    ns->body[to++] = ASCII_StrObject_ptr (as)->body[from];
	for (from = 0; from < nchars; from++)
	    ns->body[to++] = body[from];
	return ObjectWord (ns);
    }
    else if (IsEUC_StrObject (as)) {
	int len = EUC_StrObject_ptr (as)->nchars + nchars;
	EUC_StrObject* ns = new_EUCString (len);
	int n = ns->no_of_bytes();
	ns->Initialize (n, len);
	int from;
	int to = 0;
	for (from = 0; from < EUC_StrObject_ptr (as)->nchars; from++)
	    ns->body[to++] = EUC_StrObject_ptr (as)->body[from];
	for (from = 0; from < nchars; from++)
	    ns->body[to++] = body[from];
	return ObjectWord (ns);
    }
    abort ();
    return INT0;
}

void
ASCII_StrObject::Fill (char fill)
    // {}
    // ʸƤ fill ˤ롥
    // {}
{
    for (int n = 0; n < nchars; n++)
	body[n] = fill;
}

Name
ASCII_StrObject::Print ()
    // {}
    // ȥ󥰡֥Ȥΰ᡼ʸȤ֤
    // {}
{
    char    buf[BUFSIZ];
    tstream tout = tstream (BUFSIZ, buf);
    if (ShowRC) {
	u_short rc = LRC ();
	tout.form ("%d_%x", rc, this);
    }
    if (String_quote_p)
	tout.form ("\"");
    for (int n = 0; n < nchars; n++) {
	unsigned char c = body[n];
	if (String_quote_p && !isprint (c))
	    tout.form ("\\%03o", c);
	else
	    tout.put (c);
    }
    if (String_quote_p)
	tout.form ("\"");
    return tout.Result ();
}

Name
ASCII_StrObject::Print (Boolean quote)
    // {}
    // ȥ󥰡֥Ȥΰ᡼ʸȤ֤
    // {}
{
    char    buf[BUFSIZ];
    tstream tout = tstream (BUFSIZ, buf);
    {
	Boolean save = String_quote_p;
	String_quote_p = quote;
	Boolean showrc = ShowRC;
	ShowRC = FALSE;
	const char* s = Print ();
	String_quote_p = save;
	ShowRC = showrc;
	tout.form (s);
    }
    return tout.Result ();
}

char   *
ASCII_StrObject::new_C_string ()
    // {}
    // ΰݤơȥ󥰡֥Ȥΰ᡼
    // ʸȤ֤
    // {}
{
    char   *to = SHARED_ALLOC (nchars + 1);
    int	    n;
    for (n = 0; n < nchars; n++)
	to[n] = body[n];
    to[n] = '\0';
    return to;
}

ASCII_StrObject *
new_ASCIIString (int len)
    // {}
    // ʸĹ len Ǥʸΰݤ롥ʸǤϽ
    // ʤĹ 0 λˤ礭򾯤ʤȤ⣱ˤʤ褦
    // 롥 WC_ASCII_STR ΤǤ롥
    // {}
{
    int m = (len == 0) ? 1 : len;
    int	    nbytes = roundup (m, sizeof (Word)) + sizeof_ASCII_StrObject;
    assert (0 <= nbytes && nbytes < MAX_STRING_BYTES);
    ASCII_StrObject *sx = (ASCII_StrObject *) SHARED_ALLOC (nbytes);
    sx->Initialize (nbytes, len);
    return sx;
}


Word
CopyASCIIString (Word mold)
    // {}
    // ȥ󥰡֥Ȥʣ̤롥
    // {}
{
    ASCII_StrObject *sx = ASCII_StrObject_ptr (mold);
    ASCII_StrObject *sy = new_ASCIIString (sx->no_of_chars ());
    sy->Copyfrom (sx);
    sy->LRC () = 1;
    return ObjectWord (sy);
}


Word
CreateASCIIString (const char *string)
    // {}
    // ȥ󥰡֥Ȥ롥
    // {}
{
    Length  len = strlen (string);
    ASCII_StrObject *sx = new_ASCIIString (len);
    sx->Initialize (string, len);
    return ObjectWord (sx);
}

Word
CreateASCIIString (int fill, int len)
{
    if (len < 0)
	error ("create_string", "Illegal string length");
    ASCII_StrObject *sx = new_ASCIIString (len);
    sx->Fill (fill);
    return ObjectWord (sx);
}

void
PrintASCIIString (Word x, Uint sz)
    // {}
    // ȥ󥰡֥ȤϤ롣
    // {}
{
    ASCII_StrObject *sx = ASCII_StrObject_ptr (x);
    cout << sx->Print ();
    return;
}

int
CompareASCIIString (Word x, Word y)
    // {}
    // ȥ󥰡֥ȤӤ򤹤롥
    // {}
{
    ASCII_StrObject *sx = ASCII_StrObject_ptr (x);
    ASCII_StrObject *sy = ASCII_StrObject_ptr (y);
    if (sx == sy)
	return 0;
    return 1;
}

Name
ASCIIStringPrintImage (Word x)
    // {}
    // ȥ󥰡֥ȤΰɽʸȤ֤
    // {}
{
    ASCII_StrObject *sx = ASCII_StrObject_ptr (x);
    return sx->Print ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
