/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <assert.h>
#include "aum/sideeffect.h"
#include "aum/messageq.h"
#include "aum/split.h"
#include "aum/error.h"

void
SideEffect::Initialize (ObjectTag t, int r)
    // {}
    // ɥեȤȹ֥Ȥ롥αꥹ
    //  NULL Ȥ롥
    // {}
{
    Header::Initialize (t, r);
    pendq = (MessageLink *)0;
}

void
SideEffect::AddSuspentionList (MessageLink *lm)
    // {}
    // αꥹȤ˥åɲä롥ɲð֤ƬǤꡤå
    // ϵս˷Ҥ롥
    // {}
{
    lm->nextMessage (pendq);
    pendq = lm;
}

Word
SideEffect::ConnectionReached ()
    // {}
    //  Index ꤷ˸ƤФ롥αꥹȤ˷ҤƤ
    // å򥸥祤Ȥ˷ҤƤޤȤ֤
    // {}
{
    UnsetWCTag ();
    Word mj = new_Merger (1);
    for (MessageLink* m = pendq; m; m = pendq) {
	pendq = m->nextMessage ();
	m->nextMessage (NULL);
	J_NC_ptr (mj)->PrependMessage (m);
    }
    assert (pendq == NULL);
    return mj;
}

void
SideEffect::ConnectionWait (MessageLink* lm)
    // {}
    //  Index ͤꤹޤԤľ֤ˤ롥Ȥܣ
    // αꥹȤ˥å lm Ĥʤ롥
    // {}
{
    assert (pendq == NULL);
    LRC_plus (1);
    pendq = lm;
    SetWCTag ();
}

void
SideEffect::Suspended_by_set_index (const ProtocolID& pid, Word idx, Word val)
    // {}
    // Index ꤹΤԤƤʸ˥åƤ顤
    // ΥåϤˤϼ¹ԤǤʤΤʸαꥹȤ˷
    // ƤҤ֤ϥåεդˤʤ
    // {}
{
    doSplit (idx);
    Message* lm = CreateMessage (pid, idx, val);
    AddSuspentionList (lm);
}

Word
SideEffect::Suspended_by_elt_index (const ProtocolID& pid)
    // {}
    // Index ꤹΤԤƤʸ˥åƤ顤
    // ΥåϤˤϼ¹ԤǤʤΤʸαꥹȤ˷
    // ƤҤ֤ϥåεդˤʤ
    // {}
{
    Word val = new_Merger (2);
    Message* lm = CreateMessage (pid, val);
    AddSuspentionList (lm);
    return val;
}

Word
SideEffect::Suspended_by_elt_index (const ProtocolID& pid, Word a0)
    // {}
    // Index ꤹΤԤƤʸ˥åƤ顤
    // ΥåϤˤϼ¹ԤǤʤΤʸαꥹȤ˷
    // ƤҤ֤ϥåεդˤʤ
    // {}
{
    doSplit (a0);
    Word val = new_Merger (2);
    Message* lm = CreateMessage (pid, a0, val);
    AddSuspentionList (lm);
    return val;
}

Word
SideEffect::Suspended_by_elt_index (const ProtocolID& pid, Word a0, Word a1)
    // {}
    // Index ꤹΤԤäƤʸ˥åƤ
    // 顤ΥåϤˤϼ¹ԤǤʤΤαꥹȤˤ˷Ҥ
    // ƤҤ֤ϥåεդˤʤ
    // {}
{
    doSplit (a0);
    doSplit (a1);
    Word val = new_Merger (2);
    Message* lm = CreateMessage (pid, a0, a1, val);
    AddSuspentionList (lm);
    return val;
}


/////////////////////////////////////////////////////////////////////
Boolean
IsWC_Object (Word x)
    // {}
    // {}
{
    if (IsObject (x))
	switch (Pointer (x)->oTag ()) {
	case WC_DFLOAT:
	case WC_MESSAGE_OBJ:
	case WC_ASCII_STR:
	case WC_EUC_STR:
	case WC_VECTOR:
	case WC_FILE_STREAM:
	case WC_LISToo:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISTii:
	    return TRUE;
	default:
	    break;
	}
    return FALSE;
}

void
SideEffect::SetWCTag ()
{
    switch (tag) {
    case DFLOAT:
	tag = WC_DFLOAT;
	break;
    case MESSAGE_OBJ:
	tag = WC_MESSAGE_OBJ;
	break;
    case ASCII_STR:
	tag = WC_ASCII_STR;
	break;
    case EUC_STR:
	tag = WC_EUC_STR;
	break;
    case VECTOR:
	tag = WC_VECTOR;
	break;
    case FILE_STREAM:
	tag = WC_FILE_STREAM;
	break;
    case LISToo:
	tag = WC_LISToo;
	break;
    case LISTio:
	tag = WC_LISTio;
	break;
    case LISToi:
	tag = WC_LISToi;
	break;
    case LISTii:
	tag = WC_LISTii;
	break;
    default:
	abort ();
    }
}

void
SideEffect::UnsetWCTag ()
{
    switch (tag) {
    case WC_DFLOAT:
	tag = DFLOAT;
	break;
    case WC_MESSAGE_OBJ:
	tag = MESSAGE_OBJ;
	break;
    case WC_ASCII_STR:
	tag = ASCII_STR;
	break;
    case WC_EUC_STR:
	tag = EUC_STR;
	break;
    case WC_VECTOR:
	tag = VECTOR;
	break;
    case WC_FILE_STREAM:
	tag = FILE_STREAM;
	break;
    case WC_LISToo:
	tag = LISToo;
	break;
    case WC_LISTio:
	tag = LISTio;
	break;
    case WC_LISToi:
	tag = LISToi;
	break;
    case WC_LISTii:
	tag = LISTii;
	break;
    default:
	abort ();
    }
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
