/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/protocolid.h"
#include "aum/list.h"
#include "aum/string.h"
#include "aum/vector.h"
#include "aum/msgobj.h"
#include "aum/builtin.h"
#include "builtin/extern.h"

extern void doSetCaro (Word, Word);

static const char *
setoform (const char* cn, Word x, Word y, Word z)
{
    return form ("%s :set(%s,%s) [%s]", print (x), print (y), print (z), cn);
}

static const char *
setoform (Word cn, Word x, Word y, Word z)
{
    return form ("%s :set(%s,%s) [%s]", print (x), print (y), print (z), print(cn));
}

static const char *
setoform (Word x, Word y, Word z)
{
    return form ("%s :set(%s,%s) ", print (x), print (y), print (z));
}

void
doSetoList (Word x, Word y, Word z)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	int	index = Fix2Int (y);
	if (index < 0) {
	    error (setoform (Classnamelist, x, y, z), OUT_OF_INDEX_RANGE);
	    return;
	}
	Word	list = doNthList (x, index);
	if (IsINT0 (list)) {
	    error (setoform (Classnamelist, x, y, z), OUT_OF_INDEX_RANGE);
	    return;
	}
	doSetCaro (list, z);
	return;
    }
    error (setoform (Classnamelist, x, y, z), INDEX_MUST_BE_INTEGER);
}

void
doSetoVector (Word x, Word y, Word z)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	VectorObject *source = (VectorObject *) Pointer (x);
	int	index = Fix2Int (y);
	int	vect_size = source->GetSize ();
	if (index < 0 || index >= vect_size) {
	    error (setoform (ClassNameVector, x, y, z), OUT_OF_INDEX_RANGE);
	    return;
	}

	Word	old = source->GetElement (index);
	if (IsObject (old)) {
	    char    mode = source->GetMode (index);
	    if (mode == 'o') {
		if (!IsUndefOutlet (old))
		    doClose (old);
	    }
	    else {
		if (!IsUndefInlet (old)) {
		    Word    sink = SINKOBJ;
		    doConnect (sink, J_NC_ptr (old));
		}
	    }
	}
	//  doSplit (z);
	source->SetElement (index, z, 'o');
	return;
    }
    if (IsUndefined (y)) {
	VectorObject_ptr (x)->Wait_for_set_index (PID_SET_O, y, z);
	return;
    }
    error (setoform (ClassNameVector, x, y, z), INDEX_MUST_BE_INTEGER);
}

void
Wait_for_seto_string_value (Word x, Word y, Word z)
{
    error (setoform (ClassNameString, x, y, z),
	   "%s is not connected. Sorry, not implemented yet.", print (z));
    abort ();
}

void
doSetoString (Word ax, Word ay, Word az)
    // {}
    // ʸξǤȤƥåȤƤ⡤ȲϤʤ
    // ᡤaz 򤳤ĺƤʤС祤ȤβǤ
    // doSeto () Ǥ az ĺƤʤ
    // {}
{
    Word y = Dereference (ay);
    if (IsFixnum (y)) {
	int	index = Fix2Int (y);
	int	length = StringObject_ptr (ax)->no_of_chars ();
	if (index < 0 || index >= length) {
	    error (setoform (ClassNameString, ax, y, az), OUT_OF_INDEX_RANGE);
	    return;
	}
	Word z = Dereference (az);
	if (IsFixnum (z)) {
	    if (IsASCII_StrObject (ax)){
		if ((0xff00 & (Fix2Int(z))) != 0){
		    ASCII_StrObject* copyfrom = ASCII_StrObject_ptr(ax);
		    int bs = copyfrom->no_of_bytes();
		    Word resized_string = CreateEUCString(INT0,length);
		    EUC_StrObject* copyto = EUC_StrObject_ptr(resized_string);
		    /* copy string object header */
		    memcpy(copyto, copyfrom, sizeof(SideEffect));
		    copyto->oTag(EUC_STR);
		    /* copy letters */
		    for (int elt = 0; elt < length; elt++) {
			copyto->Element (elt, copyfrom->Element (elt));
		    }
		    MJ_Mut_t* mut_join;
		    mut_join = (MJ_Mut_t*) copyfrom;
		    mut_join->Initialize(MJ_Mut, resized_string);
		    mut_join->Nword(bs) ;
		    /* set euc letter */
		    copyto->Element (index, z);
		} else
		    ASCII_StrObject_ptr (ax)->Element (index, z);
	    } else
		EUC_StrObject_ptr (ax)->Element (index, z);
	    doClose (az);
	    return;
	}
	if (IsUndefined (z)) {
	    Wait_for_seto_string_value (ax, y, z);
	    doClose (az);
	    return;
	}
	error (setoform (ClassNameString, ax, y, z),
	       "%s must be an integer", print (az));
	return;
    }
    if (IsUndefined (y)) {
	if (IsASCII_StrObject (ax)) {
	    ASCII_StrObject_ptr (ax)->Wait_for_set_index (PID_SET_O, y, az);
	} else {
	    EUC_StrObject_ptr (ax)->Wait_for_set_index (PID_SET_O, y, az);
	}
	doClose (az);
	return;
    }
    error (setoform (ClassNameString, ax, ay, az), "Index must be an integer");
}

void
doSetoMessage (Word x, Word y, Word z)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	z = Dereference (z);
	doSetArgExe (x, y, z, 'o');
	return;
    }
    error (setoform (ClassNameMessage, x, y, z),INDEX_MUST_BE_INTEGER);
}

void
doSeto (Word ax, Word ay, Word az)
    // {} @ METHOD BEGIN
    // {} @ CLASS  sequence
    // {} @ NOTATION X:set(Y,Z)
    // {} @ EXPLANATION
    // XYܤǤüZȤ롥YǤʤƤϤʤʤY
    // ̤³Υ祤ȤξY³ޤԤġ
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	    /* doSetoList (x, ay, az); */
	    goto error_occurred;
	    break;

	case VECTOR:
	    doSetoVector (x, ay, az);
	    break;

	case MESSAGE_OBJ:
	    doSetoMessage (x, ay, az);
	    break;

	case ASCII_STR:
	case EUC_STR:
	    doSetoString (x, ay, az);
	    break;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    Sendm_2args (x, PID_SET_O, ay, az);
	    break;

	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	    /* ListObject_ptr (x)->Suspended_by_set_index (PID_SET_O, ay, az); */
	    goto error_occurred;
	    break;

	case WC_VECTOR:
	    VectorObject_ptr (x)->Suspended_by_set_index (PID_SET_O, ay, az);
	    break;

	case WC_MESSAGE_OBJ:
	    MessageObject_ptr (x)->Suspended_by_set_index (PID_SET_O, ay, az);
	    break;

	case WC_ASCII_STR:
	    ASCII_StrObject_ptr (x)->Suspended_by_set_index (PID_SET_O, ay, az);
	    break;

	case WC_EUC_STR:
	    EUC_StrObject_ptr (x)->Suspended_by_set_index (PID_SET_O, ay, az);
	    break;

	default:
	    goto error_occurred;
	}
    }
    else if (IsSink (x)) {
	;
    }
    else {
	error_occurred:
	error (setoform (x, ay,az),
	       CAN_NOT_FIND_METHOD,"set/++");
	return;
    }
    doClose (ay);
    // åȤ뤳ȤˤܣλȲ껦롥
    // doClose (az);
}

METHOD (seto, R3_OP)
    // {}
    // seti Rx, Ry, Rz
    // {}
    // [	   address ]
    // [  Rx|  Ry|  Rz| 00]
    // {}
    //  Ri  Rj ܤǤ Rk 򥻥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    doSeto (x, Reg[ip->b1], Reg[ip->b2]);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
