/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/string.h"
#include "aum/protocolid.h"
#include "builtin/extern.h"

#ifdef nodef

Word doSetname_with_string_ascii(Word x,Word y)
{
    MessageObject* mobj = (MessageObject*)Pointer(x);
    Message*	   msg	= mobj->GetMessage();
    ProtocolID pid	= msg->PID();
    ASCII_StrObject* ascii = (ASCII_StrObject*)Pointer(y);
    Word atom = InternAtom(ascii->Print(FALSE));
    ProtocolID searchpid = InternProtocolID(atom,pid.Arity(),pid.Mode_mask());
    searchpid.ProtocolID((u_char)pid.Arity(),searchpid.Value(),PT_Compound);
    msg->PID(searchpid);
    return x;
}

Word doSetname_with_string_euc(Word x, Word y)
{
    MessageObject* mobj = (MessageObject*)Pointer(x);
    Message*	   msg	= mobj->GetMessage();
    ProtocolID pid	= msg->PID();
    EUC_StrObject* euc = (EUC_StrObject*)Pointer(y);
    Word atom = InternAtom(euc->Print(FALSE));
    ProtocolID searchpid = InternProtocolID(atom,pid.Arity(),pid.Mode_mask());
    searchpid.ProtocolID((u_char)pid.Arity(),searchpid.Value(),PT_Compound);
    msg->PID(searchpid);
    return x;
}

Word doSetname_with_Message(Word x, Word y)
{

    y = Dereference (y);
    if (IsUndefined (y))
	return SendBuiltinMessage2(y,PID_REV_SETNAME,x);
    Word ans;
    if (IsEUC_StrObject(y)){
	ans = doSetname_with_string_euc(x,y);
	return ans;
    }
    if (IsASCII_StrObject(y)){
	ans = doSetname_with_string_ascii(x,y);
	return ans;
    }
    error(form("setname %s %s ",print(x),print(y)),
	  "Can't coerence %s to MESSAGE ",print(x));
    return x;
}

Word doSetname(Word x, Word y)
    // {*} @ METHOD BEGIN
    // {*} @ CLASS message
    // {*} @ NOTATION X:setname(Y)
    // {*} @ EXPLANATION
    // Xå֥ȤǤYʸʤСXΥå̾
    // Yˤ롥
    //
    // ա۸ߤΥƥǤϥå̤뤿˥ץȥ
    // IDѤƤ롥ϤǤϤΥץȥID¹Ի
    // 뤳ȤǤʤΤǡ¸ߤʤå̾Ф
    // ȤϤǤʤФΤϥƥ¸ߤå̾
    // å󤢤뤤ϥ桼ץǻȤƤå
    // ̾ȥåȤ߹碌Ǥ롥
    // {} @ METHOD END
{
    x = Dereference (x);
    if (IsMessageObject(x))
	return doSetname_with_Message(x,y);
    if (IsUndefined (x))
	return SendBuiltinMessage2(x,PID_SETNAME,y);
    error(form("setname %s %s ",print(x),print(y)),
	  "Can't coerence %s to MESSAGE ",print(x));
    return x;
}

//METHOD(setname, R2_OP)
    // {}
    //	 setname Rmessage, Rname
    // {}
    // [	   address ]
    // [  Rx|  Rr|  00|	 00]
    // {}
    // Rx ( Message Object ) ̾ Rname ˤ롥
    // {}
{
    Fetch4();
    Reg[ip->b0] = doSetname(Reg[ip->b0],Reg[ip->b1]);
    JumpNextInstruction();
}

Word doRevSetname(Word y, Word x)
{
    y = Dereference (y);
    if (IsASCII_StrObject(y))
	return	doSetname_with_string_ascii(x, y);
    if (IsEUC_StrObject(y))
	return	doSetname_with_string_euc(x, y);
    error(form("rev setname %s %s",print(x),print(y)),
	  "illiegal object type %s ",print(y));
    return x;
}

#endif /* nodef */

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
