/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/string.h"
#include "aum/protocolid.h"
#include "table/protocol.h"
#include "builtin/extern.h"

#ifdef nodef

Word doSetmode_with_string(Word x, Word y)
{
    MessageObject* mobj = (MessageObject*)Pointer(x);
    Message*	   msg	= mobj->GetMessage();
    ProtocolID pid	= msg->PID();
    ASCII_StrObject* ascii = (ASCII_StrObject*)Pointer(y);
    Length pidArity;
    if ((pid.Type()!=PT_Compound)||((pidArity = pid.Arity()) == 0)){
	error(form("setmode %s %s ",print(x),ascii->Print(FALSE)),
	      form("Atomic Protocol-ID"));
	return x;
    }
    Length setmodes;
    if ((setmodes = ascii->no_of_chars()) != pidArity){
	error(form("setmode %s %s ",print(x),ascii->Print(FALSE)),
	      form("Invalid number of mode string"));
	return x;
    }
    int i;
    u_long modebit = 0;
    for (i = 0;(pidArity ) > i;i++){
	unsigned char letter = (char)Fix2Int(ascii->Element(i));
	if ((letter != (unsigned char)'+')&&
	    (letter != (unsigned char)'-')){
	    error(form("setmode %s %s ",print(x),ascii->Print()),
		  "Invalid charcter %x in mode string Index = %d ",letter,i);
	    return x;
	}
	modebit+= (letter == (unsigned char)'-' ? 0:(1<<i));
    }
    // УɣĤơ֥ˤ뤫ɤ
    Word    atom    = InternAtom(pid.Name());// ȥ򤨤
    ProtocolID searchpid = InternProtocolID(atom,pidArity,modebit);
    searchpid.ProtocolID((u_char)pidArity,searchpid.Value(),PT_Compound);
    //	  if (IsUnKnownPID(searchpid)){
    //	error(form("setmode %s %s ",print(x),ascii->Print(FALSE)),
    //	  form("not defined Protocol-ID"));
    //	return x;
    //	 }
    msg->PID(searchpid);
    return x;
}

Word doSetmode_with_Message(Word x, Word y)
{
    y = Dereference (y);
    if (IsUndefined (y))
	return SendBuiltinMessage2(y,PID_REV_SETMODE,x);
    if (IsASCII_StrObject(y)){
	Word ans = doSetmode_with_string(x, y);
	return ans;
    }
    error(form("setmode %s %s",print(x),print(y)),
	  "Can't coerce %s to ASCII-STRING",print(y));
    return x;
}

Word doSetmode(Word x, Word y)
    // {*} @ METHOD BEGIN
    // {*} @ CLASS message
    // {*} @ NOTATION X:setmode(Y)
    // {*} @ EXPLANATION
    // Xå֥ȤǤYʸʤСXγǤ
    // ʸ󤬼˥åȤ롥ʸˤɽϡʸ
    // @samp{-}, @samp{+} ˤäƤ줾ɽ
    //
    // ա۸ߤΥƥǤϥå̤뤿˥ץȥ
    // IDѤƤ롥ϤǤϤΥץȥID¹Ի
    // 뤳ȤǤʤΤǡ¸ߤʤåǤ
    // ФȤϤǤʤФΤϥƥ¸ߤå
    // ̾ȥå󤢤뤤ϥ桼ץǻȤƤ
    // å̾ȥåȤ߹碌Ǥ롥
    // {*} @ METHOD END
{
    x = Dereference (x);
    if (IsMessageObject(x))
	return doSetmode_with_Message(x,y);
    if (IsUndefined  (x))
	return SendBuiltinMessage2 (x, PID_SETMODE, y);
    error(form("setmode %s %s ",print(x),print(y)),
	  "Can't coerce %s to MESSAGE",print(x));
    return INT0;
}

//METHOD(setmode, R2_OP)
    // {}
    // setmode Rmessage, Rmode
    // {}
    // [	   address ]
    // [  Rx|  Rr|  00|	 00]
    // {}
    // Rx ( Message Object ) Υ⡼ɤ Rmode ˤ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    Word y = Reg[ip->b1];
    doSetmode (x, y);
    doClose (x);
    doClose (y);
    JumpNextInstruction();
}

Word doRevSetmode(Word y, Word x)
{
    y = Dereference (y);
    if (IsASCII_StrObject(y))
	return	doSetmode_with_string(x, y);
    error(form("setmode %s %s ",print(x),print(y)),
	  "Invalid Object Type %s ",print(y));
    return x;
}

#endif /* nodef */

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
