/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/protocolid.h"
#include "aum/list.h"
#include "aum/msgobj.h"
#include "aum/vector.h"
#include "aum/builtin.h"
#include "builtin/extern.h"

extern void doSetCari (Word, Word);

static const char *
setiform (const char* cn, Word x, Word y, Word z)
{
    return form ("%s:set(%s,^Z) [%s]", print (x), print (y), print (z), cn);
}

static const char *
setiform (Word cn, Word x, Word y, Word z)
{
    return form ("%s:set(%s,^Z) [%s]", print (x), print (y), print (z), print(cn));
}

void
doSetiList (Word x, Word y, Word z)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	int	index = Fix2Int (y);
	if (index < 0) {
	    error (setiform (Classnamelist, x, y, z), OUT_OF_INDEX_RANGE);
	    return;
	}
	Word	list = doNthList (x, index);
	if (IsINT0 (list)) {
	    error (setiform (Classnamelist, x, y, z), OUT_OF_INDEX_RANGE);
	    return;
	}
	doSetCari (list, z);
	return;
    }
    error (setiform (Classnamelist, x, y, z),INDEX_MUST_BE_INTEGER);
}

void
doSetiVector (Word x, Word y, Word z)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	VectorObject *source = (VectorObject *) Pointer (x);
	int	index = Fix2Int (y);
	int	vect_size = source->GetSize ();
	if (index < 0 || index >= vect_size) {
	    error (setiform (ClassNameVector, x, y, z), OUT_OF_INDEX_RANGE);
	    return;
	}
	char	mode = source->GetMode (index);
	Word	old = source->GetElement (index);
	if (mode == 'o') {
	    if (!IsUndefOutlet (old))
		doClose (old);
	}
	else {
	    if (!IsUndefInlet (old)) {
		Word	sink = SINKOBJ;
		doConnect (sink, J_NC_ptr (old));
	    }
	}
	z = Dereference (z);
	source->SetElement (index, z, 'i');
	return;
    }
    if (IsUndefined (y)) {
	VectorObject_ptr (x)->Wait_for_set_index (PID_SET_I, y, z);
	return;
    }
    error (setiform (ClassNameVector, x, y, z),
	   INDEX_MUST_BE_INTEGER);
}

void
doSetiMessage (Word x, Word y, Word z)
{
    y = Dereference (y);
    if (IsFixnum (y)) {
	z = Dereference (z);
	if (!IsInlet (z)) {
	    doSetArgExe (x, y, z, 'i');
	    return;
	}
	error (setiform (ClassNameMessage, x, y, z),
	       form ("%s must be an inlet", print (z)));
    }
    error (setiform (ClassNameMessage, x, y, z),
	   INDEX_MUST_BE_INTEGER);
}

void
doSeti (Word ax, Word ay, Word az)
    // {} @ METHOD BEGIN
    // {} @ CLASS sequence
    // {} @ NOTATION X:set(Y,^Z)
    // {} @ EXPLANATION
    // XYܤǤüȥ꡼Z򥻥åȤ롥YǤ
    // ƤϤʤʤY̤³Υ祤ȤξY³
    // ޤԤġ
    //
    // ֥X󤢤뤤ϥåǤʤ
    // Ϥʤʤ
    // {} @ METHOD END
{
    Word x = Dereference (ax);
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case LISTii:
	case LISTio:
	case LISToi:
	case LISToo:
	    /* doSetiList (x, ay, az); */
	    goto error_occurred;
	    break;

	case VECTOR:
	    doSetiVector (x, ay, az);
	    break;

	case MESSAGE_OBJ:
	    doSetiMessage (x, ay, az);
	    break;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    Sendm_2args (x, PID_SET_I, ay, az);
	    break;

	case WC_LISTii:
	case WC_LISTio:
	case WC_LISToi:
	case WC_LISToo:
	    /* ListObject_ptr (x)->Suspended_by_set_index (PID_SET_I, ay, az); */
	    goto error_occurred;
	    break;

	case WC_VECTOR:
	    VectorObject_ptr (x)->Suspended_by_set_index (PID_SET_I, ay, az);
	    break;

	case WC_MESSAGE_OBJ:
	    MessageObject_ptr (x)->Suspended_by_set_index (PID_SET_I, ay, az);
	    break;

	default:
	    goto error_occurred;
	}
    }
    else if (IsSink (x)) {
	doConnect (SINKOBJ, J_NC_ptr (az));
    }
    else {
	error_occurred:
	error (form ("%s:set(%s,^Z)",print (x), print (ay)),
	       CAN_NOT_FIND_METHOD,"set/+-");
	return;
    }
    doClose (ay);
}

METHOD (seti, R3_OP)
    // {}
    // seti Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Rx|  Ry|  Rz| 00]
    // {}
    //  Ri  Rj ܤǤ Rk 򥻥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    doSeti (x, Reg[ip->b1], Reg[ip->b2]);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
