/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/header.h"
#include "aum/fetch.h"
#include "aum/list.h"
#include "aum/builtin.h"
#include "builtin/extern.h"

void doSetCdri_y(Word x, Word y)
    // {}
    // ꥹȥ֥ x  ֥y Ȥʤ褦ʥꥹ
    // 
    // {}
{
    y = Dereference (y);
    if (IsInlet(y)) {
	if (Pointer(x)->oTag() == LISToi || Pointer(x)->oTag() == LISTii) {
	    Word sink = SINKOBJ;
	    doConnect (sink, J_NC_ptr (ListObject_ptr (x)->Cdr ()));
	    ListObject_ptr (x)->Cdr (y);
	}
	else {
	    doClose (ListObject_ptr (x)->Cdr ());
	    ListObject_ptr (x)->Cdr (y);
	    if (ListObject_ptr (x)->oTag () == LISToo)
		ListObject_ptr (x)->oTag (LISToi);
	    else
		ListObject_ptr (x)->oTag (LISTii);
	}
    }
    else
	error(form("%s:setcdr(^Y)",print(x),print(y)),
	      "%s must be an inlet ",print(y));
}

void doSetCdro_y(Word x, Word y)
    // {}
    // ꥹȥ֥ x  ֥y Ȥʤ褦ʥꥹ
    // 
    // {}
{
    y = Dereference(y);
    if (Pointer(x)->oTag() == LISToo || Pointer(x)->oTag() == LISTio) {
	doClose (ListObject_ptr (x)->Cdr ());
	ListObject_ptr (x)->Cdr (y);
    }
    else {
	Word sink = SINKOBJ;
	doConnect (sink, J_NC_ptr (ListObject_ptr (x)->Cdr ()));
	ListObject_ptr (x)->Cdr (y);
	if (ListObject_ptr (x)->oTag () == LISToi)
	    ListObject_ptr (x)->oTag (LISToo);
	else
	    ListObject_ptr (x)->oTag (LISTio);
    }
}

void doSetCdri(Word x, Word y)
    // {} @ METHOD BEGIN
    // {} @ CLASS list
    // {} @ NOTATION X:setcdr(^Y)
    // {} @ EXPLANATION
    // ꥹ X  cdr  Y򥻥åȤ롥
    // {} @ METHOD END
{
    x = Dereference (x);
    if (IsList(x)) {
	doSetCdri_y (x, y);
	return;
    }
    if (IsUndefined (x)) {
	Sendm_1arg (x, PID_SETCDR_I, y);
	return;
    }
    error(form("%s:setcdr(^Y)",print(x),print(y)),
	  "Can't coerce %s to LIST ",print(x));
}

void doSetCdro(Word x, Word y)
    // {} @ METHOD BEGIN
    // {} @ CLASS list
    // {} @ NOTATION X:setcdr(Y)
    // {} @ EXPLANATION
    // ꥹ X  cdr  Y򥻥åȤ롥
    // {} @ METHOD END
{
    x = Dereference (x);
    if (IsList(x)) {
	doSetCdro_y (x, y);
	return;
    }
    if (IsUndefined (x)) {
	Sendm_1arg (x, PID_SETCDR_O, y);
	return;
    }
    error(form("%s:setcdr(%s)",print(x),print(y)),
	  "Can't coerce %s to LIST ",print(x));
}

METHOD(setcdri, R2_OP)
    // {}
    // setcdri Ri, Rj
    // {}
    // ꥹ Ri  cdr  Rj 򥻥åȤ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    doSetCdri (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction();
}

METHOD(setcdro, R2_OP)
    // {}
    // setcdro Ri, Rj
    // {}
    // ꥹ Ri  cdr  Rj 򥻥åȤ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    doSetCdro (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction();
}
/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
