/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/header.h"
#include "aum/list.h"
#include "aum/builtin.h"
#include "builtin/extern.h"


void doSetCari_y(Word x, Word y)
    // {}
    // ꥹȥ֥ x Ƭ ֥y Ȥʤ褦ʥꥹ
    // 
    // {}
{
    y = Dereference (y);
    if (IsInlet(y)) {
	if (Pointer(x)->oTag() == LISTio || Pointer(x)->oTag() == LISTii) {
	    Word sink = SINKOBJ;
	    doConnect (sink, J_NC_ptr (ListObject_ptr (x)->Car ()));
	    ListObject_ptr (x)->Car (y);
	}
	else {
	    doClose (ListObject_ptr (x)->Car ());
	    ListObject_ptr (x)->Car (y);
	    if (ListObject_ptr (x)->oTag () == LISToo)
		ListObject_ptr (x)->oTag (LISTio);
	    else
		ListObject_ptr (x)->oTag (LISTii);
	}
    }
    else
	error(form("%s:setcar(^Y)",print(x)),
	      "%s must be an inlet ",print(y));
}

void doSetCaro_y (Word x, Word y)
    // {}
    // ꥹȥ֥ x Ƭ ֥y Ȥʤ褦ʥꥹ
    // 
    // {}
{
    y = Dereference(y);
    if (Pointer(x)->oTag() == LISToo || Pointer(x)->oTag() == LISToi) {
	doClose (ListObject_ptr (x)->Car ());
	ListObject_ptr (x)->Car (y);
    }
    else {
	Word sink = SINKOBJ;
	doConnect (sink, J_NC_ptr (ListObject_ptr (x)->Car ()));
	ListObject_ptr (x)->Car (y);
	if (ListObject_ptr (x)->oTag () == LISTio)
	    ListObject_ptr (x)->oTag (LISToo);
	else
	    ListObject_ptr (x)->oTag (LISToi);
    }
}

void doSetCari(Word x, Word y)
    // {} @ METHOD BEGIN
    // {} @ CLASS list
    // {} @ NOTATION X:setcar(^Y)
    // {} @ EXPLANATION
    // ꥹ X  car  Y򥻥åȤ롥
    // {} @ METHOD END
{
    x = Dereference(x);
    if (IsList(x)) {
	doSetCari_y (x,y);
	return;
    }
    if (IsUndefined (x)) {
	Sendm_1arg (x, PID_SETCAR_I, y);
	return;
    }
    error(form("%s:setcar(^Y)",print(x)),
	  "Can't coerce %s to LIST ",print(x));
}

void doSetCaro(Word x, Word y)
    // {} @ METHOD BEGIN
    // {} @ CLASS list
    // {} @ NOTATION X:setcar(Y)
    // {} @ EXPLANATION
    // ꥹ X  car Y򥻥åȤ롥
    // {} @ METHOD END
{
    x = Dereference (x);
    if (IsList(x)) {
	doSetCaro_y (x, y);
	return;
    }
    if (IsUndefined (x)) {
	Sendm_1arg (x, PID_SETCAR_O, y);
	return;
    }
    error(form("%s:setcar(%s)",print(x),print(y)),
	  "Can't coerce %s to LIST ",print(x));
}

METHOD(setcari, R2_OP)
    // {}
    // setcari Ri, Rj
    // {}
    // ꥹ Ri  car  Rj 򥻥åȤ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    doSetCari (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction();
}

METHOD(setcaro, R2_OP)
    // {}
    // setcaro Ri, Rj
    // {}
    // ꥹ Ri  car  Rj 򥻥åȤ롥
    // {}
{
    Fetch4();
    Word x = Reg[ip->b0];
    doSetCaro (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction();
}
/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
