/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stream.h>
#include "aum/word.h"
#include "aum/protocolid.h"
#include "aum/localmsg.h"
#include "aum/send.h"
#include "aum/close.h"
#include "aum/trace.h"
#include "builtin/extern.h"

// {}
// Word SendBuiltinMessage1(Word merger, const ProtocolID pid)
// {}
// ȹ֥Ȥα黻ǡ黻Ҥޡξ硧
//
// ̡ʥޡˤģåꡤ黻Ҥˤ롥黻
// ̤Ϻޡ֤ ޤ黻ҤؤλȤĤ롥
// ӣ黻ҡ
//
//		   
//   稡䨢	  Σ 
//		   
//		   	  Уɣ     
//		   	   
//		   	   䨢  ȣ  
//		   	   
//					   	  	     ̤
//					   
//					   ǽΥåʣɣΣԣ
//					   
//					   ǸΥåʣɣΣԣ
//					   
// {}

Word SendBuiltinMessage1(Word merger, const ProtocolID pid)
{
  LocalMessage*	  msg = new_LocalMessage(1, pid);
  Word	  result = new_Merger(2);

  msg->Argv(0, result);

  doSend(merger, msg);

  return result;
}

//{}
//Word SendBuiltinMessage2(Word merger, const ProtocolID pid , Word object)
//
//ȹ֥Ȥα黻ǡ黻Ҥޡξ硧
//
//ڥɤȷ̡ʥޡˤΣåꡤ黻Ҥ 
//롥黻̤Ϻޡ֤ ޤ黻ҤؤλȤĤ롥
//
//
//ӣ黻ҡ
//
//		  
//  稡䨢	Σ
//		  
//		  	Уɣ	    
//		  
//		     ڥ   
//		  	  
//		  	  䨢  ȣ  
//		  	  
//					  	 	    ̤
//					  
//					  ǽΥåʣɣΣԣ
//					  
//					  ǽΥåʣɣΣԣ
//					  
//{}


Word SendBuiltinMessage2(Word merger, const ProtocolID pid, Word object)
{
    LocalMessage* msg = new_LocalMessage(2, pid);

    doSplit (object);
    Word  result = new_Merger(2);

    msg->Argv(0, object);
    msg->Argv(1, result);

    doSend(merger, msg);

    return result;
}

//{}
//Word SendBuiltinMessage3(Word merger, const ProtocolID pid , Word obj0 , Word obj1)
//
//ȹ֥Ȥα黻ǡ黻Ҥޡξ硧
//
//ڥɤȷ̡ʥޡˤΣåꡤ黻Ҥ 
//롥黻̤Ϻޡ֤ ޤ黻ҤؤλȤĤ롥
//
//
//ӣ黻ҡ
//
//		  
//  稡䨢	Σ
//		  
//		  	Уɣ	    
//		  
//		     ڥ   
//		  	  
//		  	  䨢  ȣ  
//		  	  
//					  	 	    ̤
//					  
//					  ǽΥåʣɣΣԣ
//					  
//					  ǽΥåʣɣΣԣ
//					  
//{}

Word SendBuiltinMessage3(Word merger, const ProtocolID pid, Word obj1 , Word obj2)
{
    LocalMessage* msg	 = new_LocalMessage(3, pid);

    doSplit (obj1);
    doSplit (obj1);
    Word	  result = new_Merger(2);

    msg->Argv(0, obj1);
    msg->Argv(1, obj2);
    msg->Argv(2, result);

    doSend(merger, msg);

    return result;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-2
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
