/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum.h"
#include "aum/merger.h"
#include "aum/protocolid.h"
#include "aum/vector.h"
#include "aum/builtin.h"
#include "builtin/extern.h"

Word CopyObject(Word& x);

Word RecursiveCopyVector(Word& x)
{
    Word ret;
    VectorObject* source = (VectorObject*)Pointer(x);
    VectorObject* dummy	 = (VectorObject*)Pointer((ret = source->Copy()));
    for (int count = 0;count < source->GetSize();count++)
	{
	    dummy->SetElement(count,
			    CopyObject(source->GetElement(count)),
			    source->GetMode(count));
	}
    return ret;
}

Word CopyObject(Word& x)
// {}
// ֥ȤƵŪ˥ԡ
// {}
{
    Word ret = INT0;
    x = Dereference(x);
    switch(Type_of(x)){
    case AUm_Fixnum:
    case AUm_Atom:
    case AUm_Constant:
	ret = x;
	break;
    case AUm_Object:
	switch(Pointer(x)->Type()){
	case READY:
	case SUSPENDED:
	case SLEEPING:
	case CLOSED:
	case ERROR:
	case SINK:
	case MJ_NC:
	case AJ_NC:
	case MJ_W:
	case IMP_OBJ:
	case IMP_OBJ_NT:
	case IMP_INLET:
	case IMP_OUTLET:
	case FILE_STREAM:
	    // ret = CopyFileStream(); break; (?)
	    ret = x;
	    break;
	case CLASS_OBJ:
	    break;
	case MESSAGE_OBJ:
	    break;
	case FOREIGN_OBJ:
	    break;
	case DFLOAT:
	    ret = CopyDFloat(x);
	    break;
	case VECTOR:
	    ret = RecursiveCopyVector(x);
	    break;
	case LISToo:
	case LISTio:
	case LISToi:
	case LISTii:
	    /*ret = RecursiveCopyList(x);*/
	    break;
	case ASCII_STR:
	    ret = CopyASCIIString(x);
	    break;
	case EUC_STR:
	    ret = CopyEUCString(x);
	    break;
	default:
	    break;
	}
	break;
    default:
	break;
	}
    return ret;
}


/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
