/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/string.h"
#include "aum/list.h"
#include "aum/vector.h"
#include "aum/compare.h"
#include "aum/object.h"
#include "aum/builtin.h"
#include "aum/derive.h"
#include "builtin/extern.h"
#include "mathematics/ext-conv.h"

static const int CompareEq = 0; /* equal */
extern int CompareAtom (Word x, Word y);
extern int CompareString (Word x, Word y);
extern int CompareList (Word x, Word y);
extern int CompareVector (Word x, Word y);

Word
doNeq_with_dfloat (Word ax, Word ay)
    // {}
    // ư x ȥ֥ y Ӥʤ
    // 򡤤Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // 뤤ϥ桼֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Neq_p (ax, y);
    if (IsFixnum (y))
	return DFloat_Neq_p (ax, Fix2Double (y));
    if (IsSFloat (y))
	return DFloat_Neq_p (ax, Single2Double (y));
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_NEQ_DFLOAT, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperDoubleObject, PID_NEQ, ax, y);
    return BOOLFALSE;
}

inline Word
doNeq_with_fixnum (Word ax, Word ay)
    // {}
    //  x ȥ֥ y ӤʤϿ򡤤Ǥ
    // ϵ֤⤷y ΰ褬ꤷƤʤ뤤ϥ桼
    // ֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsFixnum (y))
	return (ax != y) ? BOOLTRUE : BOOLFALSE;
    if (IsDFloat (y))
	return DFloat_Neq_p (Fix2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Neq_p (Fix2Single (ax), y);
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_NEQ_FIXNUM, ax);
    return BOOLFALSE;
}

Word
doNeq_with_sfloat (Word ax, Word ay)
    // {}
    // ñư x ȥ֥ y ӤϿ
    // Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // ϥ桼֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Neq_p (Single2Double (ax), y);
    if (IsFixnum (y))
	return SFloat_Neq_p (ax, Fix2Single (y));
    if (IsSFloat (y))
	return SFloat_Neq_p (ax, y);
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_NEQ_SFLOAT, ax);
    return BOOLFALSE;
}

inline Word
doNeq_with_atom (Word ax, Word ay)
    // {}
    //  x ȥ֥ y ӤʤϿ򡤤Ǥ
    // ϵ֤⤷y ΰ褬ꤷƤʤ뤤ϥ桼
    // ֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsAtom (y))
	return (CompareAtom (ax, y) != CompareEq) ? BOOLTRUE : BOOLFALSE;
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_NEQ_ATOM, ax);
    return BOOLFALSE;
}

inline Word
doNeq_with_string (Word ax, Word ay)
    // {}
    // ʸ x ȥ֥ y ӤʤϿ򡤤
    // ʤϵ֤⤷y ΰ褬ꤷƤʤ뤤ϥ桼
    // ֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsASCII_StrObject (y) || IsEUC_StrObject (y))
	return CompareString (ax, y) != CompareEq ? BOOLTRUE : BOOLFALSE;
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_NEQ_STRING, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperStringObject, PID_NEQ, ax, y);
    return BOOLFALSE;
}

Word
doNeq_with_list (Word ax, Word ay)
    // {}
    // ٥ x ȥ֥ y Ӥʤ
    // 򡤤Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // 뤤ϥ桼֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsList (y))
	return CompareList (ax, y) != CompareEq ? BOOLTRUE : BOOLFALSE;
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_NEQ_LIST, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperListObject, PID_NEQ, ax, y);
    return BOOLFALSE;
}

inline Word
doNeq_with_vector (Word ax, Word ay)
    // {}
    // ٥ x ȥ֥ y Ӥʤ
    // 򡤤Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // 뤤ϥ桼֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsVector (y))
	return CompareVector (ax, y) != CompareEq ? BOOLTRUE : BOOLFALSE;
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_NEQ_VECTOR, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperVectorObject, PID_NEQ, ax, y);
    return BOOLFALSE;
}

Word
doNeq (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS compare
    // {} @ NOTATION X:neq(Y,^Z)
    // {} @ MACRO X != Y = ^Z
    // {} @ EXPLANATION
    // XYӤʤ @code{`true} 򡤤Ǥʤ
    // @code{`false} 򥹥ȥ꡼Z³롥
    // @send_when_cant_execute{Y}{neq(X,^Z)}
    // {} @ METHOD END
{
    Word x = ax;
    Word z;
 retry:
    switch (Type_of (x)) {
    case AUm_Atom:
	z = doNeq_with_atom (x, ay);
	break;
    case AUm_Fixnum:
	z = doNeq_with_fixnum (x, ay);
	break;
    default:
	if (IsBool (x))
	    z = IsTrue (x) ? doFalse_p (ay) : doTrue_p (ay);
	else if (IsSFloat (x))
	    z = doNeq_with_sfloat (x, ay);
	else if (IsSink (x))
	    z = SINKOBJ;
	else {
	    error (form ("%s:neq(%s,^Z)", print (ax), print (ay)),
		   CAN_NOT_FIND_METHOD,"neq/+-");
	    //errmsg_undefined_method (ax));
	    return SINKOBJ;
	}
	break;
    case AUm_Object:
	switch (Pointer (x)->Type ()) {
	case CONNECTED:
	    x = J_C_ptr (x)->Destination ();
	    goto retry;
	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    z = SendBuiltinMessage2 (x, PID_NEQ, ay);
	    break;
	case VECTOR:
	    z = doNeq_with_vector (x, ay);
	    break;
	case LISToo:
	case LISToi:
	case LISTio:
	case LISTii:
	    z = doNeq_with_list (x, ay);
	    break;
	case ASCII_STR:
	case EUC_STR:
	    z = doNeq_with_string (x, ay);
	    break;
	case DFLOAT:
	    z = doNeq_with_dfloat (x, ay);
	    break;
	case WC_LISToo:
	case WC_LISToi:
	case WC_LISTio:
	case WC_LISTii:
	    z = ListObject_ptr (x)->Suspended_by_elt_index (PID_NEQ, ay);
	    break;
	case WC_ASCII_STR:
	    z = ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_NEQ, ay);
	    break;
	case WC_EUC_STR:
	    z = EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_NEQ, ay);
	    break;
	case WC_VECTOR:
	    z = VectorObject_ptr (x)->Suspended_by_elt_index (PID_NEQ, ay);
	    break;
	default:
	    error (form ("%s:neq(%s,^Z)", print (ax), print (ay)),
		   CAN_NOT_FIND_METHOD,"neq/+-");
	    //errmsg_undefined_method (ax));
	    return SINKOBJ;
	    break;
	}
    }
    doClose (ay);
    return z;
}

METHOD (nequal, R3_OP)
    // {}
    // nequal Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj Ӥ롥ʤʤ `true 򤽤Ǥʤ
    // `false Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word x = Reg[ip->b0];
    Reg[ip->b2] = doNeq (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevNeq_atom (Word ay, Word ax)
    // {}
    //  x ȥ֥ y ӤʤϿ򡤤Ǥ
    // ϵ֤⤷y ΰ褬ꤷƤʤ뤤ϥ桼
    // ֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsAtom (y))
	return (CompareAtom (ax, y) != CompareEq) ? BOOLTRUE : BOOLFALSE;
    return BOOLFALSE;
}

Word
doRevNeq_string (Word ay, Word ax)
    // {}
    // ؿ doNeq(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡʸ٤Ǥ뤳ȤʬäƤ롥
    // {}
{
    Word y = Dereference (ay);
    if (IsString (ax))
	return doNeq_with_string (ax, y);
    return CallAUmProgram (CreateSuperStringObject, PID_REV_NEQ_STRING, y, ax);
}

Word
doRevNeq_list (Word ay, Word ax)
    // {}
    // ؿ doNeq(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡإꥹȡ٤Ǥ뤳ȤʬäƤ롥
    // {}
{
    Word y = Dereference (ay);
    if (IsList (ax))
	return doNeq_with_list (ax, y);
    return CallAUmProgram (CreateSuperListObject, PID_REV_NEQ_LIST, y, ax);
}

Word
doRevNeq_vector (Word ay, Word ax)
    // {}
    // ؿ doNeq(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡإ٥٤Ǥ뤳ȤʬäƤ롥
    // {}
{
    Word y = Dereference (ay);
    if (IsVector (ax))
	return doNeq_with_vector (ax, y);
    return CallAUmProgram (CreateSuperVectorObject, PID_REV_NEQ_VECTOR, y, ax);
}

Word
doRevNeq_fixnum (Word ay, Word ax)
    // {}
    //  x ȥ֥ y ӤϿ򡤤Ǥʤ
    // ϵ֤⤷y ΰ褬ꤷƤʤ뤤ϥ桼
    // ֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsFixnum (y))
	return Fixnum_Neq_p (ax, y);
    if (IsDFloat (y))
	return DFloat_Neq_p (Fix2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Neq_p (Fix2Single (ax), y);
    return BOOLFALSE;
}

Word
doRevNeq_sfloat (Word ay, Word ax)
    // {}
    // ñư x ȥ֥ y ӤϿ
    // Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // ϥ桼֥Ȥλϥå롥
    // {}
{
    Word y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Neq_p (Single2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Neq_p (ax, y);
    if (IsFixnum (y))
	return SFloat_Neq_p (ax, Fix2Single (y));
    return BOOLFALSE;
}

Word
doRevNeq_dfloat (Word ay, Word ax)
    // {}
    // ؿ doNeq(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    Word y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Neq_p (ax, y);
    if (IsFixnum (y))
	return DFloat_Neq_p (ax, Fix2Double (y));
    if (IsSFloat (y))
	return DFloat_Neq_p (ax, Single2Double (y));
    return BOOLFALSE;
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
