/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/msgobj.h"
#include "aum/stdlib.h"
#include "aum/tstream.h"
#include "aum/wait.h"
#include "aum/who.h"
#include "aum/trace.h"
#include "table/atomhash.h"

void
MessageObject::Initialize (Message * m)
    // {}
    // å֥Ȥ롥
    // {}
{
    SideEffect::Initialize (MESSAGE_OBJ, 1);
    message = m;
    return;
}

Boolean
MessageObject::IsInlet (int n) const
{
    return message->IsInlet (n);
}

void
MessageObject::Wait_for_set_index (const ProtocolID& pid, Word index, Word value)
    // {}
    // å Index ꤹΤԤĥ֥Ȥ롥
    // Ǥ򥻥åȤååα
    // ꥹȤ˷Ҥ롥ǸˡIndex  who åꡤ
    // ԤĤΥ֥Ȥˤ롥
    // {}
{
    doSplit (index);

    Message* lm = CreateMessage (pid, index, value);

    ConnectionWait (lm);

    Word wait_object = Create_wait_message_index_object (this);

    Word answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));
}

Word
MessageObject::Wait_for_elt_index (const ProtocolID& pid, Word index)
    // {}
    // å Index ꤹΤԤĥ֥Ȥ롥
    // Ǥ򥻥åȤååα
    // ꥹȤ˷Ҥ롥ǸˡIndex  who åꡤ
    // ԤĤΥ֥Ȥˤ롥
    // {}
{
    doSplit (index);
    Word value = new_Merger (2);

    Message* lm = CreateMessage (pid, index, value);

    ConnectionWait (lm);

    Word wait_object = Create_wait_message_index_object (this);

    Word answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));

    return value;
}

void
MessageObject::Free ()
    // {}
    // å֥Ȥΰ롣
    // {}
{
    message->Free ();
    SHARED_FREE (this, sizeof (MessageObject));
    return;
}

Name
MessageObject::Print ()
    // {}
    // å֥Ȥΰ᡼ʸȤ֤
    // {}
{
    char    buf[BUFSIZ];
    tstream tout = tstream (BUFSIZ, buf);
    if (ShowRC) {
	u_short rc = LRC ();
	tout.form (":%d<", rc);
	ShowRC = FALSE;
	tout << message->Print ();
	ShowRC = TRUE;
    }
    else
	tout << ":<" << message->Print ();
    tout << ">";
    return tout.Result ();
}

Word
new_MessageObject (Message * m)
    // {}
    // å֥Ȥ롥
    // {}
{
    MessageObject *mo = (MessageObject *) SHARED_ALLOC (sizeof (MessageObject));
    mo->Initialize (m);
    return ObjectWord (mo);
}

int
CompareMessage (Word x, Word y)
    // {}
    // å֥ȤӤ򤹤롥
    // {}
{
    MessageObject *mx = MessageObject_ptr (x);
    MessageObject *my = MessageObject_ptr (y);
    if (mx->GetMessage () != my->GetMessage ())
	return 1;
    return 0;
}

static void
setmsgerr (Word x, Word y, Word z, char mode, const char* msg)
{
    const char* fmt = (mode == 'i') ? "%s :set(%s,^%s)" : "%s :set(%s,%s)";
    error (form (fmt, print (x), print (y), print (z)), msg);
}

void
doSetArgExe (Word x, Word y, Word z, char mode)
{
    int	    index = Fix2Int (y);
    MessageObject *messobj = (MessageObject *) Pointer (x);
    Message *mess = messobj->GetMessage ();
    ProtocolID pid = mess->PID ();
    int	    arity = pid.Arity ();

    if (index < 0 || index >= arity) {
	setmsgerr (mode, x, y, z, OUT_OF_INDEX_RANGE);
	return;
    }
    if (pid.IsInlet (index)) {
	if (mode == 'o') {
	    u_long  mode = pid.Mode_mask ();
	    mode = mode ^ (1 << index);
	    Word    atom = InternAtom (pid.Name ());
	    ProtocolID searchpid = InternProtocolID (atom, arity, mode);
	    searchpid.ProtocolID ((u_char) arity, searchpid.Value (), PT_Compound);
	    mess->PID (searchpid);
	}
    }
    else {
	if (mode == 'i') {
	    u_long  mode = pid.Mode_mask ();
	    mode = mode ^ (1 << index);
	    Word    atom = InternAtom (pid.Name ());
	    ProtocolID searchpid = InternProtocolID (atom, arity, mode);
	    searchpid.ProtocolID ((u_char) arity, searchpid.Value (), PT_Compound);
	    mess->PID (searchpid);
	}
    }
    if (((pid.Type ()) != PT_Compound) || (arity == 0)) {
	setmsgerr (mode, x, y, z, form("%s is atomic message",print(x)));
	return;
    }
    mess->Argv (index, z);
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
