/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/merger.h"
#include "aum/builtin.h"
#include "aum/messageq.h"
#include "aum/message.h"
#include "aum/aj-c.h"
#include "builtin/extern.h"

#ifdef nodef
void doMapListObject(Word x, Word y)
{
    Message* msg  = (Message*)Object_ptr(y);
    ListObject* l = (ListObject*)Object_ptr(x);
    for(;;)
	{
	    Word car = l->Car(), cdr = l->Cdr();
	    doSend(car,msg);
	    l = (ListObject*)Object_ptr(cdr);
	}
}

void doMapVectorObject(Word x, Word y)
{
    Message*	msg = (Message*)Object_ptr(y);
    VectorObject* v = (VectorObject*)(Object_ptr(x));
    Length index = v->GetSize();
    while(index-- > 0)
	{
	    doSend(v->GetElement(index),msg);
	}
}

void doRevMapVector(Word y, Word x)
    // {}
    //	doMap_y()ǰ y , x νϤ줿Ȥν
    // {}
{
 retry:
    switch (Type_of(y))
	{
	case AUm_Object:
	    switch (ObjectType(y))
		{
		case CONNECTED:
		    y = J_C_ptr(y)->Destination ();
		    goto retry;

		case MESSAGE_OBJ:
		    doMapVectorObject(x, y);
		    return;
		default:
		    break;
		}
	    break;
	default:
	    break;
	}
}

void doRevMapList(Word y, Word x)
    // {}
    //	doMap_y()ǰ y , x νϤ줿Ȥν
    // {}
{
 retry:
    switch (Type_of(y))
	{
	case AUm_Object:
	    switch (ObjectType(y))
		{
		case CONNECTED:
		    y = J_C_ptr(y)->Destination ();
		    goto retry;

		case MESSAGE_OBJ:
		    doMapListObject(x, y);
		    return;
		default:
		    break;
		}
	    break;
	default:
	    break;
	}
}

void doYMapList(Word x, Word y)
    // {}
    //	ꥹ x γǤ˥֥ y 롥
    // {}
{
 retry:
    switch (Type_of(y))
	{
	case AUm_Object:
	    switch (ObjectType(y))
		{
		case CONNECTED:
		    y = J_C_ptr(y)->Destination ();
		    goto retry;

		case MESSAGE_OBJ:
		    doMapListObject(x, y);
		    return;

		case MJ_NC:
		case AJ_NC:
		case MJ_W:
		case IMP_OBJ:
		case IMP_OBJ_NT:
		case IMP_INLET:
		case IMP_AJ_INLET:
		case IMP_OUTLET:
		    SendBuiltinMessage2(y, PID_REV_MAP_LIST, x);
		    break;
		default:
		    break;
		}
	    break;
	default:
	    break;
	}
    //error ();
}

void doYMapVector(Word x, Word y)
    // {}
    //	٥	x γǤ˥֥ y 롥
    // {}
{
 retry:
    switch (Type_of(y))
	{
	case AUm_Object:
	    switch (ObjectType(y))
		{
		case CONNECTED:
		    y = J_C_ptr(y)->Destination ();
		    goto retry;

		case LISToo:
		case LISToi:
		case LISTio:
		case LISTii:
		case MESSAGE_OBJ:
		    doMapVectorObject(x, y);
		    return;
		case MJ_NC:
		case AJ_NC:
		case MJ_W:
		case IMP_OBJ:
		case IMP_OBJ_NT:
		case IMP_INLET:
		case IMP_AJ_INLET:
		case IMP_OUTLET:
		    SendBuiltinMessage2(y, PID_REV_MAP_VECTOR, x);
		    break;
		default:
		    break;
		}
	    break;
	default:
	    break;
	}
    //error ();
}

void doMap(Word x, Word y)
{
 retry:
    switch (Type_of(x))
	{
	case AUm_Object:
	    switch (ObjectType(x))
		{
		case CONNECTED:
		    x = J_C_ptr(x)->Destination ();
		    goto retry;

		case LISToo:
		case LISTio:
		case LISToi:
		case LISTii:
		    doYMapList(x, y);
		    return;

		case VECTOR:
		    doYMapVector(x, y);
		    return;

		case MJ_NC:
		case AJ_NC:
		case MJ_W:
		case IMP_OBJ:
		case IMP_OBJ_NT:
		case IMP_INLET:
		case IMP_AJ_INLET:
		case IMP_OUTLET:
		    SendBuiltinMessage2(x, PID_MAP, y);
		    return;
		default:
		    break;
		}
	    break;
	default:
	    break;
	}
    //error ();
    return;
}

//METHOD(aum_map, R2_OP)
    // {}
    //	 map Rvector , Rmessage
    // {}
    // [	   address ]
    // [  Rv|  Rm|  00|	 00]
    // {}
    //	 Rvector γǤ Rmessage 롣
    // оݥ֥
    //	 Vector ObjectΤߡ
{
    Fetch4();
    doMap(Reg[ip->b0],Reg[ip->b1]);
    JumpNextInstruction();
}

#endif /* nodef */

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
