/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/alloc.h"
#include "aum/error.h"
#include "aum/fetch.h"
#include "aum/list.h"
#include "aum/protocolid.h"
#include "aum/split.h"
#include "aum/tstream.h"
#include "aum/wait.h"
#include "aum/who.h"
#include "builtin/extern.h"

void
ListObject::Initialize (ObjectTag tag, Word x, Word y)
    // {}
    // ꥹȡ֥Ȥν򤹤롥Ƭ car  cdr 
    // åȤ롥
    // {}
{
    SideEffect::Initialize (tag, 1);
    car = x;
    cdr = y;
}

void
ListObject::Close ()
{
    Word    sink = SINKOBJ;

    switch (oTag ()) {
    case LISTii:
	doConnect (sink, MJ_NC_ptr (car));
	doConnect (sink, MJ_NC_ptr (cdr));
	break;

    case LISTio:
	doConnect (sink, MJ_NC_ptr (car));
	doClose (cdr);
	break;

    case LISToi:
	doClose (car);
	doConnect (sink, MJ_NC_ptr (cdr));
	break;

    case LISToo:
	doClose (car);
	doClose (cdr);
	break;

    default:
	abort ();
    }
}

void
ListObject::Free ()
    // {}
    // ꥹȡ֥ȤƬӡĺꥹȡ֥
    // Ȥΰ롥
    // {}
{
    SHARED_FREE (this, sizeof (class ListObject));
}

Name
ListObject::Print ()
    // {}
    // ꥹȡ֥Ȥΰ᡼ʸȤ֤
    // {}
{
    char    tem[BUFSIZ];
    tstream tout = tstream (BUFSIZ, tem);
    if (ShowRC) {
	u_short rc = LRC ();
	const char *fmt;
	switch (oTag ()) {
	case WC_LISToo:
	case LISToo:
	    fmt = "%d[%s|%s]";
	    break;
	case WC_LISToi:
	case LISToi:
	    fmt = "%d[%s|^%s]";
	    break;
	case WC_LISTio:
	case LISTio:
	    fmt = "%d[^%s|%s]";
	    break;
	case LISTii:
	case WC_LISTii:
	    fmt = "%d[^%s|^%s]";
	    break;
	default:
	    abort ();
	}
	tout.form (fmt, rc, print (car), print (cdr));
    }
    else {
	tout << "[";
	ObjectTag tag = oTag ();
	Word	head = Dereference (car);
	Word	tail = Dereference (cdr);

	if (tag == LISTio || tag == LISTii)
	    tout << "^";
	tout << print (head);

	while (IsList (tail)) {
	    tout << ",";
	    tag = ListObject_ptr (tail)->oTag ();
	    head = Dereference (ListObject_ptr (tail)->Car ());
	    tail = Dereference (ListObject_ptr (tail)->Cdr ());
	    if (tag == LISTio || tag == LISTii)
		tout << "^";
	    tout << print (head);
	}
	if (!IsNILATOM (tail)) {
	    tout << "|";
	    if (tag == LISToi || tag == LISTii)
		tout << "^";
	    tout << print (tail);
	}
	tout << "]";
    }
    return tout.Result ();
}

Word
CopyList (Word mold)
    // {}
    // ꥹȡ֥Ȥʣ̤롥δؿϡ
    // 줿ꥹȹ¤򥪥֥ȤȤѤ˻ȤؿǤ롥
    // äơԡ˻ȲûɬפϤʤ
    // {}
{
    ListObject *xl = (ListObject *) Object_ptr (mold);
    ListObject *yl = (ListObject *) SHARED_ALLOC (sizeof (ListObject));
    yl->Initialize (xl->oTag (), xl->Car (), xl->Cdr ());
    return ObjectWord (yl);
}

Word
CreateList (ObjectTag tag, Word car, Word cdr)
    // {}
    // Ƭ car ǡ cdr Ǥ褦ʥꥹȡ֥Ȥ
    // 롥
    // {}
{
    ListObject *xl = (ListObject *) SHARED_ALLOC (sizeof (ListObject));
    xl->Initialize (tag, car, cdr);
    return ObjectWord (xl);
}

void
DeleteList (Word x)
    // {}
    // ꥹȡ֥Ȥ롥
    // {}
{
    ListObject *lp = (ListObject *) Object_ptr (x);
    lp->Free ();
    return;
}

void
PrintList (Word x)
    // {}
    // ꥹȡ֥ȤϤ롥
    // {}
{
    ListObject *lx = (ListObject *) Object_ptr (x);
    cout << lx->Print ();
    return;
}

int
CompareList (Word x, Word y)
    // {}
    // ꥹȡ֥ȤӤ򤹤롥ɥ쥹ˤäӤ롥
    // ǤӤϤʤ
    // {}
{
    ListObject *xl = (ListObject *) Object_ptr (x);
    ListObject *yl = (ListObject *) Object_ptr (y);
    if (xl != yl)
	return 1;
    return 0;
}

Name
ListPrintImage (Word x)
    // {}
    // ꥹȡ֥ȤΰɽʸȤ֤
    // {}
{
    ListObject *lx = (ListObject *) Object_ptr (x);
    return lx->Print ();
}




// //////////////////////////////////////////////////////////////////////
// //////////////////////////  CAR INLET  ///////////////////////////////
// //////////////////////////////////////////////////////////////////////

Word doCari (Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS list
    // {} @ NOTATION X:car(Y)
    // {} @ EXPLANATION
    // ꥹȤ car üȥ꡼Y롥X car 
    // ʤХ顼Ǥ롥ФƬǤϽƤ
    // üȤʤ롥
    // {} @ METHOD END
{
    static const char where[] = "car(X)";

retry:
    if (IsObject (x)) {
	switch (Pointer (x)->Type ()) {
	case CONNECTED:
	    x = J_C_ptr (x)->Destination ();
	    goto retry;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    return SendBuiltinMessage1 (x, PID_CAR_I);

	case LISTio:
	case LISTii:
	    Word car = ListObject_ptr (x)->Car ();
	    if (car == UNDEFINLET) {
		error (form ("%s :%s", print (x), where),
		       "%s is not initialized", where);
	    }
	    else {
		ListObject_ptr (x)->Car (UNDEFINLET);
	    }
	    return car;

	case LISToo:
	case LISToi:
	    error (form ("%s:%s", print (x), where),
		   "\"%s\"(car) must be an inlet", print (x));
	    return UNDEFINLET;
	default:
	    break;
	}
    }
    error (form ("%s:%s", print (x), where),
	   CAN_NOT_FIND_METHOD,"car/+");
    return UNDEFINLET;
}

METHOD (cari, R2_OP)
    // {}
    // cari Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // ꥹ Ri  car  Rj ˥åȤ롥
    // {}
{
    Fetch112 ();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doCari (x);
    doClose(x);
    JumpNextInstruction ();
}



// //////////////////////////////////////////////////////////////////////
// //////////////////////////  CDR INLET  ///////////////////////////////
// //////////////////////////////////////////////////////////////////////

Word doCdri (Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS list
    // {} @ NOTATION X:cdr(Y)
    // {} @ EXPLANATION
    // ꥹȤ cdr üȥ꡼YȤ롥X cdr 
    // ʤХ顼Ǥ롥Ф cdr ϽƤ
    // üȤʤ롥
    // {} @ METHOD END
{
    static const char where[] = "cdr(X)";

retry:
    if (IsObject (x)) {
	switch (Pointer (x)->Type ()) {
	case CONNECTED:
	    x = J_C_ptr (x)->Destination ();
	    goto retry;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    return SendBuiltinMessage1 (x, PID_CDR_I);

	case LISToi:
	case LISTii:
	    Word cdr = ListObject_ptr (x)->Cdr ();
	    if (cdr == UNDEFINLET) {
		error (form ("%s :%s", print (x), where),
		       "%s is not initialized", where);
	    }
	    else {
		ListObject_ptr (x)->Cdr (UNDEFINLET);
	    }
	    return cdr;

	case LISToo:
	case LISTio:
	    error (form ("%s:%s", print (x), where),
		   "\"%s(cdr)\" must be an inlet", print (x));
	    return UNDEFINLET;
	default:
	    break;
	}
    }
    error (form ("%s:%s", print (x), where),
	   CAN_NOT_FIND_METHOD,"cdr/+");
    return UNDEFINLET;
}

METHOD (cdri, R2_OP)
    // {}
    // cdri Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // ꥹ Ri  cdr  Rj ˥åȤ롥
    // {}
{
    Fetch112 ();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doCdri (x);
    doClose(x);
    JumpNextInstruction ();
}



// //////////////////////////////////////////////////////////////////////
// //////////////////////////  CAR OUTLET  //////////////////////////////
// //////////////////////////////////////////////////////////////////////

Word doCaro (Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS list
    // {} @ NOTATION X:car(^Y)
    // {} @ EXPLANATION
    // ꥹȤ car 򥹥ȥ꡼Y³롥X car ʤ
    // Х顼Ǥ롥
    // {} @ METHOD END
{
    static const char where[] = "car(^X)";

retry:
    if (IsObject (x)) {
	switch (Pointer (x)->Type ()) {
	case CONNECTED:
	    x = J_C_ptr (x)->Destination ();
	    goto retry;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    return SendBuiltinMessage1 (x, PID_CAR_O);

	case LISToi:
	case LISToo:
	    Word car = ListObject_ptr (x)->Car ();
	    if (car == UNDEFOUTLET) {
		error (form ("%s :%s", print (x), where),
		       "%s is not initialized", where);
	    }
	    else {
		doSplit (car);
	    }
	    return car;

	case LISTii:
	case LISTio:
	    error (form ("%s:%s", print (x), where),
		   "\"%s(car)\" must be an outlet", print (x));
	    return INT0;
	default:
	    break;
	}
    }
    error (form ("%s:%s", print (x), where),
	   CAN_NOT_FIND_METHOD,"car/-");
    return INT0;
}

METHOD (caro, R2_OP)
    // {}
    // caro Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // ꥹ Ri  car  Rj ˥åȤ롥
    // {}
{
    Fetch112 ();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doCaro (x);
    doClose(x);
    JumpNextInstruction ();
}



// //////////////////////////////////////////////////////////////////////
// //////////////////////////  CDR OUTLET  //////////////////////////////
// //////////////////////////////////////////////////////////////////////

Word doCdro (Word x)
    // {} @ METHOD BEGIN
    // {} @ CLASS list
    // {} @ NOTATION X:cdr(^Y)
    // {} @ EXPLANATION
    // ꥹȤ cdr 򥹥ȥ꡼Y³롥X cdr 
    // ʤХ顼Ǥ롥
    // {} @ METHOD END
{
    static const char where[] = "cdr(^X)";

retry:
    if (IsObject (x)) {
	switch (Pointer (x)->Type ()) {
	case CONNECTED:
	    x = J_C_ptr (x)->Destination ();
	    goto retry;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    return SendBuiltinMessage1 (x, PID_CDR_O);

	case LISTio:
	case LISToo:
	    Word cdr = ListObject_ptr (x)->Cdr ();
	    if (cdr == UNDEFOUTLET) {
		error (form ("%s:%s", print (x), where),
		       "%s is not initialized", where);
	    }
	    else {
		doSplit (cdr);
	    }
	    return cdr;

	case LISTii:
	case LISToi:
	    error (form ("%s:%s", print (x), where),
		   "\"%s(cdr)\" must be an outlet", print (x));
	    return INT0;
	default:
	    break;
	}
    }
    error (form ("%s:%s", print (x), where),
	   CAN_NOT_FIND_METHOD,"cdr/-");
    return INT0;
}

METHOD (cdro, R2_OP)
    // {}
    // cdro Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // ꥹ Ri  cdr  Rj ˥åȤ롥
    // {}
{
    Fetch112 ();
    Word x = Reg[ip->b0];
    Reg[ip->b1] = doCdro (x);
    doClose(x);
    JumpNextInstruction ();
}



// //////////////////////////////////////////////////////////////////////
// //////////////////////////  UTILITIES   //////////////////////////////
// //////////////////////////////////////////////////////////////////////

Word doCar (Word x)
{
    x = Dereference (x);
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case LISToo:
	case LISToi:
	    return doCaro (x);
	case LISTio:
	case LISTii:
	    return doCari (x);
	default:
	    break;
	}
    }
    return doCaro (x);
}

Word
doCdr (Word x)
{
    x = Dereference (x);
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case LISToo:
	case LISTio:
	    return doCdro (x);
	case LISToi:
	case LISTii:
	    return doCdri (x);
	default:
	    break;
	}
    }
    return doCdro (x);
}

Word
doNthList (Word x, int index)
    // {}
    // ꥹȥ֥ȤΣܤΥꥹȥ֤ƬΥꥹȤ
    // ܤǤ롥ꥹȤĹ index 礭ˤ֤
    // {}
{
    int	    i = index;
    Word    list = x;
    Word    cdr = doCdr (list);
    while (--i >= 0 && (IsList (cdr) || IsUndefined (cdr))) {
	doClose (cdr);
	list = cdr;
	cdr = doCdr (cdr);
    }
    doClose (cdr);
    if (i >= 0)
	return INT0;
    return list;
}

// //////////////////////////////////////////////////////////////////////
// //////////////////////////  WAIT	   //////////////////////////////
// //////////////////////////////////////////////////////////////////////

void
ListObject::Wait_for_set_index (const ProtocolID & pid, Word index, Word value)
    // {}
    // ꥹȤ Index ꤹΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤåꥹȤαꥹȤ
    // Ҥ롥ǸˡIndex  who åꡤԤĤ
    // Υ֥Ȥˤ롥
    // {}
{
    doSplit (index);

    Message *lm = CreateMessage (pid, index, value);

    ConnectionWait (lm);

    Word    wait_object = Create_wait_list_index_object (this);

    Word    answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));
}

Word
ListObject::Wait_for_elt_index (const ProtocolID & pid, Word index)
    // {}
    // ꥹȤ Index ꤹΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤåꥹȤαꥹȤ
    // Ҥ롥ǸˡIndex  who åꡤԤĤ
    // Υ֥Ȥˤ롥
    // {}
{
    doSplit (index);
    Word    value = new_Merger (2);

    Message *lm = CreateMessage (pid, index, value);

    ConnectionWait (lm);

    Word    wait_object = Create_wait_list_index_object (this);

    Word    answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));

    return value;
}

Word
ListObject::Wait_for_subseq_position (Word index, Word a0, Word a1)
    // {}
    // ꥹȤ Index ꤹΤԤĥ֥Ȥ롥ǽ
    // Ǥ򥻥åȤåꥹȤαꥹȤ
    // Ҥ롥ǸˡIndex  who åꡤԤĤ
    // Υ֥Ȥˤ롥
    // {}
{
    doSplit (a0);
    doSplit (a1);
    Word    value = new_Merger (2);

    Message *lm = CreateMessage (PID_SUBSEQ, a0, a1, value);

    ConnectionWait (lm);

    Word    wait_object = Create_wait_list_index_object (this);

    Word    answer_stream = doWho (index);
    doConnect (wait_object, J_NC_ptr (answer_stream));

    return value;
}

static Word
sublis (Word x, int s, int e)
    // {}
    // ꥹȤʬڤФꥹȤ롥
    // {}
{
    if (s == e)
	return NILATOM;
    return CreateList (LISToo,
		       doCar (doNthList (x, s + e)), sublis (x, s, e - 1));
}

Word
ListObject::Subseq (Word y, Word z)
    // {}
    // ꥹȤʬڤФꥹȤ롥
    // {}
{
    int	    from = Fix2Int (y);
    int	    to	 = Fix2Int (z);

    return sublis (ObjectWord (this), from, to);
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
