/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/string.h"
#include "aum/msgobj.h"
#include "aum/vector.h"
#include "aum/builtin.h"
#include "builtin/extern.h"

Word
doLength (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS     sequence
    // {} @ NOTATION  X:length(^Y)
    // {} @ EXPLANATION
    // X ʸǤʸĹǤ
    // ǿ򡤥ꥹȤǤХꥹȤĹ򡤥åǤ
    // аο򥹥ȥ꡼Y³롥
    //
    // {} @ METHOD END
    // XꥹȤǤ cdr ³Ƥʤȥ꡼ξˤϡ
    // ȥ꡼ब³ΤԤġ
    // {}
{
    Word x = Dereference (ax);
    Word z;
    if (IsObject (x)) {
	switch (Pointer (x)->oTag ()) {
	case VECTOR:
	    z = Int2Fix (VectorObject_ptr (x)->GetSize ());
	    break;

	case MESSAGE_OBJ:
	    z =	 Int2Fix (MessageObject_ptr (x)->GetMessage ()->Arity ());
	    break;

	case ASCII_STR:
	    z = Int2Fix (ASCII_StrObject_ptr (x)->no_of_chars ());
	    break;

	case EUC_STR:
	    z = Int2Fix (EUC_StrObject_ptr (x)->no_of_chars ());
	    break;

	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    z = SendBuiltinMessage1 (x, PID_LENGTH);
	    break;

	case WC_VECTOR:
	    z = VectorObject_ptr (x)->Suspended_by_elt_index (PID_LENGTH);
	    break;

	case WC_MESSAGE_OBJ:
	    z = MessageObject_ptr (x)->Suspended_by_elt_index (PID_LENGTH);
	    break;

	case WC_ASCII_STR:
	    z = ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_LENGTH);
	    break;

	case WC_EUC_STR:
	    z = EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_LENGTH);
	    break;
	default:
	    goto error_occurred;
	}
    }
    else if (IsSink (x)) {
	z = SINKOBJ;
    } else {
    error_occurred:
	error (form ("%s :length(^N)", print (ax)),
	       CAN_NOT_FIND_METHOD,"length/-");
	return INT0;
    }
    return z;
}

METHOD (length, R2_OP)
    // {}
    // length Ri, Rj
    // {}
    // [	   address ]
    // [  Rx|  Rr|  00|	 00]
    // {}
    // Ri ʸʤʸĹ
    // ʤФǿ Rj ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b1] = doLength (x);
    doClose (x);
    JumpNextInstruction ();
}
/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
