/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/instantiate.h"
#include "aum/protocolid.h"
#include "builtin/extern.h"

Boolean
IsInstantiated (Word & x)
    // {}
    //  x Υ֥Ȥ³Ƥ鿿򡤤Ǥʤ
    // ֤x ³줿祤Ȥξϡǥե󥹤
    // Ԥ
    // {}
{
    return IsInstantiated_inline (x);
}

Word
doInstantiate (Word ax)
    // {}
    // x ޡʳʤСRj ˥ȥ instantiated 롥
    // {}
{
    Word    x = Dereference (ax);
    if (IsUndefined (x)) {
	return SendBuiltinMessage1 (x, PID_INSTANTIATE);
    }
    else {
	return InternAtom ("instantiated");
    }
}

METHOD (instantiate, R2_OP)
    // {}
    // instantiate Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // 쥸 Ri 祤ȰʳʤСRj ˥ȥ instantiated 
    // 롥̿ϥǥХåѤѰդƤ롥
    // {}
{
    Fetch112 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b1] = doInstantiate (x);
    doClose (x);
    JumpNextInstruction ();
}

Word
doIsSimple (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS object
    // {} @ NOTATION X:issimple(^Y)
    // {} @ MACRO issimple X = ^Y
    // {} @ EXPLANATION
    // Xñ㥪֥Ȥʤ @code{`true} , Ǥʤ
    // @code{`false} 򥹥ȥ꡼Y³롥
    // {} @ METHOD END
{
    Word x = ax;
    Word y;
 retry:
    switch (Type_of (x)) {
    case AUm_Atom:
    case AUm_Fixnum:
    default:
	y = BOOLTRUE;
	break;
    case AUm_Object:
	switch (Pointer (x)->oTag ()) {
	case CONNECTED:
	    x = Dereference (x);
	    goto retry;
	case BUILTIN:
	    y = BOOLFALSE;
	    break;
	default:
	    y = SendBuiltinMessage1 (x, PID_ISSIMPLE);
	    break;
	}
	break;
    }
    return y;
}

METHOD (issimple, R2_OP)
    // {}
    // issimple Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // 쥸 Ri ñ㥪֥Ȥʤ Rj  `true 򡤤ʳ
    // ֥Ȥʤ `false 򥻥åȤ롥Ri ̤³Υ祤
    // ʤХå롥
    // {}
{
    Fetch112 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b1] = doIsSimple (x);
    doClose (x);
    JumpNextInstruction ();
}

Word
doIsBuiltin (Word ax)
    // {} @ METHOD BEGIN
    // {} @ CLASS object
    // {} @ NOTATION X:isbuiltin(^Y)
    // {} @ MACRO isbuiltin X = ^Y
    // {} @ EXPLANATION
    // Xȹ֥Ȥʤ @code{`true} , Ǥʤ
    // @code{`false} 򥹥ȥ꡼Y³롥
    // {} @ METHOD END
{
    Word x = ax;
    Word y;
 retry:
    switch (Type_of (x)) {
    case AUm_Atom:
    case AUm_Fixnum:
    default:
	y = BOOLTRUE;
	break;
    case AUm_Object:
	switch (Pointer (x)->oTag ()) {
	case CONNECTED:
	    x = Dereference (x);
	    goto retry;
	case BUILTIN:
	    y = BOOLTRUE;
	    break;
	default:
	    y = SendBuiltinMessage1 (x, PID_ISBUILTIN);
	    break;
	}
	break;
    }
    return y;
}

METHOD (isbuiltin, R2_OP)
    // {}
    // isbuiltin Ri, Rj
    // {}
    // [	   address ]
    // [  Ri|  Rj|	  0]
    // {}
    // 쥸 Ri ȹ֥Ȥʤ Rj  `true 򡤤ʳ
    // ֥Ȥʤ `false 򥻥åȤ롥Ri ̤³Υ祤
    // ʤХå롥
    // {}
{
    Fetch112 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b1] = doIsBuiltin (x);
    doClose (x);
    JumpNextInstruction ();
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
