/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/builtin.h"
#include "aum/trace.h"
#include "aum/if.h"
#include "aum/compare.h"
#include "builtin/extern.h"

#ifdef PAS_DEBUGGER
#include <stream.h>
#include "class/template.h"
#include "aum/tstream.h"
extern Name print (Word);
#endif

inline JumpType
doIf_ge_with_fixnum (Word ax, Word ay)
    // {}
    //  x ȥ֥ y Ӥx  J_FALSE 򡤤
    // Ǥʤ J_TRUE ֤⤷y ΰ褬ꤷƤʤ
    // 뤤ϥ桼֥Ȥλ 0 ֤
    // {}
{
    Word y = ay;
retry:
    switch (Type_of (y)) {
    case AUm_Atom:
	break;
    case AUm_Fixnum:
	return CompareFixnum (ax, y) < 0 ? J_FALSE : J_TRUE;
	break;
    case AUm_Object:
	if (Is_J_C (y)) {
	    y = Dereference (y);
	    goto retry;
	}
	if (IsDFloat (y))
	    return CompareDFloat (Fix2Double (ax), y) < 0 ? J_FALSE : J_TRUE;
	break;
    default:
	if (IsSFloat (y))
	    return CompareSFloat (Fix2Single (ax), y) < 0 ? J_FALSE : J_TRUE;
	break;
    }
    return J_NEXT;
}

inline int
doIf_ge_with_sfloat (Word ax, Word ay)
    // {}
    // ñư x ȥ֥ y Ӥx 
    // J_FALSE 򡤤Ǥʤ J_TRUE ֤⤷y ΰ褬
    // Ƥʤ뤤ϥ桼֥Ȥλ 0 ֤
    // {}
{
    Word y = ay;
retry:
    switch (Type_of (y)) {
    case AUm_Atom:
	break;
    case AUm_Fixnum:
	return CompareSFloat (ax, Fix2Single (y)) < 0 ? J_FALSE : J_TRUE;
    case AUm_Object:
	if (Is_J_C (y)) {
	    y = Dereference (y);
	    goto retry;
	}
	if (IsDFloat (y))
	    return CompareDFloat (Single2Double (ax), y) < 0 ? J_FALSE : J_TRUE;
	break;
    default:
	if (IsSFloat (y))
	    return CompareSFloat (ax, y) < 0 ? J_FALSE : J_TRUE;
	break;
    }
    return J_NEXT;
}

inline JumpType
doIf_ge_with_dfloat (Word ax, Word ay)
    // {}
    // ư x ȥ֥ y Ӥx 
    // J_FALSE 򡤤Ǥʤ J_TRUE ֤⤷y ΰ褬
    // Ƥʤ뤤ϥ桼֥Ȥλ 0 ֤
    // {}
{
    Word y = ay;
retry:
    switch (Type_of (y)) {
    case AUm_Atom:
	break;
    case AUm_Fixnum:
	return CompareDFloat (ax, Fix2Double (y)) < 0 ? J_FALSE : J_TRUE;
    case AUm_Object:
	if (Is_J_C (y)) {
	    y = Dereference (y);
	    goto retry;
	}
	if (IsDFloat (y))
	    return CompareDFloat (ax, y) < 0 ? J_FALSE : J_TRUE;
	break;
    default:
	if (IsSFloat (y))
	    return CompareDFloat (ax, Single2Double (y)) < 0 ? J_FALSE : J_TRUE;
	break;
    }
    return J_NEXT;
}

static void
doIf_ge ()
    // {}
    // ֥ x ȥ֥ y Ӥx 礭 l_true
    // 򡤤Ǥʤ l_false  IP ˲ä롥⤷y ΰ褬
    // Ƥʤ뤤ϥ桼֥Ȥλϼ̿¹Ԥ롥
    // {}
{
    const If_then_else *const ip = (If_then_else *) InstructionPointer;

#ifdef PAS_DEBUGGER
    extern void message_to_Listener (debugger_symbol, unsigned char *);
    ClassTmpl *ctmpl = CurrentObject->ClassTemplate ();
    stop = (step && (!trace_switch));
    if (trace_switch || stop || CurrentObject->IsTraceObject () ||
	ctmpl->IsTraceClass ()) {
	tstream tout = tstream ();
	tout.form ("%02d:( ", PAS_self_peno);
	tout << print (Reg[ip->ri]) << " >= " << print (Reg[ip->rj]) << " )?\n";
	message_to_Listener (TRECEIVE, (unsigned char *) tout.Result ());
	tout.Initialize ();
    }
    if (next_step) {
	next_step = FALSE;
    }
    else {
	if (stop) {
	    BREAK_LOOP;
	}
    }
#endif

    Word ax = Reg[ip->ri];
    Word ay = Reg[ip->rj];
    Word  x = ax;

    if (TraceMessage)
	mlog_bin (ax, ">=", ay);
retry:
    switch (Type_of (x)) {
    case AUm_Atom:
	break;

    case AUm_Fixnum:
	switch (doIf_ge_with_fixnum (x, ay)) {
	case J_TRUE:
	    InstructionPointer += ip->l_true;
	    doClose (ax);
	    doClose (ay);
	    return;
	case J_FALSE:
	    InstructionPointer += ip->l_false;
	    doClose (ax);
	    doClose (ay);
	    return;
	case J_NEXT:
	    break;
	}
	break;

    case AUm_Object:
	if (Is_J_C (x)) {
	    x = Dereference (x);
	    goto retry;
	}
	if (IsDFloat (x)) {
	    switch (doIf_ge_with_dfloat (x, ay)) {
	    case J_TRUE:
		InstructionPointer += ip->l_true;
		doClose (ax);
		doClose (ay);
		return;
	    case J_FALSE:
		InstructionPointer += ip->l_false;
		doClose (ax);
		doClose (ay);
		return;
	    case J_NEXT:
		break;
	    }
	}
	break;
    default:
	if (IsSFloat (x)) {
	    switch (doIf_ge_with_sfloat (x, ay)) {
	    case J_TRUE:
		InstructionPointer += ip->l_true;
		doClose (ax);
		doClose (ay);
		return;
	    case J_FALSE:
		InstructionPointer += ip->l_false;
		doClose (ax);
		doClose (ay);
		return;
	    case J_NEXT:
		break;
	    }
	    break;

	}
	break;
    }
    InstructionPointer += sizeof (If_then_else) / sizeof (Instruction);
}

METHOD (if_ge, R2L2_OP)
    // {}
    // if_ge Ri, Rj, L1, L2
    // {}
    // [	   address ]
    // [  Ri|  Rj|	 L1]
    // [       L2|	  0]
    // {}
    // Ri  Rj ꤷƤ顤 Ri  Rj Ӥ롥礭
    // ˤϥ٥ L1 ʬǤʤϥ٥ L2 ʬ
    // 롥 Ri  Rj Τɤ餫ꤷƤʤϤޤϥ桼
    // ֥Ȥλˤϲ⤷ʤ
    // {}
{
    doIf_ge ();
#ifdef PAS_DEBUGGER
    if (db_cont == QUIT)
	return;
    JumpNext ();
#else
    DO_TRACE_INSTRUCTION;
    JUMPNEXT;
#endif
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
