/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/close.h"
#include "aum/instantiate.h"
#include "aum/trace.h"

#ifdef PAS_DEBUGGER
#include <stream.h>
#include "class/template.h"
#include "aum/tstream.h"
extern Name print (Word);
#endif

extern int CompareBuiltin (Word x, Word y);

void
doIf_eq ()
    // {}
    // ֥ x ȥ֥ y Ӥ l_true 
    // Ǥʤ l_false  IP ˲ä롥⤷ x ޤ y ΰ
    // ꤷƤʤϼ̿¹Ԥ롥
    // {}
{
    const If_then_else *const ip = (If_then_else *) InstructionPointer;
    Word    ax = Reg[ip->ri];
    Word    ay = Reg[ip->rj];
    Word    x = Dereference (ax);
    Word    y = Dereference (ay);

#ifdef PAS_DEBUGGER
    extern void message_to_Listener (debugger_symbol, unsigned char *);
    ClassTmpl *ctmpl = CurrentObject->ClassTemplate ();
    stop = (step && (!trace_switch));
    if (trace_switch || stop || CurrentObject->IsTraceObject () ||
	ctmpl->IsTraceClass ()) {
	tstream tout = tstream ();
	tout.form ("%02d:(", PAS_self_peno);
	tout << print (Reg[ip->ri]) << " == " << print (Reg[ip->rj]) << ") ?\n";
	message_to_Listener (TRECEIVE, (unsigned char *) tout.Result ());
	tout.Initialize ();
    }
    if (next_step) {
	next_step = FALSE;
    }
    else {
	if (stop) {
	    BREAK_LOOP;
	}
    }
#endif
    if (TraceMessage)
	mlog_bin (x, "==", y);

    if (IsInstantiated_inline (x) && IsInstantiated_inline (y)) {
	InstructionPointer +=
	    (CompareBuiltin (x, y) == 0) ? ip->l_true : ip->l_false;
	doClose (ax);
	doClose (ay);
	return;
    }
    InstructionPointer += sizeof (If_then_else) / sizeof (Instruction);
}

METHOD (if_equal, R2L2_OP)
    // {}
    // if_equal Ri, Rj, L1, L2
    // {}
    // [	   address ]
    // [  Ri|  Rj|	 L1]
    // [       L2|	  0]
    // {}
    // Ri  Rj ꤷƤ顤 Ri  Rj Ӥ롥ϥ
    // ٥ L1 ʬǤʤϥ٥ L2 ʬ롥 Ri 
    //  Rj Τɤ餫ꤷƤʤϤޤϥ桼֥Ȥ
    // ˤϲ⤷ʤ
    // {}
{
    doIf_eq ();

#ifdef PAS_DEBUGGER
    if (db_cont == QUIT)
	return;
    JumpNext ();
#else
    DO_TRACE_INSTRUCTION;
    JUMPNEXT;
#endif
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
