/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/instantiate.h"
#include "aum/stdlib.h"
#include "aum/trace.h"

#ifdef PAS_DEBUGGER
#include <stream.h>
#include "class/template.h"
#include "aum/tstream.h"
#endif

METHOD (if_isbuiltin, R1L2_OP)
    // {}
    // if_isbuiltin Ri, L1, L2;
    // {}
    // [	   address ]
    // [  Ri|	0|	 L1]
    // [       L2|	   ]
    // {}
    // Ri ꤷƤƥȥߥå֥ȤʤХ٥ L1 ˡ
    // ʳΥ֥Ȥλˤϥ٥ L2 ʬ롥Ri ꤷƤ
    // ʤˤϼ̿¹Ԥ롥
    // {}
{
    const If_then_else *const ip = (If_then_else *) InstructionPointer;
    Word    ax = Reg[ip->ri];
    Word    x = Dereference (ax);

#ifdef PAS_DEBUGGER
    extern void message_to_Listener (debugger_symbol, unsigned char *);
    ClassTmpl *ctmpl = CurrentObject->ClassTemplate ();
    stop = (step && (!trace_switch));
    if (trace_switch || stop || CurrentObject->IsTraceObject () ||
	ctmpl->IsTraceClass ()) {
	tstream tout = tstream ();
	tout.form ("%02d:( isbuiltin ", PAS_self_peno);
	tout << print (Reg[ip->ri]) << " )?\n",
	    message_to_Listener (TRECEIVE, (unsigned char *) tout.Result ());
	tout.Initialize ();
    }
    if (next_step) {
	next_step = FALSE;
    }
    else {
	if (stop) {
	    BREAK_LOOP;
	}
    }
#endif
    if (TraceMessage)
	mlog_mon ("isbuiltin", x);

    if (IsInstantiated_inline (x)) {
	switch (Type_of (x)) {
	case AUm_Atom:
	case AUm_Fixnum:
	default:
	    InstructionPointer += ip->l_true;
	    doClose (ax);
	    break;
	case AUm_Object:
	    switch (Pointer (x)->oTag ()) {
	    case BUILTIN:
		InstructionPointer += ip->l_true;
		doClose (ax);
		break;
	    default:
		InstructionPointer +=
		    sizeof (If_then_else) / sizeof (Instruction);
	    }
	    break;
	}
    }
    else
	InstructionPointer += sizeof (If_then_else) / sizeof (Instruction);

#ifdef PAS_DEBUGGER
    DO_TRACE_INSTRUCTION_FOR_DEBUGGER;
    JumpNext();
#else
    DO_TRACE_INSTRUCTION;
    JUMPNEXT;
#endif
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
