/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "aum/fetch.h"
#include "aum/string.h"
#include "aum/builtin.h"
#include "aum/compare.h"
#include "aum/object.h"
#include "aum/derive.h"
#include "builtin/extern.h"
#include "mathematics/ext-conv.h"

extern int CompareString (Word x, Word y);

Word
doGt_with_dfloat (Word ax, Word ay)
    // {}
    // ư x ȥ֥ y Ӥx 礭
    // 򡤤Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // 뤤ϥ桼֥Ȥλϥå롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Gt_p (ax, y);
    if (IsFixnum (y))
	return DFloat_Gt_p (ax, Fix2Double (y));
    if (IsSFloat (y))
	return DFloat_Gt_p (ax, Single2Double (y));
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_GT_DFLOAT, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperDoubleObject, PID_GT, ax, y);
    return BOOLFALSE;
}

Word
doGt_with_fixnum (Word ax, Word ay)
    // {}
    //  x ȥ֥ y Ӥx 礭Ͽ򡤤Ǥ
    // ϵ֤⤷y ΰ褬ꤷƤʤ뤤ϥ桼
    // ֥Ȥλϥå롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsFixnum (y))
	return Fixnum_Gt_p (ax, y);
    if (IsDFloat (y))
	return DFloat_Gt_p (Fix2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Gt_p (Fix2Single (ax), y);
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_GT_FIXNUM, ax);
    return BOOLFALSE;
}

Word
doGt_with_sfloat (Word ax, Word ay)
    // {}
    // ñư x ȥ֥ y Ӥx 礭
    // 򡤤Ǥʤϵ֤⤷y ΰ褬ꤷƤʤ
    // 뤤ϥ桼֥Ȥλϥå롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Gt_p (Single2Double (ax), y);
    if (IsFixnum (y))
	return SFloat_Gt_p (ax, Fix2Single (y));
    if (IsSFloat (y))
	return SFloat_Gt_p (ax, y);
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_GT_SFLOAT, ax);
    return BOOLFALSE;
}

Word
doGt_with_atom (Word ax, Word ay)
    // {}
    // ȥ४֥ x ȥ֥ yӤȤϿ
    // ǤʤȤϡ֤⤷y ΰ褬ꤷƤʤС
    // å롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsAtom (y))
	return (CompareAtom (ax, y) > 0) ? BOOLTRUE : BOOLFALSE;
    if (IsUndefined (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_GT_ATOM, ax);
    return BOOLFALSE;
}

inline Word
doGt_with_string (Word ax, Word ay)
    // {}
    // ʸ x ȥ֥ y Ӥx 礭Ͽ򡤤
    // ʤϵ֤⤷y ΰ褬ꤷƤʤ뤤ϥ桼
    // ֥Ȥλϥå롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsASCII_StrObject (y) || IsEUC_StrObject (y))
	return CompareString (ax, y) > 0 ? BOOLTRUE : BOOLFALSE;
    if (IsJoint (y) || IsUserObject (y))
	return SendBuiltinMessage2 (y, PID_REV_GT_STRING, ax);
    if (IsImported (y))
	return CallAUmProgram (CreateSuperStringObject, PID_GT, ax, y);
    return BOOLFALSE;
}

Word
doGt (Word ax, Word ay)
    // {} @ METHOD BEGIN
    // {} @ CLASS compare
    // {} @ NOTATION X:gt(Y,^Z)
    // {} @ MACRO X > Y = ^Z
    // {} @ MACRO Y <= X = ^Z
    // {} @ EXPLANATION
    // XYӤXY礭ʤ @code{`true} 򡤤Ǥʤ
    // ˤ @code{`false} 򥹥ȥ꡼Z³롥
    // @send_when_cant_execute{Y}{gt(X,^Z)}
    // {} @ METHOD END
{
    Word    x = ax;
    Word    z;
retry:
    switch (Type_of (x)) {
    case AUm_Atom:
	z = doGt_with_atom (x, ay);
	break;
    case AUm_Fixnum:
	z = doGt_with_fixnum (x, ay);
	break;
    default:
	if (IsSFloat (x))
	    z = doGt_with_sfloat (x, ay);
	else if (IsSink (x))
	    z = SINKOBJ;
	else {
	    error (form ("%s:gt(%s,^Z)", print (ax), print (ay)),
		   CAN_NOT_FIND_METHOD,"gt/+-");
	    //errmsg_undefined_method (ax));
	    return SINKOBJ;
	}
	break;
    case AUm_Object:
	switch (Pointer (x)->Type ()) {
	case CONNECTED:
	    x = J_C_ptr (x)->Destination ();
	    goto retry;
	case JOINT:
	case OBJECT:
	case IMPORTED_OBJECT:
	    z = SendBuiltinMessage2 (x, PID_GT, ay);
	    break;
	case ASCII_STR:
	case EUC_STR:
	    z = doGt_with_string (x, ay);
	    break;
	case DFLOAT:
	    z = doGt_with_dfloat (x, ay);
	    break;
	case WC_ASCII_STR:
	    z = ASCII_StrObject_ptr (x)->Suspended_by_elt_index (PID_GT, ay);
	    break;
	case WC_EUC_STR:
	    z = EUC_StrObject_ptr (x)->Suspended_by_elt_index (PID_GT, ay);
	    break;
	default:
	    error (form ("%s:gt(%s,^Z)", print (ax), print (ay)),
		   CAN_NOT_FIND_METHOD,"gt/+-");
	    //errmsg_undefined_method (ax));
	    return SINKOBJ;
	    break;
	}
    }
    doClose (ay);
    return z;
}

METHOD (gt, R3_OP)
    // {}
    // gt Ri, Rj, Rk
    // {}
    // [	   address ]
    // [  Ri|  Rj|  Rk|	  0]
    // {}
    // Ri  Rj Ӥ롥Ri 礭 `true 򤽤Ǥʤ
    // `false Rk ˥åȤ롥
    // {}
{
    Fetch4 ();
    Word    x = Reg[ip->b0];
    Reg[ip->b2] = doGt (x, Reg[ip->b1]);
    doClose (x);
    JumpNextInstruction ();
}

Word
doRevGt_atom (Word ay, Word ax)
    // {}
    // ȥ४֥ x ȥ֥ yӤȤϿ
    // ǤʤȤϡ֤⤷y ΰ褬ꤷƤʤС
    // å롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsAtom (y))
	return (CompareAtom (ax, y) > 0) ? BOOLTRUE : BOOLFALSE;
    return BOOLFALSE;
}

Word
doRevGt_string (Word ay, Word ax)
    // {}
    // ؿ doGt(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡʸ٤Ǥ뤳ȤʬäƤ롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsString (ax))
	return doGt_with_string (ax, y);
    return CallAUmProgram (CreateSuperStringObject, PID_REV_GT_STRING, y, ax);
}

Word
doRevGt_fixnum (Word ay, Word ax)
    // {}
    // ؿ doGt(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡ٤Ǥ뤳ȤʬäƤ롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsFixnum (y))
	return Fixnum_Gt_p (ax, y);
    if (IsDFloat (y))
	return DFloat_Gt_p (Fix2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Gt_p (Fix2Single (ax), y);
    return BOOLFALSE;
}

Word
doRevGt_sfloat (Word ay, Word ax)
    // {}
    // ؿ doGt(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡñư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Gt_p (Single2Double (ax), y);
    if (IsSFloat (y))
	return SFloat_Gt_p (ax, y);
    if (IsFixnum (y))
	return SFloat_Gt_p (ax, Fix2Single (y));
    return BOOLFALSE;
}

Word
doRevGt_dfloat (Word ay, Word ax)
    // {}
    // ؿ doGt(Word, Word) ǰդˤƥåä
    // ν򤹤롥x ϡư٤Ǥ뤳ȤʬäƤ
    // 롥
    // {}
{
    Word    y = Dereference (ay);
    if (IsDFloat (y))
	return DFloat_Gt_p (ax, y);
    if (IsFixnum (y))
	return DFloat_Gt_p (ax, Fix2Double (y));
    if (IsSFloat (y))
	return DFloat_Gt_p (ax, Single2Double (y));
    return BOOLFALSE;
}

/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
